Name:    pgbackrest
Version: 2.57.0
Release: alt2

Summary: Reliable PostgreSQL Backup & Restore
License: MIT
Group:   Other

Url:     https://github.com/pgbackrest/pgbackrest
Source: %name-%version.tar
Source1: %name.conf

BuildRequires(pre): meson

BuildRequires: libpq-devel
BuildRequires: libssl-devel
BuildRequires: libxml2-devel
BuildRequires: libyaml-devel
BuildRequires: zlib-devel
BuildRequires: bzlib-devel
BuildRequires: liblz4-devel
BuildRequires: libzstd-devel
BuildRequires: libssh2-devel

%description
pgBackRest aims to be a reliable, easy-to-use backup and restore \
solution that can seamlessly scale up to the largest databases and \
workloads by utilizing algorithms that are optimized for \
database-specific requirements.

The following features are available:
- Parallel backup & restore
- Local or remote operation
- Full, incremental, differential backups
- Backup rotation & archive expiration
- Backup integrity
- Page checksums
- Backup resume
- Streaming compression & checksums
- Delta restore
- Parallel, asynchronous WAL push & get
- Tablespace & link support
- Amazon S3 support
- Encryption
- Compatibility with PostgreSQL >= 8.3

%prep
%setup

%build
%meson
%meson_build

%install
%meson_install
mkdir -p %buildroot/%_localstatedir/%name/log
mkdir -p %buildroot/%_sysconfdir/%name
cp %SOURCE1 %buildroot/%_sysconfdir/%name/

%files
%doc *.md
%_bindir/*
%dir %attr(700,postgres,postgres) %_localstatedir/%name
%dir %attr(700,postgres,postgres) %_localstatedir/%name/log
%config(noreplace) %_sysconfdir/%name/%name.conf

%changelog
