%define _unpackaged_files_terminate_build 1

%define _runtimedir /run

Name: pesign
Version: 116
Release: alt5

Summary: Signing tool for PE-COFF binaries
License: GPLv3
Group: Development/Other

Url: https://github.com/rhboot/pesign
Source: %name-%version-%release.tar

BuildRequires: libnss-devel
BuildRequires: libpopt-devel
BuildRequires: libefivar-devel
BuildRequires: libuuid-devel
BuildRequires: mandoc

%description
This package contains the pesign utility for signing UEFI binaries
as well as other associated tools.

%prep
%setup -n %name-%version-%release

# fix error: "_FORTIFY_SOURCE" redefined
sed -i -e 's/-D_FORTIFY_SOURCE=2//' Make.defaults

# fcf-protection works for i686 processor or newer
%ifarch i386 i486 i586
sed -i -e '/-fcf-protection/ s/full/none/' Make.defaults
%endif

%ifarch %e2k
# lcc 1.23.20 doesn't do that
sed -i 's,-fshort-wchar,,g' Make.defaults util/Makefile
%endif

# fix gcc10 issue:
#password.c:316:32: error: unknown option after '#pragma GCC diagnostic'
#  316 | #pragma GCC diagnostic ignored "-Wanalyzer-mismatching-deallocation"
#      |                                ^~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
%add_optflags -Wno-error=pragmas

%build
%make_build \
	OPTFLAGS='%optflags' \
	libexecdir=%_libexecdir \
	rundir=%_runtimedir

%install
%makeinstall_std \
	MACROS_DIR=%_rpmmacrosdir \
	libdir=%_libdir \
	libexecdir=%_libexecdir \
	rundir=%_runtimedir

mv %buildroot%_rpmmacrosdir/{macros.,}pesign

%makeinstall_std -C src install_systemd install_sysvinit \
	libexecdir=%_libexecdir \
	INIT_DIR=%_initdir \
	UNIT_DIR=%_unitdir \
	TMPFILES_DIR=%_tmpfilesdir \
	rundir=%_runtimedir

mkdir -pv %buildroot%_runtimedir/pesign/socketdir/
mksock -m666 %buildroot%_runtimedir/pesign/socketdir/socket
touch %buildroot%_runtimedir/pesign/pesign.pid

mkdir -pv %buildroot%_sysconfdir/pki/pesign
touch %buildroot%_sysconfdir/pki/pesign/cert8.db
touch %buildroot%_sysconfdir/pki/pesign/key3.db
touch %buildroot%_sysconfdir/pki/pesign/secmod.db

mkdir -pv %buildroot%_sysconfdir/sysconfig
cat > %buildroot%_sysconfdir/sysconfig/pesign <<EOF
# This is the environment file for pesign daemon.

EXTRAOPTIONS=
EOF

#cleanup
rm -f %buildroot/etc/rpm/macros.pesign

%pre
getent group pesign >/dev/null || groupadd -r pesign
getent passwd pesign >/dev/null ||
	useradd -r -g pesign -d /var/empty -s /dev/null \
		-c 'PE-COFF signing service' pesign

%preun
%preun_service %name

%post
%post_service %name
# handle hasher
if [ $1 = 1 -a -d /.host -a -d /.in -a -d /.out ]; then
	chmod a+rX %_runtimedir/pesign/
fi

%files
%doc README.md COPYING
%_bindir/pesign
%_bindir/pesign-client
%_bindir/pesum
%_bindir/efikeygen
%_bindir/authvar
%_bindir/pesigcheck
%dir %_libexecdir/pesign
%_libexecdir/pesign/pesign-rpmbuild-helper
%dir %_sysconfdir/pesign
%config(noreplace) %_sysconfdir/popt.d/pesign.popt
%config(noreplace) %_sysconfdir/sysconfig/pesign
%_rpmmacrosdir/pesign
%_mandir/man?/*
%_tmpfilesdir/pesign.conf
%_initdir/pesign
%_unitdir/pesign.service
%dir %attr(750,pesign,pesign) %_runtimedir/pesign/
%dir %attr(755,pesign,pesign) %_runtimedir/pesign/socketdir/
%ghost %attr(666,pesign,pesign) %_runtimedir/pesign/socketdir/socket
%ghost %_runtimedir/pesign/pesign.pid
%dir %attr(570,pesign,root) %_sysconfdir/pki/pesign
%ghost %attr(570,pesign,root) %_sysconfdir/pki/pesign/cert8.db
%ghost %attr(570,pesign,root) %_sysconfdir/pki/pesign/key3.db
%ghost %attr(570,pesign,root) %_sysconfdir/pki/pesign/secmod.db

%changelog
