Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
%filter_from_requires /^perl.XML.SAX.ExpatXS.Preload.pm./d
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-XML-SAX-ExpatXS
Version:        1.33
Release:        alt4_24
Summary:        Perl SAX 2 XS extension to Expat parser
License:        GPL+ or Artistic
URL:            https://metacpan.org/release/XML-SAX-ExpatXS
Source0:        https://cpan.metacpan.org/authors/id/P/PC/PCIMPRICH/XML-SAX-ExpatXS-%{version}.tar.gz
BuildRequires:  gcc-c++
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(Config.pm)
BuildRequires:  perl(DynaLoader.pm)
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(IO/File.pm)
BuildRequires:  perl(Test.pm)
BuildRequires:  perl(vars.pm)
BuildRequires:  perl(XML/SAX/Base.pm)
BuildRequires:  perl(XML/SAX.pm)
BuildRequires:  libexpat-devel
Requires:       perl(XML/SAX.pm) >= 0.960

 # Filters (not)shared c libs
Source44: import.info

%description
XML::SAX::ExpatXS is a direct XS extension to Expat XML parser. It
implements Perl SAX 2.1 interface. See http://perl-xml.sourceforge.net/perl-
sax/ for Perl SAX API description. Any deviations from the Perl SAX 2.1
specification are considered as bugs.

%prep
%setup -q -n XML-SAX-ExpatXS-%{version}
chmod -x ExpatXS.xs

%build
echo n | /usr/bin/perl Makefile.PL INSTALLDIRS=vendor OPTIMIZE="$RPM_OPT_FLAGS"
%make_build

%install
make pure_install DESTDIR=$RPM_BUILD_ROOT

find $RPM_BUILD_ROOT -type f -name .packlist -exec rm -f {} \;
find $RPM_BUILD_ROOT -type f -name '*.bs' -size 0 -exec rm -f {} \;

# %{_fixperms} $RPM_BUILD_ROOT/*

%check
make test

%triggerin -- perl-XML-SAX
%{__perl} -MXML::SAX -e \
  'XML::SAX->add_parser(q(XML::SAX::ExpatXS))->save_parsers()' 2>/dev/null || :

%preun
if [ $1 -eq 0 ]; then
 %{__perl} -MXML::SAX -e \
    'XML::SAX->remove_parser(q(XML::SAX::ExpatXS))->save_parsers()' \
    2>/dev/null || :
fi

%files
%doc Changes README
%{perl_vendor_archlib}/auto/*
%{perl_vendor_archlib}/XML*

%changelog
