%define _unpackaged_files_terminate_build 1
Epoch: 4
Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(LWP/UserAgent.pm) perl(Net/FTP.pm) perl-podlators unzip
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global extraversion	%{nil}
%global extrasuffix	%{nil}

Summary:	Perl interface to PARI
Name:		perl-Math-Pari
Version:	2.030528
Release:	alt1
License:	GPL+ or Artistic
URL:		https://metacpan.org/release/Math-Pari
Source0:	http://www.cpan.org/authors/id/I/IL/ILYAZ/modules/Math-Pari-%{version}.tar.gz
Patch0:		Math-Pari-2.030518-system-pari.patch
Patch1:		Math-Pari-2.030506-docs-and-testsuite.patch
Patch3:		Math-Pari-2.030512-utf8.patch
Patch4:		Math-Pari-2.030506-escape-left-braces-in-regex.patch
Patch5:		Math-Pari-2.030518-MP_NOGNUPLOT.patch
# Module Build
BuildRequires:	coreutils
BuildRequires:	findutils
BuildRequires:	gcc
BuildRequires:	libpari23-devel
BuildRequires:	perl-devel
BuildRequires:	perl-devel
BuildRequires:	rpm-build-perl
BuildRequires:	perl(Config.pm)
BuildRequires:	perl(Cwd.pm)
BuildRequires:	perl(ExtUtils/Constant.pm)
BuildRequires:	perl(ExtUtils/MakeMaker.pm)
BuildRequires:	perl(File/Basename.pm)
BuildRequires:	perl(File/Copy.pm)
BuildRequires:	perl(strict.pm)
BuildRequires:	sed
# Module Runtime
BuildRequires:	perl(Carp.pm)
BuildRequires:	perl(DynaLoader.pm)
BuildRequires:	perl(Exporter.pm)
BuildRequires:	perl(overload.pm)
BuildRequires:	perl(subs.pm)
# Test Suite
# (no additional dependencies)
# Dependencies

# Enforce dependency against same version of pari that we're built for
Requires:	libpari23 = %(pkg-config --modversion libpari23 2>/dev/null || echo 0)
Source44: import.info

# Don't "provide" private Perl libs or the redundant unversioned perl(Math::Pari)

%description
This package is a Perl interface to the famous library PARI for numerical/
scientific/ number-theoretic calculations. It allows use of most PARI functions
as Perl functions, and (almost) seamless merging of PARI and Perl data.

%prep
%setup -q -n Math-Pari-%{version}

# Create a directory structure for libpari23 like Math::Pari expects it to be
mkdir libpari23
ln -s $(pkg-config --cflags-only-I libpari23 | sed -e 's/-I//') libpari23/include
ln -s $(pkg-config --variable=paridir libpari23)/src libpari23/src

# Fix for using system pari library (with source available)
%patch0

# We want to build the docs and test suite too
%patch1

# Recode Changes file as UTF-8
%patch3

# Escape left braces in regexes (#1452519)
#patch4

# Fix operation of MP_NOGNUPLOT
%patch5

# Don't try to fiddle with compiler flags, we'll set them ourselves anyway
#patch6

%build
paridir=$(pkg-config --variable=paridir libpari23)
perl Makefile.PL \
	INSTALLDIRS=vendor \
	NO_PACKLIST=1 \
	NO_PERLLOCAL=1 \
	OPTIMIZE="$(pkg-config --cflags-only-I libpari23) %{optflags}" \
	paridir="${paridir}" \
	pariincludes=$(pwd)/libpari23 \
	parilibs="$(pkg-config --libs libpari23)"
%{make_build}

%install
%{makeinstall_std}
find %{buildroot} -type f -name '*.bs' -empty -delete
# %{_fixperms} -c %{buildroot}

%check
make test MP_NOGNUPLOT=1

%files
%doc Changes README README-after2_3_5 README-func_codes_h TODO-probably-obsolete
%dir %{perl_vendor_archlib}/Math/
%exclude %doc %{perl_vendor_archlib}/Math/libPARI.dumb.pod
%doc %{perl_vendor_archlib}/Math/libPARI.pod
%{perl_vendor_archlib}/Math/*.pm
%{perl_vendor_archlib}/auto/Math/

%changelog
