# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Devel/Size.pm) perl(File/Find/Object.pm) perl(HTML/TokeParser.pm) perl(IO/All.pm) perl(LWP.pm) perl(Pod/Usage.pm) perl(Test/Run/CmdLine/Iface.pm) perl-podlators
# END SourceDeps(oneline)
%filter_from_requires /^perl.Graph.Easy.As_svg/d
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Graph-Easy
Version:        0.76
Release:        alt1_4
Summary:        Convert or render graphs as ASCII, HTML, SVG or via Graphviz
License:        GPLv2+ and ASL 1.1
Group:          Development/Other
URL:            http://search.cpan.org/dist/Graph-Easy/
Source0:        http://www.cpan.org/authors/id/S/SH/SHLOMIF/Graph-Easy-%{version}.tar.gz
Patch0:         graph-easy-undefined-lc.patch
BuildArch:      noarch
BuildRequires:  perl-devel >= 0:5.008002
BuildRequires:  rpm-build-perl
BuildRequires:  perl(base.pm)
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(constant.pm)
BuildRequires:  perl(Data/Dumper.pm)
BuildRequires:  perl(Encode.pm)
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(File/Spec.pm)
BuildRequires:  perl(lib.pm)
BuildRequires:  perl(List/Util.pm)
BuildRequires:  perl(Module/Build.pm)
BuildRequires:  perl(Pod/Coverage.pm)
BuildRequires:  perl(Scalar/Util.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(Test/Differences.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(Test/Pod.pm)
BuildRequires:  perl(Test/Pod/Coverage.pm)
BuildRequires:  perl(utf8.pm)
BuildRequires:  perl(vars.pm)
BuildRequires:  perl(warnings.pm)
Requires:       perl(Carp.pm)
Requires:       perl(Data/Dumper.pm)

# avoid circular dependencies
%bcond_without bootstrap
%if %{without bootstrap}
BuildRequires:  perl(Graph/Easy/As_svg.pm)
Requires:       perl(Graph/Easy/As_svg.pm) >= 0.230
%endif

# filter unversioned provides


Source44: import.info
%filter_from_provides /perl\\(Graph.Easy.pm\\)$/d
%filter_from_provides /perl\\(Graph.Easy.(Edge|Edge.Cell|Group|Node).pm\\)$/d

%description
Graph::Easy lets you generate graphs consisting of various shaped nodes
connected by edges (with optional labels). It can read and write graphs in a
variety of formats, as well as render them via its own grid-based layouter.
Since the layouter works on a grid (manhattan layout), the output is most
useful for flow charts, network diagrams, or hierarchy trees.

%prep
%setup -q -n Graph-Easy-%{version}
%patch0 -p 1

chmod 0644 examples/*

%build
perl Makefile.PL INSTALLMAN1DIR=%_man1dir INSTALLDIRS=vendor
%make_build

%install
make pure_install DESTDIR=$RPM_BUILD_ROOT
find $RPM_BUILD_ROOT -type f -name .packlist -exec rm -f {} \;
# %{_fixperms} $RPM_BUILD_ROOT/*

%check
make test

%files
%doc CHANGES LICENSE README TODO examples
%{_bindir}/*
%{_mandir}/man1/*
%{perl_vendor_privlib}/*

%changelog
