%define _unpackaged_files_terminate_build 1
#set_perl_req_method relaxed
%define module_name Future-AsyncAwait
%def_without bootstrap

#BuildRequires: perl(Devel/MAT.pm) perl(Devel/MAT/Dumper.pm)
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/CBuilder.pm) perl(File/ShareDir.pm) perl(Future.pm) perl(IO/Async/Loop.pm) perl(Module/Build.pm) perl(Role/Tiny.pm) perl(Role/Tiny/With.pm) perl(Test/Fatal.pm) perl(Test/Future/Deferred.pm) perl(Test/MemoryGrowth.pm) perl(Test/More.pm) perl(Test/Refcount.pm) perl(Test2/V0.pm) perl(XS/Parse/Keyword.pm) perl(XS/Parse/Keyword/Builder.pm) perl(XS/Parse/Sublike.pm) perl(XS/Parse/Sublike/Builder.pm) perl(experimental.pm)
# END SourceDeps(oneline)
BuildRequires: rpm-build-perl perl-devel perl-podlators

%if_with bootstrap
# bootstrap loop with Syntax/Keyword* and Future-AsyncAwait
%define _without_test 1
%else
BuildRequires: /proc
#BuildRequires: perl(Devel/MAT.pm) perl(Devel/MAT/Dumper.pm)
BuildRequires: perl(Object/Pad.pm)
BuildRequires: perl(Syntax/Keyword/Defer.pm) perl(Syntax/Keyword/Dynamically.pm) perl(Syntax/Keyword/Match.pm) perl(Syntax/Keyword/MultiSub.pm) perl(Syntax/Keyword/Try.pm)
%endif

Name: perl-%module_name
Version: 0.71
Release: alt1
Summary: deferred subroutine syntax for futures
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://www.cpan.org/authors/id/P/PE/PEVANS/%{module_name}-%{version}.tar.gz

%description
This module provides syntax for deferring and resuming subroutines
while waiting for Futures to complete. This syntax aims to make code
that performs asynchronous operations using futures look neater and
more expressive than simply using then chaining and other techniques on
the futures themselves. It is also a similar syntax used by a number of
other languages; notably C# 5, EcmaScript 6, Python 3, Dart, Rust, C++20.

This module is still under active development. While it now seems
relatively stable enough for most use-cases and has received a lot of
"battle-testing" in a wide variety of scenarios, there may still be the
occasional case of memory leak left in it, especially if still-pending
futures are abandoned.

The new syntax takes the form of two new keywords, async and await.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_archlib/F*
%perl_vendor_archlib/Test/Future/AsyncAwait/Awaitable.pm
%perl_vendor_autolib/*

%changelog
