%define _unpackaged_files_terminate_build 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(DateTime/Locale.pm)
# END SourceDeps(oneline)
%define dist DateTime-TimeZone
%def_without bootstrap
Name: perl-%dist
Version: 2.65
Release: alt1

Summary: Time zone object base class and factory
License: GPL or Artistic
Group: Development/Perl

URL: %CPAN %dist
Source0: http://www.cpan.org/authors/id/D/DR/DROLSKY/%{dist}-%{version}.tar.gz

BuildArch: noarch

# avoid rpmdb bloat
%add_findprov_skiplist */DateTime/TimeZone/Africa/*
%add_findprov_skiplist */DateTime/TimeZone/America/*
%add_findprov_skiplist */DateTime/TimeZone/Antarctica/*
%add_findprov_skiplist */DateTime/TimeZone/Asia/*
%add_findprov_skiplist */DateTime/TimeZone/Atlantic/*
%add_findprov_skiplist */DateTime/TimeZone/Australia/*
%add_findprov_skiplist */DateTime/TimeZone/Europe/*
%add_findprov_skiplist */DateTime/TimeZone/Indian/*
%add_findprov_skiplist */DateTime/TimeZone/Pacific/*

%if_with bootstrap
# bootstrap: disable circular dependencies on DateTime
%add_findreq_skiplist */DateTime/TimeZone/*
# bootstrap: some dependencies have to be re-added manually
Requires: perl-Class-Load perl-Class-Singleton perl-Params-Validate perl-parent
%else
BuildRequires: perl-DateTime perl(Test/Requires.pm) perl(List/AllUtils.pm) perl(Test/Fatal.pm)
%endif

BuildRequires: perl-Class-Load perl-Class-Singleton perl-Test-Output perl-Params-Validate perl-parent

# perl -c fails; let us skip it as in debian
#add_findreq_skiplist */DateTime/TimeZone/OffsetOnly.pm
#add_findreq_skiplist */DateTime/TimeZone.pm
# and add requires manually
Requires: perl(Module/Runtime.pm) perl(Params/ValidationCompiler.pm) perl(Specio/Library/Builtins.pm) perl(Specio/Library/String.pm) perl(Try/Tiny.pm)


%description
The DateTime::TimeZone modules provide a Perl interface to the Olson
time zone database.  Rather than using the database directly, we parse
the database files and turn them into a set of modules, one for each
time zone defined.  This allows for various optimizations in doing
time zone calculations.  This conversion is done with the script in
tools/parse_olson.

The Olson time zone database is the best available source for world
wide time zone information.  It is available from
ftp://elsie.nci.nih.gov/pub/.  A good starting point for information
on the database, and time zones in general, is
http://www.twinsun.com/tz/tz-link.htm.

%prep
%setup -q -n %{dist}-%{version}

# avoid build dependency on perl-podlators
sed -i- '/Pod::Man/d' Makefile.PL

%if_with bootstrap
# bootstrap: avoid build dependency on DateTime
sed -i- 's/eval "use DateTime/eval "die/' t/check_datetime_version.pl
%endif

if [ %version != 2.23 ]; then
    echo update manual requires due to findreq_skiplist!
    #exit 1
fi

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.md CONTRIBUTING.md
%perl_vendor_privlib/DateTime

%changelog
