# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CPAN.pm) perl(Crypt/URandom.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Data-Entropy
%define upstream_version 0.007

Name:       perl-%{upstream_name}
Version:    0.008
Release:    alt1

Summary:    Download entropy from
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        http://search.cpan.org/dist/%{upstream_name}
Source0:    http://www.cpan.org/authors/id/R/RR/RRWO/%{upstream_name}-%{version}.tar.gz

BuildRequires: perl(Carp.pm)
BuildRequires: perl(Crypt/Rijndael.pm)
BuildRequires: perl(Data/Float.pm)
BuildRequires: perl(Errno.pm)
BuildRequires: perl(Exporter.pm)
BuildRequires: perl(HTTP/Lite.pm)
BuildRequires: perl(IO/File.pm)
BuildRequires: perl(Module/Build.pm)
BuildRequires: perl(Params/Classify.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(constant.pm)
BuildRequires: perl(integer.pm)
BuildRequires: perl(parent.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(warnings.pm)
BuildArch:  noarch
Source44: import.info

%description
This module maintains a concept of a current selection of entropy source.
Algorithms that require entropy, such as those in the
Data::Entropy::Algorithms manpage, can use the source nominated by this
module, avoiding the need for entropy source objects to be explicitly
passed around. This is convenient because usually one entropy source will
be used for an entire program run and so an explicit entropy source
parameter would rarely vary. There is also a default entropy source,
avoiding the need to explicitly configure a source at all.

If nothing is done to set a source then it defaults to the use of Rijndael
(AES) in counter mode (see the Data::Entropy::RawSource::CryptCounter
manpage and the Crypt::Rijndael manpage), keyed using Perl's built-in
'rand' function. This gives a data stream that looks like concentrated
entropy, but really only has at most the entropy of the 'rand' seed. Within
a single run it is cryptographically difficult to detect the correlation
between parts of the pseudo-entropy stream. If more true entropy is
required then it is necessary to configure a different entropy source.

%prep
%setup -q -n %{upstream_name}-%{version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%make

%check
make test

%install
%makeinstall_std

%files
%doc Changes META.json META.yml README SIGNATURE SECURITY.md
%perl_vendor_privlib/*

%changelog
