Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl rpm-build-licenses
BuildRequires: perl-podlators
# END SourceDeps(oneline)
%define real_name Crypt-CipherSaber
Name:           perl-Crypt-CipherSaber
Version:        1.01
Release:        alt3
Summary:        Perl module implementing CipherSaber encryption
License:        %perl_license
URL:            https://metacpan.org/release/%real_name
Source0:        https://cpan.metacpan.org/modules/by-module/Crypt/%real_name-%version.tar
# Fix parsing encrypted file, bug #1104075, CPAN RT#28370
Patch0:         Crypt-CipherSaber-1.01-Fix-reading-IV-with-new-lines-from-a-file.patch
BuildArch:      noarch
BuildRequires:  coreutils
BuildRequires:  perl-devel
BuildRequires:  perl(Module/Build.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# Run-time:
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(Scalar/Util.pm)
BuildRequires:  perl(vars.pm)
# Tests:
BuildRequires:  perl(File/Spec.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(Test/Warn.pm)

# Filter under-specified dependencies
%filter_from_requires /^perl(Scalar.Util.pm)/d

%description
The Crypt::CipherSaber module implements CipherSaber encryption, described
at http://ciphersaber.gurus.com/. It is simple, fairly speedy, and
relatively secure algorithm based on RC4.

%prep
%setup -q -n %real_name-%version
%patch0 -p1
rm *.list ||:

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/*

%changelog
