%define _unpackaged_files_terminate_build 1
%define module_name CBOR-XS
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Canary/Stability.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Math/BigFloat.pm) perl(Math/BigInt.pm) perl(Math/BigRat.pm) perl(Time/Piece.pm) perl(Types/Serialiser.pm) perl(URI.pm) perl(XSLoader.pm) perl(common/sense.pm)
# END SourceDeps(oneline)
Epoch: 2
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.87
Release: alt1
Summary: Concise Binary Object Representation (CBOR, RFC7049)
Group: Development/Perl
License: GPL-3
Url: %CPAN %module_name

Source0: http://www.cpan.org/authors/id/M/ML/MLEHMANN/%{module_name}-%{version}.tar.gz

%description
This module converts Perl data structures to the Concise Binary Object
Representation (CBOR) and vice versa. CBOR is a fast binary serialisation
format that aims to use an (almost) superset of the JSON data model, i.e.
when you can represent something useful in JSON, you should be able to
represent it in CBOR.

In short, CBOR is a faster and quite compact binary alternative to JSON,
with the added ability of supporting serialisation of Perl objects. (JSON
often compresses better than CBOR though, so if you plan to compress the
data later and speed is less important you might want to compare both
formats first).

To give you a general idea about speed, with texts in the megabyte range,
`CBOR::XS' usually encodes roughly twice as fast as the Storable manpage or
the JSON::XS manpage and decodes about 15%%%%-30%%%% faster than those. The shorter the
data, the worse the Storable manpage performs in comparison.

Regarding compactness, `CBOR::XS'-encoded data structures are usually
about 20%%%% smaller than the same data encoded as (compact) JSON or
the Storable manpage.

In addition to the core CBOR data format, this module implements a
number of extensions, to support cyclic and shared data structures
(see `allow_sharing' and `allow_cycles'), string deduplication (see
`pack_strings') and scalar references (always enabled).

The primary goal of this module is to be *correct* and the secondary goal
is to be *fast*. To reach the latter goal it was written in C.

See MAPPING, below, on how CBOR::XS maps perl values to CBOR values and
vice versa.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_archlib/C*
%perl_vendor_autolib/*

%changelog
