Name: pdfedit
Version: 0.4.5
Release: alt6

Summary: Editor for manipulating PDF documents
License: GPLv2
Group: File tools

Url: http://pdfedit.cz
Source0: %name-%version.tar.bz2
Source1: %name.desktop
Source100: %name.watch
Patch0: pdfedit-0.4.1-alt-fontpath.patch
Patch2: pdfedit-0.4.5-alt-docbook.patch
Patch3: pdfedit-0.4.5-alt-libpng15.patch
Patch5: pdfedit-0.4.5-format.patch
Patch6: pdfedit-0.4.5-alt-fixes.patch

Packager: Michael Shigorin <mike@altlinux.org>

Requires: fonts-type1-urw

# Automatically added by buildreq on Tue Apr 07 2009
BuildRequires: boost-devel gcc-c++ imake libqt3-devel t1lib-devel xorg-cf-files

BuildPreReq: /proc xsltproc docbook5-style-xsl
BuildPreReq: boost-program_options-devel libpng-devel

%{?!_desktopdir:%define _desktopdir %_datadir/applications}

%description
Complete editing of pdf documents is made possible with PDFedit.
You can change either raw pdf objects (for advanced users) or use
predefined gui functions. Functions can be easily added as everything
is based on a scripts.

Scripting is used to a great extent in editor and almost anything can
be scripted, it is possible to create own scripts or plugins.

%package manual
Summary: User manual for PDFedit
Group: Documentation
BuildArch: noarch

%description manual
Complete editing of pdf documents is made possible with PDFedit.
You can change either raw pdf objects (for advanced users) or use
predefined gui functions. Functions can be easily added as everything
is based on a scripts.

This package contains user manual for PDFedit.

%prep
%setup
%patch0 -p1
%patch2 -p2
%patch3 -p2
sed -i 's,bin/qmake,& "CONFIG+=no_fixpath",' src/Makefile
%patch5 -p1
%patch6 -p2
sed -i 's/-D_FORTIFY_SOURCE=2/-U_FORTIFY_SOURCE & -g -fpermissive/' configure.in
sed -i 's/-posix /-Wno-write-strings /' Makefile.flags.in
sed -i 's/-std=c++98/-std=c++11/' Makefile.flags.in
sed -i -E 's/(^|[^:/])(weak_ptr|shared_ptr)/\1boost::\2/g' \
	src/{kernel,gui,tools}/*.cc

%build
export PATH=$PATH:%_qt3dir/bin
cp -aLt . -- /usr/share/automake/config.{guess,sub}
# see README
autoreconf -fisv
%configure \
	--enable-stack-protector \
	--with-root-dir=%buildroot \
	--with-boost-lib=%_libdir \
	--docdir='$(datarootdir)/doc/$(package_name)-$(version)' \
	--with-boost-program-options=mt \
	--enable-user-manual \
	--enable-pdfedit-core-dev \
	--enable-tools
%make

%install
export PATH=$PATH:%_qt3dir/bin
%makeinstall_std
install -pDm644 %SOURCE1 %buildroot%_desktopdir/%name.desktop

%files
%_bindir/*
%exclude %_bindir/pdfedit-core-dev-config
%_datadir/%name/
%_desktopdir/*
%_man1dir/*
%doc Changelog README

%files manual
%doc doc/user/OEBPS/*

%changelog
