Name: pcsc-lite-ccid
Version: 1.7.0
Release: alt1

Summary: Generic USB CCID smart card reader driver
License: BSD-3-Clause AND GPL-2.0-or-later AND LGPL-2.1-or-later
Group: System/Libraries
URL: https://ccid.apdu.fr

Requires: pcsc-lite

Source: %name-%version.tar

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson
BuildRequires: flex
BuildRequires: pkgconfig(libpcsclite) pkgconfig(libusb-1.0) pkgconfig(zlib) pkgconfig(udev)

Provides: ccid = %version-%release
Obsoletes: ccid < %version-%release
Conflicts: pcsc-lite-openct
Requires(pre): pcsc-lite
Provides: pcsc-ifd-handler

%define ifddir %(pkg-config libpcsclite --variable=usbdropdir)

%description
Generic USB CCID (Chip/Smart Card Interface Devices) driver for use with the
PC/SC Lite daemon.

%prep
%setup

%build
%meson -Dserial=true
%meson_build

%install
%meson_install

%post
# Restart pcscd
%post_service pcscd

%files
%doc AUTHORS README.md
%config(noreplace) %_sysconfdir/reader.conf.d/libccidtwin
%ifddir/ifd-ccid.bundle
%_libdir/pcsc/drivers/serial/libccidtwin.so
%_udev_rulesdir/92_pcscd_ccid.rules

%changelog
