%define _unpackaged_files_terminate_build 1

%ifarch %ix86 %e2k %mips riscv64
#shellcheck is not available or it is slow on these architectures
%def_disable check
%endif

Name: pc-test
Version: 2.1.6
Release: alt1

Summary: PC Test Suite
Group: System/Configuration/Hardware
License: GPLv3+

BuildArch: noarch

Url: https://github.com/klark973/pc-test
Source: %name-%version.tar
AutoReq: noshell, noshebang

%{!?_disable_check:BuildRequires: shellcheck}

# Strict dependencies inside rootfs or on installation media
Requires: coreutils util-linux rpm apt apt-repo su sudo
Requires: bash update-kernel pciutils usbutils iproute2

# Other optional and essential dependencies.
# See /usr/libexec/pc-test/steps/upgrade.sh
# and /usr/libexec/pc-test/steps/install.sh
# for more details.
#
#Requires: inxi
#Requires: dialog
#Requires: yad
#Requires: fwupd
#Requires: lsscsi
#Requires: libibverbs-utils
#Requires: hdparm
#Requires: rfkill
#Requires: lsblk
#Requires: stress-ng
#Requires: cpupower
#Requires: eject
#Requires: sos
#Requires: system-report
#Requires: iputils
#Requires: iperf3
#Requires: acpica
#Requires: dmidecode
#Requires: smartmontools
#Requires: numactl
#Requires: squashfs-tools
#Requires: htop
#Requires: ipmitool
#Requires: alsa-utils
#Requires: aplay
#Requires: bluez
#Requires: upower
#Requires: xrandr
#Requires: /usr/bin/glxinfo
#Requires: kamoso
#Requires: vlc
#Requires: cheese
#Requires: icon-theme-adwaita
#Requires: sound-theme-freedesktop
#Requires: fprintd
#Requires: pcsc-lite-ccid
#Requires: libpcsclite
#Requires: pcsc-tools
#Requires: opensc
#Requires: pcsc-lite
#Requires: fio
#Requires: glmark2
#Requires: xdg-open
#Requires: pactl
#Requires: paplay
#Requires: notify-send
#Conflicts: openct
#Conflicts: pcsc-lite-openct
#Conflicts: libopenct

Packager: Leonid Krivoshein <klark@altlinux.org>

%description
Computers and servers test suite special for ALT Linux.
It supports all products, based on p9, p10, c9f1, c9f2,
c10f1 and c10f2 stable branches and also Sisyphus-based
regular builds.

%package doc
Summary: PC Test Suite documentation
Group: Documentation
BuildArch: noarch
AutoReq: noshell, noshebang

%description doc
Documentation and screenshoots for PC Test Suite.

%prep
%setup -q
%autopatch -p1

%build
chmod 0755  ".%_bindir/%name" \
	    "./usr/libexec/%name/resume.sh" \
	    "./usr/libexec/%name/launcher.sh"
touch ".%_sysconfdir/%name-RVSETS.txt"
cat >"./usr/libexec/%name/version.sh" <<EOF
# Auto-generated by the build system, do not edit directly!
#
readonly PCTEST_VERSION="%version"
readonly PCTEST_BUILD_DATE="$(date '+%%Y%%m%%d')"

EOF

%install
mkdir -p -m 0755 -- "%buildroot"
cp -aRf etc usr var "%buildroot/"

%post
# This is necessary to update settings of older versions
a="^(# Allow \\w+ to execute) %_bindir/%name without a password$"
b="\\1 %name and dmesg"
sed -i -E "s|$a|$b|g" /etc/sudoers
a="^(\\w+ ALL=\\(ALL:ALL\\) NOPASSWD: %_bindir/%name)$"
b="\\1,$(which dmesg)"
sed -i -E "s|$a|$b|g" /etc/sudoers

%check
./check-scripts.sh

%files
%config(noreplace) %_sysconfdir/%name.conf
%config(noreplace) %ghost %_sysconfdir/%name-RVSETS.txt
%_bindir/%name
/usr/libexec/%name
/usr/share/applications/%name.desktop
%_localstatedir/%name
%ghost %_logdir/%name.log

%files doc
%doc img html CHANGELOG.md LICENSE README.md

%changelog
