Name:    patroni
Version: 4.1.0
Release: alt1

Summary: A template for PostgreSQL High Availability with Etcd, Consul, ZooKeeper, or Kubernetes
License: MIT
Group:   Other
URL:     https://github.com/zalando/patroni

Packager: Andrey Cherepanov <cas@altlinux.org>

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-dev
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: python3-module-psycopg2

BuildArch: noarch

Source: %name-%version.tar
# https://salsa.debian.org/postgresql/patroni.git
Patch0: patroni-4.0.4-debian-avoid-overwriting-configuration-during-boostrap.patch
Patch1: patroni-4.0.4-debian-startup-scripts.patch

# From requirements.txt
Requires: python3-module-urllib3 >= 1.19.1
Requires: python3(boto3)
Requires: python3(yaml)
Requires: python3-module-kazoo >= 1.3.1
Requires: python3-module-etcd >= 0.4.3
Requires: python3-module-consul >= 0.7.1
Requires: python3-module-click >= 4.1
Requires: python3-module-prettytable >= 0.7
Requires: python3-module-pysyncobj >= 0.3.8
Requires: python3-module-cryptography >= 1.4
Requires: python3-module-psutil >= 2.0.0
Requires: python3-module-ydiff >= 1.2

%description
Patroni is a template for you to create your own customized, high-availability
solution using Python and - for maximum accessibility - a distributed
configuration store like ZooKeeper, etcd, Consul or Kubernetes. Database
engineers, DBAs, DevOps engineers, and SREs who are looking to quickly deploy
HA PostgreSQL in the datacenter-or anywhere else-will hopefully find it useful.

We call Patroni a "template" because it is far from being a one-size-fits-all
or plug-and-play replication system. It will have its own caveats. Use wisely.

%prep
%setup -n %name-%version
%autopatch -p1
sed -i 's|/etc/patroni_env.conf|/etc/patroni/env.conf|' \
  extras/startup-scripts/patroni.service

%build
%pyproject_build

%install
%pyproject_install
install -D -m 644 extras/startup-scripts/patroni.service %buildroot%_unitdir/patroni.service
install -D /dev/null %buildroot%_sysconfdir/patroni/config.yml
install -D /dev/null %buildroot%_sysconfdir/patroni/env.conf

%files
%doc CODEOWNERS MAINTAINERS README.rst
%_bindir/*
%dir %_sysconfdir/%name/
%config(noreplace) %_sysconfdir/%name/*
%_unitdir/patroni.service
%python3_sitelibdir/%name/
%python3_sitelibdir/%{pyproject_distinfo %name}

%changelog
