%def_disable snapshot
%define _name Paper-Clip
%define binary_name pdf-metadata-editor
%define ver_major 5.5
%define rdn_name io.github.diegoivan.pdf_metadata_editor

%def_enable check

Name: paper-clip
Version: %ver_major.2
Release: alt1

Summary: PDF metadata editor for GNOME
License: GPL-3.0-or-later
Group: Graphical desktop/GNOME
Url: https://github.com/Diego-Ivan/Paper-Clip

Vcs: https://github.com/Diego-Ivan/Paper-Clip.git

%if_disabled snapshot
Source: %url/archive/v%version/%_name-%version.tar.gz
%else
Source: %_name-%version.tar
%endif

%define gtk_ver 4.10
%define adwaita_ver 1.5

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson vala-tools
BuildRequires: pkgconfig(gtk4) >= %gtk_ver
BuildRequires: pkgconfig(libadwaita-1) >= %adwaita_ver
BuildRequires: pkgconfig(poppler-glib)
BuildRequires: pkgconfig(exempi-2.0)
%{?_enable_check:BuildRequires: /usr/bin/appstreamcli desktop-file-utils}

%description
%summary

%prep
%setup -n %_name-%version

%build
%meson
%meson_build

%install
%meson_install
%find_lang %binary_name

%check
%__meson_test

%files -f %binary_name.lang
%_bindir/%binary_name
%_desktopdir/%rdn_name.desktop
%_datadir/glib-2.0/schemas/%rdn_name.gschema.xml
%_datadir/dbus-1/services/%rdn_name.service
%_iconsdir/hicolor/*/apps/%{rdn_name}*.svg
%_datadir/metainfo/%rdn_name.metainfo.xml
%doc README*


%changelog
