Name: pam-redhat
Version: 1.0.0
Release: alt2

Summary: Red Hat additional Pluggable Authentication Modules
License: GPL-2.0-or-later
Group: System/Base
Url: https://releases.pagure.org/pam-redhat/

%define _secdir %_sysconfdir/security

Source: %name-%version-%release.tar

BuildRequires(pre): rpm-macros-pam
BuildRequires: flex libpam-devel >= 1.7.0-alt1

%package -n %{make_pam_name console}
Summary: PAM console session module
License: GPL-2.0-or-later
Group: System/Base
Epoch: 1
Provides: pam_console = %epoch:%version-%release
Obsoletes: pam_console, pam_console0
Provides: %_secdir/console.apps
Provides: /sbin/pam_console_apply

%package -n %{make_pam_name chroot}
Summary: PAM chroot session module
License: GPL-2.0-or-later
Group: System/Base
Epoch: 1
Provides: pam_chroot = %epoch:%version-%release
Obsoletes: pam_chroot
Conflicts: pam < 0:1.1.0-alt4

%description
This package contains PAM modules created and developed primarily by
Red Hat, Inc.  Because of their limited use they are not included into
the upstream Linux PAM sources.

%description -n %{make_pam_name console}
The pam_console module exists to change file permissions when users
log on at the console, and to change them back when they log out of
the console.

See pam_console(8) for details.

%description -n %{make_pam_name chroot}
When the calling application attempts to open a session, pam_chroot
opens /etc/security/chroot.conf and attempt to chroot() to appropriate
directory.

%prep
%setup -n %name-%version-%release

%build
%autoreconf
%configure
make

%install
%makeinstall_std
rm -f %buildroot%_pam_modules_dir/*.la
mkdir -p %buildroot%_secdir/console.apps

# Documentation
for f in pam_*/README; do
	d="${f%%/*}"
	[ -s "$d/Makefile" ] || continue
	install -pDm644 "$f" "%buildroot%_docdir/${d##*/}/README"
done

# ALT#25584
mkdir -p %buildroot%_tmpfilesdir
echo 'd /run/console 0711 root root -' > %buildroot%_tmpfilesdir/pamconsole.conf

# Make sure that all modules are built.
>check.log
for d in pam_*; do
	[ -d "$d" -a -s "$d/Makefile" ] || continue
	m="${d##*/}"
	! ls -1 "%buildroot%_pam_modules_dir/$m"*.so 2>/dev/null || continue
	echo "ERROR: $m module did not build." >&2
	echo "$m" >>check.log
done
! [ -s check.log ] || exit 1

# Make sure that no module exports symbols beyond standard set.
>check.log
for f in %buildroot%_pam_modules_dir/pam*.so; do
	readelf -Ws "$f" |
		grep -w GLOBAL |
		grep -Ewv 'UND|pam_sm_(acct_mgmt|authenticate|chauthtok|close_session|open_session|setcred)'  ||
			continue
	echo "ERROR: ${f##*/} exports symbol(s) beyond standard set." >&2
	echo "${f##*/}" >>check.log
done
! [ -s check.log ] || exit 1

# Make sure that no shared object has undefined symbols.
>check.log
for f in %buildroot%_pam_modules_dir/pam*.so; do
	LD_LIBRARY_PATH="%buildroot/%_lib" ldd -r "$f" 2>&1 >/dev/null |
		tee -a check.log
done
! [ -s check.log ] || exit 1

# Make sure that none of the modules pull in threading libraries.
>check.log
for f in %buildroot%_pam_modules_dir/pam*.so; do
	LD_LIBRARY_PATH="%buildroot/%_lib" ldd -r "$f" 2>&1 |
		grep -F -q libpthread ||
			continue
	echo "ERROR: ${f##*/} pulls in libpthread." >&2
	echo "${f##*/}" >>check.log
done
! [ -s check.log ] || exit 1

%post -n %{make_pam_name console}
groupadd -r -f scanner
groupadd -r -f xgrp
pam_console_apply

%triggerpostun -n %{make_pam_name console} -- pam, pam_console
f=%_secdir/console.perms
if [ ! -f "$f" ]; then
	if [ -f "$f.rpmsave" ]; then
		cp -pf "$f.rpmsave" "$f"
	elif [ -f "$f.rpmnew" ]; then
		cp -pf "$f.rpmnew" "$f"
	fi
fi
pam_console_apply

%triggerpostun -n %{make_pam_name console} -- %{make_pam_name console} < 0:0.79
if [ -f /run/console.lock -a ! -f /run/console/console.lock ]; then
	mv /run/console.lock /run/console/ &&
		pam_console_apply ||:
fi

%triggerpostun -n %{make_pam_name chroot} -- pam < 0:1.1.0-alt4
f=%_secdir/chroot.conf
if [ ! -f "$f" ]; then
	if [ -f "$f.rpmsave" ]; then
		cp -pf "$f.rpmsave" "$f"
	elif [ -f "$f.rpmnew" ]; then
		cp -pf "$f.rpmnew" "$f"
	fi
fi

%files -n %{make_pam_name console}
%attr(600,root,root) %config(noreplace) %_secdir/console.perms
%attr(700,root,root) %dir %_secdir/console.perms.d
%attr(600,root,root) %config(noreplace) %_secdir/console.perms.d/*
%attr(600,root,root) %config(noreplace) %_secdir/console.handlers
%attr(711,root,root) %dir %_secdir/console.apps
%attr(700,root,root) %_sbindir/pam_console_apply
%_pam_modules_dir/pam_console.so
%_mandir/man[58]/*console*
%_tmpfilesdir/pamconsole.conf
%_docdir/pam_console

%files -n %{make_pam_name chroot}
%config(noreplace) %attr(640,root,wheel) %_secdir/chroot.conf
%_pam_modules_dir/pam_chroot.so
%_docdir/pam_chroot

%changelog
