%def_enable printing
%def_enable backup
%define ver_micro %nil

Name: osmo
Version: 0.4.4
Release: alt1

Summary: Personal organizer
License: GPLv2+
Group: Office
Url: http://clayo.org/osmo/

Source: http://downloads.sourceforge.net/%name-pim/%name-%version%ver_micro.tar.gz

%define gtk_ver 3.10

BuildRequires: libgtk+3-devel >= %gtk_ver libgspell-devel libxml2-devel
BuildRequires: libnotify-devel libical-devel libicu-devel libwebkit2gtk-devel
%{?_enable_backup:BuildRequires: libgringotts-devel libarchive-devel}

%description
Osmo is a handy personal organizer which includes calendar, tasks manager and
address book modules. It was designed to be a small, easy to use and good
looking PIM tool to help to manage personal information. In current state the
organizer is quite convenient in use - for example, user can perform nearly
all operations using keyboard. Also, a lot of parameters are configurable to
meet user preferences.

%prep
%setup -n %name-%version%ver_micro

%build
%autoreconf
%configure \
	%{?_enable_backup:--enable-backup=yes} \
	%{?_enable_printing:--enable-printing}
%make_build

%install
%makeinstall_std
%find_lang %name

%files -f %name.lang
%_bindir/*
%_datadir/applications/*.desktop
%_iconsdir/hicolor/*/*/*.png
%_iconsdir/hicolor/*/*/*.svg
%_man1dir/*
%dir %_datadir/sounds/%name
%_datadir/sounds/%name/alarm.wav
%_pixmapsdir/*.png
%doc AUTHORS ChangeLog README TRANSLATORS

%changelog
