%define _unpackaged_files_terminate_build 1
%define _tty_number 11

# Use shellcheck only on these architectures
%ifarch x86_64 aarch64
%def_enable check
%else
%def_disable check
%endif

# Define the target branch
%ifdef _priority_distbranch
%define altbranch %_priority_distbranch
%else
%define altbranch %(rpm --eval %%_priority_distbranch)
%endif
%if "%altbranch" == "%nil"
%define altbranch sisyphus
%endif

Name: os-upgrade
Version: 1.2
Release: alt1

Summary: The Operation System Upgrade Tool
Group: System/Configuration/Other
License: GPLv3+

BuildArch: noarch

Url: https://github.com/klark973/os-upgrade
Source: %name-%version.tar
AutoReq: noshell, noshebang

%{!?_disable_check:BuildRequires: bash shellcheck}

%ifnarch %e2k
Requires: grub-common
%endif

Requires: apt
Requires: apt-repo
Requires: bash
Requires: filesystem
Requires: grep
Requires: make-initrd
Requires: rpm
Requires: sed
Requires: systemd
Requires: update-kernel

# Soft dependencies, this can only be checked at runtime:
# Requires: /etc/os-release (altlinux-release-sisyphus or altlinux-release)
# Requires: /etc/apt/sources.list.d (apt-conf-sisyphus, apt-conf-branch
#                                    or apt-conf-branch-gostcrypto)

# Optional dependencies for ALT SP, also checked at runtime:
# Requires: ima-evm-integrity-check
# Requires: integ (c10f1 only)

Packager: Leonid Krivoshein <klark@altlinux.org>

%description
A command line tool and service for checking for updates to
the ALT Operating System and a complete distribution upgrade
in the background or in the separate (isolated) systemd target.

%prep
%setup -q
%autopatch -p1

%build
cat >"./usr/libexec/%name/version.sh" <<-EOF
# Auto-generated by the build system, do not edit directly!
#
SU_VERSION="%version"
SU_BUILD_DATE="$(date -u +'%%Y-%%m-%%d')"

EOF
sed -i -e "s/@TTY_NUMBER@/%_tty_number/g" \
	  "./usr/libexec/%name/defaults.sh" \
	  "./usr/libexec/%name/units/%name.service"
chmod 0755 ".%_bindir/%name"
chmod 0755 check-scripts.sh

%install
mkdir -p -m 0755 -- "%buildroot"
cp -aRf usr "%buildroot"/

%check
./check-scripts.sh

# This is protection against build in an unsupported branch
%if "%altbranch" != "sisyphus" && "%altbranch" != "c10f1"
%pre
# Don't install the package on unsupported solutions
echo "There is no supported distribution for updating!" >&2
exit 1
%endif

%files
%_bindir/%name
/usr/libexec/%name
%doc CHANGELOG.md LICENSE doc/*.md doc/*.png

%changelog
