%define _unpackaged_files_terminate_build 1
%filter_from_requires s,python-module-zope\.app\.appsetup,,

Name: os-prober
Version: 1.83
Release: alt2

Summary: Operating systems detector
License: GPLv2+
Group: System/Configuration/Boot and Init
Url: https://salsa.debian.org/installer-team/os-prober
VCS: https://salsa.debian.org/installer-team/os-prober.git

Source0: %name-%version.tar

Patch: %name-1.42-UUID-rootdev-alt.patch
Patch1: %name-1.77-alt-grub2-detect-auto-reference.patch
Patch2: %name-1.77-alt-grub2-skip-30_os-prober-parsing.patch
Patch3: %name-1.77-alt-check-identical-uuid-of-root.patch
Patch4: %name-1.77-alt-dmdevfs-use-for-raid.patch
Patch5: os-prober-1.83-fedora-grub-mount-workaround.patch

%description
This is a small package that may be depended on by any bootloader
installer package to detect other filesystems with operating systems on
them, and work out how to boot other linux installs.

%prep
%setup
%patch -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1

%build
%make_build

%install
install -Dm755 os-prober -t %buildroot/%_bindir
install -Dm755 linux-boot-prober -t %buildroot/%_bindir
install -Dm755 newns -t %buildroot%_libexecdir/os-prober
install -Dm644 common.sh -t %buildroot%_datadir/os-prober

mkdir -p %buildroot%_libexecdir/os-probes/init
cp -a os-probes/init/common/* %buildroot%_libexecdir/os-probes/init/

mkdir -p %buildroot%_libexecdir/os-probes/mounted
cp -a os-probes/mounted/x86/* %buildroot%_libexecdir/os-probes/mounted/
cp -a os-probes/mounted/common/* %buildroot%_libexecdir/os-probes/mounted/
cp -a os-probes/common/* %buildroot%_libexecdir/os-probes/

mkdir -p %buildroot%_libexecdir/linux-boot-probes/mounted
cp -a linux-boot-probes/common/* %buildroot%_libexecdir/linux-boot-probes
cp -a linux-boot-probes/mounted/x86/* \
   %buildroot%_libexecdir/linux-boot-probes/mounted/
cp -a linux-boot-probes/mounted/common/* \
   %buildroot%_libexecdir/linux-boot-probes/mounted/

mkdir -p %buildroot%_localstatedir/os-prober

%files
%doc README
%_bindir/os-prober
%_bindir/linux-boot-prober
%_libexecdir/linux-boot-probes
%_libexecdir/os-probes
%_libexecdir/os-prober
%_datadir/os-prober
%_localstatedir/os-prober

%changelog
