%define _unpackaged_files_terminate_build 1

Name: os-autoinst
Version: 4.6
Release: alt23.git2b88807a

Summary: OS-level test automation
License: GPLv2+
Group: Development/Tools
Url: https://github.com/os-autoinst/os-autoinst/
Source: %name-%version.tar
# revert commits form https://github.com/os-autoinst/os-autoinst/pull/2359
# Disable ssh read error messages
# which are not processed yet and just clogging up the logs
Patch0: os-autoinst-4.6-alt-disable-ssh-err-msg.patch
#Support for Russian characters
Patch1: addrulang.patch

BuildRequires: perlcritic
BuildRequires: autoconf
BuildRequires: automake
BuildRequires: gcc-c++
BuildRequires: libtool
BuildRequires: libopencv-devel
BuildRequires: perl-devel
BuildRequires: perl-Test-Warnings
BuildRequires: perl-Package-Generator
BuildRequires: perl(Test/Most.pm)
BuildRequires: perl(Test/Mock/Time.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(ExtUtils/Embed.pm)
BuildRequires: perl(Module/CPANfile.pm)
BuildRequires: perl(Perl/Critic.pm)
BuildRequires: perl(Perl/Tidy.pm)
BuildRequires: perl(Pod/Html.pm)
BuildRequires: perl(Term/ReadLine.pm)
BuildRequires: perl(Test/MockObject.pm)
BuildRequires: pkgconfig
BuildRequires: pkgconfig(libpng)
BuildRequires: pkgconfig(fftw3)
BuildRequires: pkgconfig(sndfile)
BuildRequires: pkgconfig(theoraenc)
BuildRequires: systemd
BuildRequires: perl(Devel/Cover.pm)
BuildRequires: perl(Test/Strict.pm)
BuildRequires: perl(Pod/Coverage.pm)
BuildRequires: perl(Test/Compile.pm)
BuildRequires: perl(Socket/MsgHdr.pm)
BuildRequires: perl(Test/Fatal.pm)
BuildRequires: perl(Test/MockModule.pm)
BuildRequires: perl(Test/MockTime.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Test/Output.pm)
BuildRequires: perl(Test/Pod.pm)
BuildRequires: perl(Test/Warnings.pm)
BuildRequires: perl(Try/Tiny.pm)
BuildRequires: perl(Mojo/IOLoop/ReadWriteProcess.pm)
BuildRequires: perl(Test/Exception.pm)
BuildRequires: perl-IO-stringy
BuildRequires: perl(File/Touch.pm)
BuildRequires: perl(XML/SemanticDiff.pm)
BuildRequires: perl-Pod-Spell
BuildRequires: ispell ispell-en
#BuildConflicts: pve-qemu-aux pve-qemu-img
BuildRequires: /usr/bin/qemu-system-i386
#BuildRequires: /usr/bin/qemu-img
BuildRequires: qemu-img qemu-aux git-core xterm xterm-console tigervnc-server icewm menu jq iproute2
BuildRequires: perl(Mojo/File.pm)
BuildRequires: perl(Carp/Always.pm) perl(Data/Dump.pm) perl(Crypt/DES.pm) perl(JSON.pm) perl(JSON/XS.pm) perl(autodie.pm) perl(Class/Accessor/Fast.pm) perl(Exception/Class.pm) perl(File/Which.pm) perl(IPC/Run/Debug.pm) perl(Net/DBus.pm) perl(Net/SNMP.pm) perl(Net/IP.pm) perl(IPC/System/Simple.pm) perl(Net/SSH2.pm) perl(XML/LibXML.pm) perl(YAML/PP.pm) yamllint perl(File/chdir.pm) perl(Test/MockRandom.pm) perl(Test/Code/TidyAll.pm) perl(JSON/Validator.pm) perl(Net/Domain.pm) perl(File/Map.pm) perl(Feature/Compat/Try.pm)
BuildRequires: perl(Mojolicious.pm) python3-module-setuptools perl(Time/Moment.pm)
BuildPreReq: cmake rpm-macros-cmake ninja-build rpm-macros-ninja-build ctest
Requires: qemu-kvm
Requires: tesseract expect
Requires: withlock
Requires: perl(Carp/Always.pm) perl(Data/Dump.pm) perl(Net/SNMP.pm) perl(Net/IP.pm)
Requires: /usr/bin/qemu-img
Requires: optipng
Requires: qemu >= 2.0.0

ExclusiveArch: i586 x86_64 ppc64le aarch64 loongarch64

%add_perl_lib_path %buildroot%_libexecdir/os-autoinst
%add_python3_lib_path %_libexecdir/os-autoinst
%add_python3_req_skip perl

%description
The OS-autoinst project aims at providing a means to run fully
automated tests. Especially to run tests of basic and low-level
operating system components such as bootloader, kernel, installer and
upgrade, which can not easily and safely be tested with other
automated testing frameworks. However, it can just as well be used to
test applications on top of a newly installed OS.

%package openvswitch
Summary: Open vSwitch support for os-autoinst
Group: System/Servers
BuildArch: noarch

Requires: %name = %EVR
Requires: openvswitch

%description openvswitch
This package contains Open vSwitch support for os-autoinst.

%prep
%setup
%patch0 -p1
%patch1 -p1
sed  -i 's/ my $thisversion = qx{git -C $dirname rev-parse HEAD};/ my $thisversion = "%version";/' isotovideo
sed  -i 's/ chomp(my $git_hash = qx{git rev-parse HEAD});/ chomp(my $git_hash = "%version");/' OpenQA/Isotovideo/Utils.pm
# don't require qemu within OBS
# and exclude known flaky tests in OBS check
# https://progress.opensuse.org/issues/52652
# 07-commands: https://progress.opensuse.org/issues/60755
for i in 10-terminal 10-virtio_terminal 14-isotovideo 18-qemu 18-qemu-options 18-backend-qemu 26-video_stream 27-consoles-vmware 29-backend-generalhw 28-signalblocker 33-vagrant 34-git 99-full-stack ; do
    rm -f t/$i.t
done
%ifarch aarch64 ppc64le
rm -f t/13-osutils.t
%endif

# exclude unnecessary author tests
rm -f xt/00-tidy.t
# Remove test relying on a git working copy
rm -f xt/30-make.t

%build
#mkdir -p m4
%cmake -DSYSTEMD_SERVICE_DIR:STRING="%_unitdir" -GNinja
%ninja_build -C "%_cmake__builddir"

%install
%ninja_install -C "%_cmake__builddir" install-openvswitch

%check
export CI=1
export OPENQA_TEST_TIMEOUT_SCALE_CI=10
export PERL_TEST_WARNINGS_ONLY_REPORT_WARNINGS=1
export PROVE_ARGS="--timer -v --nocolor"
export TESSDATA_PREFIX="%_datadir/tessdata/"
%ninja_build -C "%_cmake__builddir" check-pkg-build

%files
%_docdir/*
%perl_vendorarch/tinycv.pm
%perl_vendorarch/auto/tinycv
%_libexecdir/os-autoinst
%exclude %_libexecdir/os-autoinst/script/os-autoinst-openvswitch
%_bindir/*

%files openvswitch
%_libexecdir/os-autoinst/script/os-autoinst-openvswitch
%_unitdir/os-autoinst-openvswitch.service
%config(noreplace) %_sysconfdir/dbus-1/system.d/org.opensuse.os_autoinst.switch.conf

%changelog
