Name: optix
Version: 9.0.0
Release: alt1
License: BSD-3-Clause AND NVIDIA-390
Summary: NVIDIA OptiX 9.0 Programming API headers
Group: Development/Other
Url: https://developer.nvidia.com/designworks/optix/download

Source: NVIDIA-OptiX-SDK-9.0.0-linux64-x86_64.tar

# not really needed but nice to have
BuildRequires: nvidia-cuda-devel

# as we don't have cuda-toolkit on other arches
ExclusiveArch: x86_64

%description
DirectX Raytracing (DXR),1 Vulkan 2 (through the VK_NV_ray_tracing extension) and the
NVIDIA OptiX(TM) API 3 employ a similar programming model to support ray tracing
capabilities. DXR and Vulkan enable ray tracing effects in raster-based gaming and
visualization applications. NVIDIA OptiX is intended for ray tracing applications that use
NVIDIA(R) CUDA(R) technology, such as:
 - Film and television visual effects
 - Computer-aided design for engineering and manufacturing
 - Light maps generated by path tracing
 - High-performance computing
 - LIDAR simulation
 NVIDIA OptiX also includes support for motion blur and multi-level transforms, features
 required by ray-tracing applications designed for production-quality rendering.

%package devel
Summary: NVIDIA OptiX 9.0 Programming API headers
Group: Development/Other
Requires: libnvoptix >= 570.0.0, nvidia-cuda-devel >= 12.0.0

%description devel
NVDIA OptiX 9.0 Programming API headers

%prep
%setup

%install
# we need a bare minimum
mkdir -p %buildroot%_includedir/{optix,optix/internal}
rm -rf include/GLFW
install -pm644 -v -D include/*.h %buildroot%_includedir/optix
install -pm644 -v -D include/internal/*.h %buildroot%_includedir/optix/internal

%files devel
%doc OptiX_EndUserLicense.pdf OptiX_ThirdParty_Licenses.txt license_info.txt
%_includedir/*

%changelog
