%define _unpackaged_files_terminate_build 1

Name: opentest4j
Version: 1.3.0
Release: alt1

Summary: Open Test Alliance for the JVM
License: Apache-2.0
Group: Development/Java
Url: https://github.com/ota4j-team/opentest4j
Vcs: https://github.com/ota4j-team/opentest4j.git
BuildArch: noarch

Source0: %name-%version.tar
Source1: %name-tags.tar
Source2: commit.sh
Patch0: 0001-Remove-unnecessary-gradle-plugins.patch

BuildRequires(pre): rpm-macros-gradle
BuildRequires: xgradle
BuildRequires: junit
BuildRequires: /proc
BuildRequires: rpm-build-java
BuildRequires: java-11-openjdk-devel
BuildRequires: java-17-openjdk-devel
BuildRequires: biz-aQute-bnd-gradle-plugins

%description
Open Test Alliance for the JVM is a minimal common foundation for
testing libraries on the JVM.  The primary goal of the project is to
enable testing frameworks like JUnit, TestNG, Spock, etc. and
third-party assertion libraries like Hamcrest, AssertJ, etc. to use a
common set of exceptions that IDEs and build tools can support in a
consistent manner across all testing scenarios -- for example, for
consistent handling of failed assertions and failed assumptions as
well as visualization of test execution in IDEs and reports.

%package javadoc
Group: Development/Java
Summary: Javadoc for %name
BuildArch: noarch

%description javadoc
API documentation for %name.

%prep
%setup -a1
%autopatch -p1

# Set commitHash for OSGI bundles.
sed -i "s/versioning.info.commit/\"$(./commit.sh)\"/g" build.gradle

%build
%gradle_publish

%install
%gradle_register
%gradle_register_javadoc

%gradle_install

%check
%gradle_check

%files -f .mfiles
%doc --no-dereference LICENSE
%doc README.md

%files javadoc -f .mfiles-javadoc
%doc --no-dereference LICENSE

%changelog
