%def_enable tsget
%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}

Name: openssl3
Version: 3.5.4
Release: alt1

Summary: OpenSSL - Secure Sockets Layer and cryptography shared libraries and tools
License: Apache-2.0
Group: System/Base
Url: http://www.openssl.org

# http://git.altlinux.org/gears/o/openssl3.git
Source: openssl-%version-%release.tar

%define shlib_soversion 3
%define openssldir /var/lib/ssl
%define old_openssldir %_libdir/ssl

BuildRequires: /usr/bin/pod2man bc zlib-devel perl-PathTools perl-IPC-Cmd
%if_enabled tsget
BuildRequires: perl-WWW-Curl
%endif

%{?!_without_check:%{?!_disable_check:BuildRequires: perl-devel perl-Math-BigInt perl-Time-Piece perl-IO-Socket-IP}}

%package -n libcrypto%shlib_soversion
Summary: OpenSSL libcrypto shared library
Group: System/Libraries
Provides: libcrypto = %version-%release
Provides: openssl-providers = %EVR
Obsoletes: openssl-providers < %EVR
Requires: openssl-config >= 3.2.0-alt1
# due to openssldir migration
Conflicts: openssl < 0:0.9.8d-alt1
# due to runtime openssl version check
Conflicts: openssh-common < 5.9p1-alt5
Requires: ca-certificates

%package -n libssl%shlib_soversion
Summary: OpenSSL libssl shared library
Group: System/Libraries
Provides: libssl = %version
Requires: libcrypto%shlib_soversion = %version-%release

%package -n libssl-devel
Summary: OpenSSL include files and development libraries
Group: Development/C
Provides: openssl-devel = %version
Obsoletes: openssl-devel < %version
Requires: libssl%shlib_soversion = %version-%release
# due to /usr/bin/openssl-config
Conflicts: openssl < %version-%release, openssl > %version-%release

%package -n libssl-devel-static
Summary: OpenSSL static libraries
Group: Development/C
Provides: openssl-devel-static = %version
Obsoletes: openssl-devel-static < %version
Requires: libssl-devel = %version-%release

%package -n openssl
Summary: OpenSSL tools
Group: System/Base
Provides: %openssldir
# due to /usr/bin/openssl-config
Conflicts: libssl-devel < %version-%release, libssl-devel > %version-%release
Requires: libssl%shlib_soversion = %version-%release

%package -n openssl-doc
Summary: OpenSSL documentation and demos
Group: Development/C
Requires: openssl = %version-%release
BuildArch: noarch

%package -n openssl-engines
Summary: OpenSSL ENGINE interface modules
Group: System/Libraries
Requires: libssl%shlib_soversion = %version-%release

%package -n tsget
Summary: Time Stamping HTTP/HTTPS client
Group: Security/Networking
BuildArch: noarch
Requires: libssl%shlib_soversion = %version-%release

%description
The OpenSSL toolkit provides support for secure communications between
machines. OpenSSL includes a certificate management tool and shared
libraries which provide various cryptographic algorithms and
protocols.

%description -n libcrypto%shlib_soversion
The OpenSSL toolkit provides support for secure communications between
machines. OpenSSL includes a certificate management tool and shared
libraries which provide various cryptographic algorithms and
protocols.

This package contains the OpenSSL libcrypto shared library.

%description -n libssl%shlib_soversion
The OpenSSL toolkit provides support for secure communications between
machines. OpenSSL includes a certificate management tool and shared
libraries which provide various cryptographic algorithms and
protocols.

This package contains the OpenSSL libssl shared library.

%description -n libssl-devel
The OpenSSL toolkit provides support for secure communications between
machines. OpenSSL includes a certificate management tool and shared
libraries which provide various cryptographic algorithms and
protocols.

This package contains the OpenSSL include files and development libraries
required when building OpenSSL-based applications.

%description -n libssl-devel-static
The OpenSSL toolkit provides support for secure communications between
machines. OpenSSL includes a certificate management tool and shared
libraries which provide various cryptographic algorithms and
protocols.

This package contains static libraries required when developing
OpenSSL-based statically linked applications.

%description -n openssl
The OpenSSL toolkit provides support for secure communications between
machines. OpenSSL includes a certificate management tool and shared
libraries which provide various cryptographic algorithms and
protocols.

This package contains the base OpenSSL cryptography and SSL/TLS tools.

%description -n openssl-doc
The OpenSSL toolkit provides support for secure communications between
machines. OpenSSL includes a certificate management tool and shared
libraries which provide various cryptographic algorithms and
protocols.

This package contains the OpenSSL cryptography and SSL/TLS extra
documentation and demos required when developing applications.

%description -n openssl-engines
The OpenSSL toolkit provides support for secure communications between
machines. OpenSSL includes a certificate management tool and shared
libraries which provide various cryptographic algorithms and
protocols.

With OpenSSL 0.9.6, a new component was added to support alternative
cryptography implementations, most commonly for interfacing with external
crypto devices (eg. accelerator cards).  This component is called ENGINE,
and its presence in OpenSSL 0.9.6 (and subsequent bug-fix releases) caused
a little confusion as 0.9.6** releases were rolled in two versions,
a "standard" and an "engine" version.  In development for 0.9.7, the
ENGINE code has been merged into the main branch and is present in
the standard releases from 0.9.7 forwards.

In addition, dynamic binding to external ENGINE implementations is
provided by a special ENGINE called "dynamic".

%description -n tsget
The tsget command can be used for sending a time stamp request, as
specified in RFC 3161, to a time stamp server over HTTP or HTTPS and
storing the time stamp response in a file.  This tool cannot be used for
creating the requests and verifying responses, you can use the OpenSSL
ts(1) command to do that.  tsget can send several requests to the server
without closing the TCP connection if more than one requests are specified
on the command line.

%prep
%setup -n openssl-%version-%release
# Skip afalg test.
# This test fails when af_alg moudle is loaded, but with no aes_cbc support.
rm test/recipes/30-test_afalg.t

# Correct shared library name.
sed -i 's/\\\$(SHLIB_MAJOR)\.\\\$(SHLIB_MINOR)/\\$(VERSION)/g' Configure

%build
ADD_ARGS=%_os-%_arch
%ifarch %ix86
	ADD_ARGS=linux-elf
%ifarch i386
	ADD_ARGS="$ADD_ARGS 386"
%endif
%endif
%ifarch %arm
ADD_ARGS=linux-generic32
%endif
%ifarch x32
ADD_ARGS=linux-x32
%endif
%ifarch s390x
ADD_ARGS=linux64-s390x
%endif
%ifarch mips mipsel
ADD_ARGS=linux-mips32
%endif
%ifarch mips64 mips64el
ADD_ARGS=linux64-mips64
%endif
%ifarch riscv64
ADD_ARGS=linux64-riscv64
%endif
%ifarch %e2k
ADD_ARGS=linux-generic64
%endif
%ifarch loongarch64
ADD_ARGS=linux64-loongarch64
%endif

if echo 'extern __uint128_t i;' |
   gcc %optflags -Werror -c -o/dev/null -xc -; then
	ADD_ARGS="enable-ec_nistp_64_gcc_128 $ADD_ARGS"
fi

# Correct compilation options.
%add_optflags -fno-strict-aliasing -Wa,--noexecstack

./Configure shared \
	--prefix=%prefix \
	--libdir=%_lib \
	--openssldir=%openssldir \
	--system-ciphers-file=%_sysconfdir/openssl/cipher-list.conf \
	enable-egd \
	enable-md2 \
	enable-rfc3779 \
	enable-ssl3 \
	zlib \
	$ADD_ARGS \
	%optflags \
#

make generate_crypto_objects
%make_build

# Make soname symlinks.
/sbin/ldconfig -nv .

# Save library timestamps for later check.
touch -r libcrypto.so.%shlib_soversion libcrypto-stamp
touch -r libssl.so.%shlib_soversion libssl-stamp

#LD_LIBRARY_PATH=`pwd` make rehash

%install
# The make_install macro doesn't work here.
make install \
	CC="$PWD"/alt/cc.sh \
	DESTDIR=%buildroot \
	MANDIR=%_mandir

# Fail if one of shared libraries was rebuit.
if [ libcrypto.so.%shlib_soversion -nt libcrypto-stamp -o \
     libssl.so.%shlib_soversion -nt libssl-stamp ]; then
	echo 'Shared library was rebuilt by "make install".'
	exit 1
fi

# Fail if the openssl binary is statically linked against OpenSSL at this
# stage (which could happen if "make install" caused anything to rebuild).
LD_LIBRARY_PATH=`pwd` ldd %buildroot%_bindir/openssl |tee openssl.libs
grep -qw libssl openssl.libs
grep -qw libcrypto openssl.libs

# Install openssl-config script.
install -pDm755 alt/openssl-config %buildroot%_bindir/openssl-config
subst -p 's,%%version,%version,g;s,%%openssldir,%openssldir,g' \
	%buildroot%_bindir/openssl-config

# Relocate shared libraries from %_libdir/ to /lib/.
mkdir -p %buildroot{/%_lib,%_libdir/openssl,%_sbindir}
for f in %buildroot%_libdir/*.so; do
	t=$(readlink "$f") || continue
	ln -snf ../../%_lib/"$t" "$f"
done
mv %buildroot%_libdir/*.so.* %buildroot/%_lib/

# Add a symlink to /etc/openssl/openssl.cnf (packaged separately as openssl-config).
rm -f %buildroot%openssldir/openssl.cnf
ln -s -r %buildroot%_sysconfdir/openssl/openssl.cnf %buildroot%openssldir/

# Make backwards-compatibility symlink to ssleay.
ln -snf openssl %buildroot%_bindir/ssleay

# Install a makefile for generating keys and self-signed certs,
# and a script for generating them on the fly.
install -pDm644 alt/Makefile.certificate \
	%buildroot%openssldir/certs/Makefile
install -pDm644 alt/make-dummy-cert \
	%buildroot%openssldir/certs/make-dummy-cert

ln -s -r %buildroot%_datadir/ca-certificates/ca-bundle.crt \
	%buildroot%openssldir/cert.pem

%if_enabled tsget
mv %buildroot%openssldir/misc/tsget.pl %buildroot%_sbindir/
rm %buildroot%openssldir/misc/tsget
ln -s tsget.pl %buildroot%_sbindir/tsget
%else
rm %buildroot%openssldir/misc/tsget.pl
rm %buildroot%openssldir/misc/tsget
%endif

rm %buildroot%openssldir/openssl.cnf.dist
rm %buildroot%openssldir/ct_log_list.cnf.dist

%define docdir %_docdir/openssl-%version
mkdir -p %buildroot%docdir
install -pm644 CHANGES* LICENSE.txt NEWS.md README* \
	%buildroot%docdir/
bzip2 -9 %buildroot%docdir/CHANGES*
cp -a demos doc %buildroot%docdir/
rm -rf %buildroot%docdir/doc/{apps,crypto,ssl}

# Create default cipher-list.conf from SSL_DEFAULT_CIPHER_LIST
mkdir -p %buildroot%_sysconfdir/openssl
sed -n -r 's,^#.*SSL_DEFAULT_CIPHER_LIST[[:space:]]+"([^"]+)",\1,p' \
	include/openssl/ssl.h > %buildroot%_sysconfdir/openssl/cipher-list.conf

%check
LD_LIBRARY_PATH=%buildroot/%_lib \
	OPENSSL_ENABLE_MD5_VERIFY= \
	OPENSSL_SYSTEM_CIPHERS_OVERRIDE=%buildroot%_sysconfdir/openssl/cipher-list.conf \
	make test V=1

%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1

%files -n libcrypto%shlib_soversion
/%_lib/libcrypto*
%_libdir/ossl-modules
%dir %_sysconfdir/openssl/
%dir %openssldir
%dir %openssldir/certs
%dir %attr(700,root,root) %openssldir/private
%openssldir/*.cnf
%openssldir/*.pem
%dir %_libdir/openssl
%dir %docdir
%docdir/[A-Z]*

%files -n libssl%shlib_soversion
%config(noreplace) %_sysconfdir/openssl/cipher-list.conf
%dir %_sysconfdir/openssl/
/%_lib/libssl*

%files -n libssl-devel
%_bindir/openssl-config
%_libdir/*.so
%_libdir/pkgconfig/*
%_libdir/cmake/OpenSSL
%_includedir/*

%files -n libssl-devel-static
%_libdir/*.a

%files -n openssl
%_bindir/*
%openssldir/misc
%openssldir/certs/*
%_mandir/man[157]/*
%if_enabled tsget
%exclude %_man1dir/tsget.*
%endif

%files -n openssl-doc
%dir %docdir
%docdir/[a-z]*
%_man3dir/*

%files -n openssl-engines
%_libdir/openssl/engines-%shlib_soversion

%if_enabled tsget
%files -n tsget
%_sbindir/tsget
%_sbindir/tsget.pl
%_man1dir/tsget.*
%endif

%changelog
