%define oname openssh
Name: openssh-gostcrypto
Version: 9.6p1
Release: alt6.gost

Summary: OpenSSH free Secure Shell (SSH) implementation
License: SSH-OpenSSH and ALT-Public-Domain and BSD-3-Clause and Beerware
Group: Networking/Remote access
Url: http://www.openssh.com/portable.html
# git://git.altlinux.org/gears/o/openssh.git
Source: %name-%version-%release.tar

%define confdir %_sysconfdir/%oname
%define _chrootdir /var/empty
%define docdir %_docdir/%name-%version
%def_with pam_userpass
%def_with libedit
%def_with libaudit
%def_with kerberos5
%def_with selinux
%def_with openssl
%def_with security_key_builtin
%def_with zlib
%def_with ssl_engine

%{expand: %%global _libexecdir %_libexecdir/openssh}
%define _pamdir /etc/pam.d

Conflicts: openssh
Requires: %oname-clients-gostcrypto = %EVR
Requires: %oname-server-gostcrypto = %EVR

# Automatically added by buildreq on Wed Apr 04 2007
BuildRequires: libssl-devel pam_userpass-devel
%{?_with_zlib:BuildRequires: zlib-devel}
%{?_with_libedit:BuildRequires: libedit-devel}
%{?_with_libaudit:BuildRequires: libaudit-devel}
%{?_with_kerberos5:BuildRequires: libkrb5-devel}
%{?_with_selinux:BuildRequires: libselinux-devel}
%{?_with_security_key_builtin:BuildRequires: libfido2-devel}

%package -n %oname-common-gostcrypto
Summary: OpenSSH common files
Group: Networking/Remote access
Provides: openssh-common = %EVR
Conflicts: openssh-common
Conflicts: %name < %EVR

%package -n %oname-clients-gostcrypto
Summary: OpenSSH Secure Shell protocol clients
Group: Networking/Remote access
Provides: openssh-clients = %EVR
Conflicts: openssh-clients
Requires: %oname-common-gostcrypto = %EVR
Requires: openssl-gost-engine >= 3.0.2-alt4

%package -n %oname-keysign-gostcrypto
Summary: OpenSSH helper program for hostbased authentication
Group: Networking/Remote access
Provides: openssh-keysign = %EVR
Conflicts: openssh-keysign
Requires: %oname-clients-gostcrypto = %EVR

%package -n %oname-server-gostcrypto
Summary: OpenSSH Secure Shell protocol daemon
Group: System/Servers
Provides: openssh-server = %EVR
Conflicts: openssh-server
Requires(pre,post): %oname-server-control-gostcrypto = %EVR
Requires: %_chrootdir, syslogd-daemon
Requires: openssl-gost-engine >= 1.1.0.3.0.255.ge3af41d-alt1
# Because of /etc/syslog.d/ feature.
Conflicts: syslogd < 1.4.1-alt11

%package -n %oname-server-control-gostcrypto
Summary: Control rules for the OpenSSH server configuration
License: GPLv2+
Group: System/Servers
Provides: openssh-server-control = %EVR
Conflicts: openssh-server-control
Requires: %oname-common-gostcrypto = %EVR

%package -n %oname-askpass-common-gostcrypto
Summary: OpenSSH common passphrase dialog infrastructure
Group: Networking/Remote access
Provides: openssh-askpass-common = %EVR
Conflicts: openssh-askpass-common
Requires: %oname-common-gostcrypto = %EVR
Provides: %_libexecdir

%description
Ssh (Secure Shell) a program for logging into a remote machine and for
executing commands in a remote machine.  It is intended to replace
rlogin and rsh, and provide secure encrypted communications between
two untrusted hosts over an insecure network.  X11 connections and
arbitrary TCP/IP ports can also be forwarded over the secure channel.

OpenSSH is OpenBSD's rework of the last free version of SSH, bringing it
up to date in terms of security and features, as well as removing all
patented algorithms to seperate libraries (OpenSSL).

%description -n %oname-common-gostcrypto
Ssh (Secure Shell) a program for logging into a remote machine and for
executing commands in a remote machine.  It is intended to replace
rlogin and rsh, and provide secure encrypted communications between
two untrusted hosts over an insecure network.  X11 connections and
arbitrary TCP/IP ports can also be forwarded over the secure channel.

OpenSSH is OpenBSD's rework of the last free version of SSH, bringing it
up to date in terms of security and features, as well as removing all
patented algorithms to seperate libraries (OpenSSL).

This package includes common files necessary for both the OpenSSH
client and server.

%description -n %oname-clients-gostcrypto
Ssh (Secure Shell) a program for logging into a remote machine and for
executing commands in a remote machine.  It is intended to replace
rlogin and rsh, and provide secure encrypted communications between
two untrusted hosts over an insecure network.  X11 connections and
arbitrary TCP/IP ports can also be forwarded over the secure channel.

OpenSSH is OpenBSD's rework of the last free version of SSH, bringing it
up to date in terms of security and features, as well as removing all
patented algorithms to seperate libraries (OpenSSL).

This package includes the clients necessary to make encrypted connections
to SSH servers.

%description -n %oname-keysign-gostcrypto
ssh-keysign is used by ssh(1) to access the local host keys and generate
the digital signature required during hostbased authentication with SSH
protocol version 2.  ssh-keysign is not intended to be invoked by the
user, but from ssh(1).  See ssh(1) and sshd(8) for more information about
hostbased authentication.

%description -n %oname-server-gostcrypto
Ssh (Secure Shell) a program for logging into a remote machine and for
executing commands in a remote machine.  It is intended to replace
rlogin and rsh, and provide secure encrypted communications between
two untrusted hosts over an insecure network.  X11 connections and
arbitrary TCP/IP ports can also be forwarded over the secure channel.

OpenSSH is OpenBSD's rework of the last free version of SSH, bringing it
up to date in terms of security and features, as well as removing all
patented algorithms to seperate libraries (OpenSSL).

This package contains the secure shell daemon.  The sshd is the server
part of the secure shell protocol and allows ssh clients to connect to
your host.

%description -n %oname-server-control-gostcrypto
This package contains control rules for OpenSSH server configuration.
See control(8) for details.

%description -n %oname-askpass-common-gostcrypto
Ssh (Secure Shell) a program for logging into a remote machine and for
executing commands in a remote machine.  It is intended to replace
rlogin and rsh, and provide secure encrypted communications between
two untrusted hosts over an insecure network.  X11 connections and
arbitrary TCP/IP ports can also be forwarded over the secure channel.

OpenSSH is OpenBSD's rework of the last free version of SSH, bringing it
up to date in terms of security and features, as well as removing all
patented algorithms to seperate libraries (OpenSSL).

This package contains OpenSSH passphrase dialog infrastructure.
These dialogs are intended to be called from the ssh-add program and
not invoked directly.

%prep
%setup -n %name-%version-%release

%build
%autoreconf

mkdir build
cd build
%define _configure_script ../configure

export ac_cv_path_LOGIN_PROGRAM_FALLBACK=/bin/login
export ac_cv_path_NROFF=/usr/bin/nroff
export ac_cv_path_PATH_PASSWD_PROG=/usr/bin/passwd
export ac_cv_path_PROG_LASTLOG=/usr/bin/lastlog
export ac_cv_path_xauth_path=/usr/bin/xauth

# For some reason this function fails with gost-engine ciphers,
# but the fallback seems to work.
export ac_cv_func_EVP_CIPHER_CTX_get_updated_iv=no

%configure \
	--sysconfdir=%confdir \
	--without-rpath \
	--disable-strip \
	--with-mantype=doc \
	--with-pam \
	--with-ipaddr-display \
	--with-privsep-user=sshd \
	--with-privsep-path=%_chrootdir \
	--with-default-path=/bin:/usr/bin:/usr/local/bin \
	--with-superuser-path=/sbin:/usr/sbin:/usr/local/sbin:/bin:/usr/bin:/usr/local/bin \
	%{subst_with kerberos5} \
	%{subst_with libedit} \
	%{subst_with openssl} \
%if_with ssl_engine
	--with-ssl-engine \
%endif
	%{subst_with selinux} \
	%{?_with_libaudit:--with-audit=linux} \
	%{?_with_security_key_builtin:--with-security-key-builtin} \
	#
%make_build

%install
%makeinstall_std -C build

mkdir -p %buildroot{%_libexecdir,%_sysconfdir{,/X11}/profile.d,%systemd_unitdir}
mkdir -p %buildroot%confdir/authorized_keys{,2}
install -pD -m600 alt/sshd.pamd \
	%buildroot%_pamdir/sshd
install -pD -m755 alt/sshd.init \
	%buildroot%_initdir/sshd
install -pD -m600 alt/sshd.sysconfig \
	%buildroot%_sysconfdir/sysconfig/sshd
install -p -m755 alt/rescp \
	%buildroot%_bindir/
install -p -m755 alt/ssh-agent.sh \
	%buildroot%_sysconfdir/X11/profile.d/
install -pD -m755 alt/sftp.control \
        %buildroot%_sysconfdir/control.d/facilities/sftp
install -pD -m755 alt/sshd-allow-groups.control \
        %buildroot%_sysconfdir/control.d/facilities/sshd-allow-groups
install -pD -m755 alt/sshd-password-auth.control \
        %buildroot%_sysconfdir/control.d/facilities/sshd-password-auth

install -pD -m644 alt/sshd.service \
	%buildroot%systemd_unitdir/sshd.service

sed -i 's,@LIBEXECDIR@,%_libexecdir,g' \
        %buildroot%_sysconfdir/control.d/facilities/sftp

install -p -m755 contrib/ssh-copy-id %buildroot%_bindir/
install -p -m644 contrib/ssh-copy-id.1 %buildroot%_man1dir/

chmod 711 %buildroot%_sbindir/*

install -p -m755 alt/ssh-askpass.{sh,csh} \
	%buildroot%_sysconfdir/profile.d/

mkdir -p %buildroot%docdir
install -pm644 CREDITS LICENCE README* PROTOCOL* alt/[CR]* alt/faq.html \
	%buildroot%docdir/

%pre -n %oname-clients-gostcrypto
/usr/sbin/groupadd -r -f sshagent

%pre -n %oname-server-gostcrypto
/usr/sbin/groupadd -r -f sshd
/usr/sbin/useradd -r -g sshd -d %_chrootdir -s /dev/null -n sshd >/dev/null 2>&1 ||:
%pre_control sftp sshd-allow-groups sshd-password-auth

%post -n %oname-server-gostcrypto
%post_control -s enabled sftp
%post_control -s disabled sshd-allow-groups
%post_control -s default sshd-password-auth
if [ $1 -ge 2 ]; then
	/sbin/service sshd condreload ||:
else
	/sbin/chkconfig --add sshd ||:
fi

%preun -n %oname-server-gostcrypto
if [ $1 = 0 ]; then
	/sbin/chkconfig --del sshd ||:
fi

%files

%files -n %oname-common-gostcrypto
%_bindir/scp
%_bindir/ssh-keygen
%_man1dir/scp.*
%_man1dir/ssh-keygen.*
%docdir/

%files -n %oname-clients-gostcrypto
%attr(751,root,root) %dir %confdir
%config(noreplace) %confdir/ssh_config
%config(noreplace) %_sysconfdir/X11/profile.d/*
%_bindir/rescp
%_bindir/sftp
%_bindir/ssh
%_bindir/ssh-add
%attr(2711,root,sshagent) %_bindir/ssh-agent
%_bindir/ssh-copy-id
%_bindir/ssh-keyscan
%attr(751,root,root) %dir %_libexecdir
%_libexecdir/ssh-pkcs11-helper
%_libexecdir/ssh-sk-helper
%_man1dir/sftp.*
%_man1dir/ssh.*
%_man1dir/ssh-add.*
%_man1dir/ssh-agent.*
%_man1dir/ssh-copy-id.*
%_man1dir/ssh-keyscan.*
%_man5dir/ssh_config.*
%_man8dir/ssh-pkcs11-helper.*
%_man8dir/ssh-sk-helper.*

%files -n %oname-keysign-gostcrypto
%attr(751,root,root) %dir %_libexecdir
%_libexecdir/ssh-keysign
%_man8dir/ssh-keysign.*

%files -n %oname-server-gostcrypto
%attr(751,root,root) %dir %confdir
%attr(600,root,root) %config %confdir/moduli
%attr(600,root,root) %config(noreplace) %verify(not size md5 mtime) %confdir/sshd_config
%attr(600,root,root) %config(noreplace) %_pamdir/sshd
%attr(600,root,root) %config(noreplace) %_sysconfdir/sysconfig/sshd
%attr(755,root,root) %config %_initdir/sshd
%attr(751,root,root) %dir %confdir/authorized_keys*
%systemd_unitdir/*
%_sbindir/*
%attr(751,root,root) %dir %_libexecdir
%_libexecdir/sftp-server
%_man5dir/moduli.*
%_man5dir/sshd_config.*
%_man8dir/sshd.*
%_man8dir/sftp-server.*

%files -n %oname-server-control-gostcrypto
%attr(755,root,root) %_controldir/*

%files -n %oname-askpass-common-gostcrypto
%_sysconfdir/profile.d/ssh-askpass.*
%attr(751,root,root) %dir %_libexecdir

%changelog
