%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

%define soname 1.14

# https://github.com/AcademySoftwareFoundation/OpenShadingLanguage/issues/1810
%define optflags_lto %nil

# the required range is 11.0...20.1
%ifarch %e2k
%define llvm_ver 13.0
%else
%define llvm_ver 20.1
%endif

%ifarch x86_64
%def_with optix
%filter_from_requires /libcudart\.so\.12/d
%else
%def_without optix
%endif

Name: openshadinglanguage
Version: 1.14.7.0
Release: alt0.1
Summary: Advanced shading language for production GI renderers
Group: Development/Other
License: BSD-3-Clause
URL: https://github.com/AcademySoftwareFoundation/OpenShadingLanguage

# 64 bit only
ExcludeArch: %ix86

# https://github.com/AcademySoftwareFoundation/OpenShadingLanguage.git
Source: %name-%version.tar
Source2: %name.watch

Patch: osl-alt-optix-inc.patch

BuildRequires(pre): rpm-build-python3
BuildRequires(pre): libopenimageio-devel
BuildRequires(pre): cmake
BuildRequires: gcc-c++
BuildRequires: llvm%{llvm_ver}-devel clang%{llvm_ver}-devel
BuildRequires: boost-complete
BuildRequires: openexr-devel
BuildRequires: flex bison
BuildRequires: libpugixml-devel
BuildRequires: python3 pybind11-devel libnumpy-py3-devel
BuildRequires: qt6-base-devel
BuildRequires: zlib-devel
BuildRequires: partio-devel
BuildRequires: librobin-map-devel
%if_with optix
BuildRequires: optix-devel
%endif

%define oiio_major_minor_ver %(rpm -q --queryformat='%%{VERSION}' libopenimageio-devel | cut -d . -f 1-2)

%ifarch x86_64
%add_verify_elf_skiplist %_libdir/lib_*_oslexec.so
%endif

%description
Open Shading Language (OSL) is a small but rich language
for programmable shading in advanced renderers and other applications,
ideal for describing materials, lights, displacement, and pattern generation.

%package -n lib%name%soname
Summary: Advanced shading language for production GI renderers
Group: System/Libraries

%description -n lib%name%soname
Open Shading Language (OSL) is a small but rich language
for programmable shading in advanced renderers and other applications,
ideal for describing materials, lights, displacement, and pattern generation.

%package -n openimageio-plugin-%name
Summary: Open Shading Language input plugin for OpenImageIO
Group: System/Libraries

%description -n openimageio-plugin-%name
Open Shading Language (OSL) is a small but rich language
for programmable shading in advanced renderers and other applications,
ideal for describing materials, lights, displacement, and pattern generation.

This is a plugin to access Open Shading Language from OpenImageIO.

%package devel
Summary: Advanced shading language for production GI renderers
Group: Development/C++
Requires: %name = %EVR
Requires: lib%name%soname = %EVR
Requires: %name-example-shaders-source = %EVR
Requires: %name-common-headers = %EVR
Requires: python3-module-%name = %EVR
Requires: openimageio-plugin-%name = %EVR

%description devel
Open Shading Language (OSL) is a small but rich language
for programmable shading in advanced renderers and other applications,
ideal for describing materials, lights, displacement, and pattern generation.

This package contains development files for Open Shading Language.

%package doc
Summary: Documentation for OpenShadingLanguage
Group: Documentation

%description doc
Open Shading Language (OSL) is a small but rich language
for programmable shading in advanced renderers and other applications,
ideal for describing materials, lights, displacement, and pattern generation.

This package contains documentation for Open Shading Language.

%package example-shaders-source
Summary: OSL shader examples
Group: Development/Other
Requires: %name-common-headers = %EVR

%description example-shaders-source
Open Shading Language (OSL) is a small but rich language
for programmable shading in advanced renderers and other applications,
ideal for describing materials, lights, displacement, and pattern generation.

This package contains some Open Shading Language example shaders.

%package common-headers
Summary: OSL standard library and auxiliary headers
Group: Development/C++

%description common-headers
Open Shading Language (OSL) is a small but rich language
for programmable shading in advanced renderers and other applications,
ideal for describing materials, lights, displacement, and pattern generation.

This package contains the Open Shading Language standard library headers,
as well as some additional headers useful for writing shaders.

%package -n python3-module-%name
Summary: Open Shading Language (OSL) python3 module
Group: Development/Python3

%description -n python3-module-%name
Open Shading Language (OSL) python3 module.

%package optix
Summary: NVIDIA OptiX kernels
Group: Graphics

%description optix
NVIDIA OptiX kernels for OSL. This is currently used to cache ptx generation
for OptiX/GPU rendering.

%prep
%setup
%patch -p1

%build
export ALTWRAP_LLVM_VERSION=%llvm_ver
%cmake \
	-DCMAKE_BUILD_TYPE=RelWithDebInfo \
	-DCMAKE_STRIP:STRING="" \
	-DCMAKE_CXX_STANDARD=17 \
	-DOSL_SHADER_INSTALL_DIR:PATH=%_datadir/%name/shaders/ \
	-DSTOP_ON_WARNING:BOOL=OFF \
%ifarch x86_64
	-DUSE_SIMD="avx,f16c" \
	-DUSE_BATCHED="b8_AVX" \
%endif
%if_with optix
	-DOSL_USE_OPTIX:BOOL=ON \
	-DOSL_PTX_INSTALL_DIR:PATH=%_datadir/%name/ptx/ \
%endif
	%nil

%cmake_build

%install
%cmake_install

# Move the OpenImageIO plugin into its default search path
mkdir -p %buildroot%_libdir/OpenImageIO-%{oiio_major_minor_ver}
mv %buildroot%_libdir/osl.imageio.so %buildroot%_libdir/OpenImageIO-%{oiio_major_minor_ver}/

# remove examples and unused files
rm -f %buildroot%_prefix/build-scripts/serialize-bc.py
rm -f %buildroot%_prefix/cmake/llvm_macros.cmake

%files
%_bindir/*

%files -n lib%name%soname
%doc LICENSE.md THIRD-PARTY.md
%doc CHANGES.md CODE_OF_CONDUCT.md CONTRIBUTING.md GOVERNANCE.md README.md
%_libdir/lib*.so.%{soname}
%_libdir/lib*.so.%{soname}.*

%files -n openimageio-plugin-%name
%_libdir/OpenImageIO-%{oiio_major_minor_ver}/osl.imageio.so

%if_with optix
%files optix
%_datadir/%name/ptx
%endif

%files devel
%_includedir/*
%_libdir/lib*.so
%_libdir/cmake/*
%_pkgconfigdir/*

%files doc
%doc %_defaultdocdir/OSL/

%files example-shaders-source
%_datadir/%name/shaders/*.osl
%_datadir/%name/shaders/*.oso

%files common-headers
%dir %_datadir/%name
%dir %_datadir/%name/shaders
%_datadir/%name/shaders/*.h

%files -n python3-module-%name
%python3_sitelibdir/oslquery

%changelog
