Name: openocd
Version: 0.12.0
Release: alt8

Summary: Debugging, in-system programming and boundary-scan testing for embedded devices
License: GPLv2
Group: Development/Tools
Url: http://sourceforge.net/projects/openocd

Requires: libjaylink >= 0.4.0

Source: %name-%version-%release.tar

BuildRequires: texinfo
BuildRequires: pkgconfig(capstone)
BuildRequires: pkgconfig(hidapi-hidraw)
BuildRequires: pkgconfig(jimtcl)
BuildRequires: pkgconfig(libftdi1)
BuildRequires: pkgconfig(libgpiod)
BuildRequires: pkgconfig(libjaylink)
BuildRequires: pkgconfig(libusb-1.0)

%description
The Open On-Chip Debugger (OpenOCD) provides debugging, in-system
programming and boundary-scan testing for embedded devices. Various
different boards, targets, and interfaces are supported to ease
development time.

Install OpenOCD if you are looking for an open source solution for
hardware debugging.

%prep
%setup

%build
%autoreconf
%configure  --disable-werror \
            --disable-doxygen-html \
            --disable-internal-jimtcl \
            --disable-internal-libjaylink \
            #
%make_build

%install
%makeinstall_std
install -pm644 -D contrib/60-openocd.rules %buildroot%_udevrulesdir/60-openocd.rules
rm -rf %buildroot%_datadir/openocd/contrib

%pre
/usr/sbin/groupadd -r -f plugdev &>/dev/null ||:

%files
%doc COPYING README
%_udevrulesdir/*.rules
%_bindir/openocd
%_datadir/openocd
%_infodir/openocd.info*
%_man1dir/*

%changelog
