%define _unpackaged_files_terminate_build 1
%define so_ver 2
%add_verify_elf_skiplist %_libdir/libslapi*
### Build switches for enable or disable fiture ###
%def_enable doc
%def_disable sql
%def_disable perl
%def_enable sasl
### Disable, because while build by rpm is not passed
%def_disable debug
%def_disable slapi
%def_disable slp
%def_enable overlay
%def_enable aci
%def_enable yielding
%def_enable argon2
%def_disable static
%define contrib_slapo_name addpartial allop allowed authzid autogroup cloak datamorph denyop lastbind noopsrch passwd/sha2 passwd/pbkdf2 smbk5pwd trace usn variant vc

Name: openldap
Version: 2.6.10
Release: alt1

Obsoletes: openldap2.4 < %version-%release

%define ldap_ssl_dir %_sysconfdir/%name/ssl
%define ssl_dir %_localstatedir/ssl/certs
%define ldap_dir %_localstatedir/ldap

Summary: LDAP libraries and sample clients
License: OLDAP-2.8
Group: System/Servers
Url: http://www.openldap.org/

Packager: OpenLDAP Maintainers Team <openldap@packages.altlinux.org>

# ftp://ftp.openldap.org/pub/OpenLDAP/openldap-release/
Source: %name-%version.tar

# Docs for this products
#Source2: %name-README.upgrading
Source3: %name-README.ALT
Source4: %name-config-README.ALT

# System Specific source
Source11: %name.sysconfig
Source12: %name-slapd.init
Source13: %name.logrotate
Source14: %name-slapd.service

## Chroot config
Source15: %name-ldap.all
Source16: %name-ldap.conf
Source17: %name-ldap.lib
# This file we need to build from original dynamic
Source18: %name-slapd.conf
Source20: %name-slapd-access.conf
Source21: %name-slapd-mdb-db01.conf
# OLC config directory backup/restore scripts
Source40: %name-olc-backup
Source41: %name-olc-restore

# Extended OpenLDAP schemas
Source50: %name-addon-schemas.tar
Source51: %name-ALT-rootdse.ldif

### PATCHES
Patch1: %name-alt-defaults.patch

## Patch created by Alexander Bokovoy <ab@altlinux.ru>
Patch2: %name-2.3.34-alt-pid.patch

Patch4: %name-2.6.7-alt-makefile.patch

Patch13: %name-2.4.25-rh-ldaprc-currentdir.patch
Patch14: %name-2.4.25-rh-reentrant-gethostby.patch
Patch16: %name-2.6.3-rh-ai-addrconfig.patch
# fix back_perl problems with lt_dlopen()
# might cause crashes because of symbol collisions
# the proper fix is to link all perl modules against libperl
# http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=327585
Patch18: %name-2.6.3-rh-switch-to-lt_dlopenadvise-to-get-RTLD_GLOBAL-set.patch
Patch19: %name-2.6.3-rh-add-export-symbols-LDAP_CONNECTIONLESS.patch

Patch20: %name-2.6.1-system-mdb.patch
Patch21: %name-2.6.8-alt-smbk5pwd.patch
Patch22: %name-2.6.1-cloak.patch
Patch23: %name-ITS-10297-Defer-hostname-resolution-til-first-use.patch

### REQUIRE Section

%if_enabled doc
# For compile documentations need "sdf".
BuildRequires: sdf >= 2
%endif
%if_enabled sasl
# due to SASL_AUXPROP_PLUG_VERSION
BuildRequires: libsasl2-devel >= 2.1.24-alt1.cvs.20090508
%endif
%if_enabled sql
BuildRequires: libunixODBC-devel
%endif
%if_enabled perl
BuildRequires: perl-devel
%endif
%if_enabled slp
BuildRequires: libopenslp-devel
%endif
%{?_enable_argon2:BuildRequires: libsodium-devel}

BuildRequires: chrooted groff-base libltdl-devel libssl-devel shtool
BuildRequires: libsystemd-devel
BuildRequires: libevent-devel libuuid-devel
BuildRequires: liblmdb-devel
# for tests
#BuildRequires: krb5-kdc krb5-kinit cyrus-sasl2 libsasl2-plugin-gssapi openssl

%package -n libldap%{so_ver}
Summary: OpenLDAP libraries
Group: System/Libraries
Requires: %name-common = %version-%release
Provides: libldap = %version-%release

%package -n libldap-devel
Summary: OpenLDAP development libraries and header files
Group: Development/C
Requires: libldap%{so_ver} = %version-%release

Provides: openldap-devel = %version-%release
Obsoletes: openldap-devel < %version-%release

%package -n libldap-devel-static
Summary: OpenLDAP development static libraries
Group: Development/C
Requires: libldap-devel = %version-%release
Provides: openldap-devel-static = %version-%release
Obsoletes: openldap-devel-static < %version-%release

%package common
Summary: Common files for OpenLDAP
Group: System/Servers
Obsoletes: %name < 2.4.56-alt1
BuildArch: noarch

%package servers
Summary: LDAP servers
Group: System/Servers
Requires: libldap%{so_ver} = %version-%release

Provides: openldap2.4-servers = %version-%release
Obsoletes: openldap2.4-servers < %version-%release

%package clients
Summary: LDAP utilities, tools and sample clients
Group: Networking/Remote access
Requires: libldap%{so_ver} = %version-%release

Provides: openldap2.4-clients = %version-%release
Obsoletes: openldap2.4-clients < %version-%release

%package -n %name-doc
Summary: OpenLDAP administration guide
Group: Books/Computer books
BuildArch: noarch
Obsoletes: openldap2.4-doc < %version-%release

%package contrib
Summary: OpenLDAP Contrib Modules
Group: System/Servers
Requires: %name-servers = %version-%release

%description
OpenLDAP is an open source suite of LDAP (Lightweight Directory Access
Protocol) applications and development tools.  LDAP is a set of
protocols for accessing directory services (usually phone book style
information, but other information is possible) over the Internet,
similar to the way DNS (Domain Name System) information is propagated
over the Internet.  The suite includes a stand-alone LDAP server
(slapd), libraries for implementing the LDAP protocol, utilities, 
tools, and sample clients.

Install %name if you need to run LDAP-based applications and tools.

%description -n libldap%{so_ver}
OpenLDAP is an open source suite of LDAP (Lightweight Directory Access
Protocol) applications and development tools.  LDAP is a set of
protocols for accessing directory services (usually phone book style
information, but other information is possible) over the Internet,
similar to the way DNS (Domain Name System) information is propagated
over the Internet.  The suite includes a stand-alone LDAP server
(slapd), libraries for implementing the LDAP protocol, utilities, 
tools, and sample clients.

This package contains shared libraries needed for make works %name-based softare.

%description -n libldap-devel
OpenLDAP is an open source suite of LDAP (Lightweight Directory Access
Protocol) applications and development tools.  LDAP is a set of
protocols for accessing directory services (usually phone book style
information, but other information is possible) over the Internet,
similar to the way DNS (Domain Name System) information is propagated
over the Internet.  The suite includes a stand-alone LDAP server
(slapd), libraries for implementing the LDAP protocol, utilities, 
tools, and sample clients.

This package includes the development libraries and header files needed
for developing applications that use LDAP internals. Install this package
only if you plan to develop or will need to compile customized LDAP clients.

%description -n libldap-devel-static
OpenLDAP is an open source suite of LDAP (Lightweight Directory Access
Protocol) applications and development tools.  LDAP is a set of
protocols for accessing directory services (usually phone book style
information, but other information is possible) over the Internet,
similar to the way DNS (Domain Name System) information is propagated
over the Internet.  The suite includes a stand-alone LDAP server
(slapd), libraries for implementing the LDAP protocol, utilities, 
tools, and sample clients.

This package includes the static libraries needed for developing statically
linked applications that use LDAP internals.

%description common
Common files for OpenLDAP.

%description servers
OpenLDAP is an open source suite of LDAP (Lightweight Directory Access
Protocol) applications and development tools.  LDAP is a set of
protocols for accessing directory services (usually phone book style
information, but other information is possible) over the Internet,
similar to the way DNS (Domain Name System) information is propagated
over the Internet.  The suite includes a stand-alone LDAP server
(slapd), libraries for implementing the LDAP protocol, utilities, 
tools, and sample clients.

Install %name-servers if you need LDAP servers.
The server provides several database backends and overlays.

%description clients
OpenLDAP is an open source suite of LDAP (Lightweight Directory Access
Protocol) applications and development tools.  LDAP is a set of
protocols for accessing directory services (usually phone book style
information, but other information is possible) over the Internet,
similar to the way DNS (Domain Name System) information is propagated
over the Internet.  The suite includes a stand-alone LDAP server
(slapd), libraries for implementing the LDAP protocol, utilities, 
tools, and sample clients.

Install %name-client if you need LDAP applications and tools.

%description doc
OpenLDAP Administration Guide
HTML and TXT versions

%description contrib
Various overlays found in contrib/:
 * addpartial    Intercepts ADD requests, applies changes to existing entries
 * allop
 * allowed       Generates attributes indicating access rights
 * autogroup
 * authzid       implements RFC 3829 support
 * cloak
 * datamorph     store enumerated values and fixed size integers
 * denyop
 * lastbind      writes last bind timestamp to entry
 * noopsrch      handles no-op search control
 * pw-sha2       generates/validates SHA-2 password hashes
 * pw-pbkdf2     generates/validates PBKDF2 password hashes
 * smbk5pwd      generates Samba3 password hashes (heimdal krb disabled)
 * trace         traces overlay invocation
 * usn           usnCreated and usnChanged operational attributes
 * variant       allows attributes/values to be shared between several entries
 * vc            implements the verify credentials extended operation

%prep
%setup -q
%patch1 -p1
%patch2 -p1
%patch4 -p1

%patch13 -p1
%patch14 -p1
%patch16 -p1
%patch18 -p1
%patch19 -p1
%patch20 -p1
%patch21 -p1
%patch22 -p1
%patch23 -p1
rm -r libraries/liblmdb

# Add some more schema for the sake of migration scripts and others
pushd servers/slapd
tar -xf %SOURCE50
popd

mv servers/slapd/back-perl/README{,.back_perl}

# fix documentation encoding
for filename in doc/drafts/draft-ietf-ldapext-acl-model-xx.txt; do
  iconv -f iso-8859-1 -t utf-8 "$filename" > "$filename.utf8"
  mv "$filename.utf8" "$filename"
done

%build
# Options -lresolv in line below need for some bad configure scripts like in auth_ldap package
#export LDFLAGS="$LDFLAGS -lresolv"
export CPPFLAGS="$CPPFLAGS -DLOG_DAEMON=1"

export CFLAGS="%optflags -Wno-format-extra-args -fno-strict-aliasing -DNDEBUG -DSLAP_SCHEMA_EXPOSE -DLDAP_COLLECTIVE_ATTRIBUTES -DOPENSSL_NO_MD2"
export STRIP=""
# enable experimental support for LDAP over UDP (LDAP_CONNECTIONLESS)
export CFLAGS="${CFLAGS} -DLDAP_CONNECTIONLESS"
export PKG_CONFIG=pkg-config

#shtoolize all
#aclocal
#autoconf
#libtoolize --force --install
%autoreconf
%configure \
	%{subst_enable static} \
	--enable-syslog \
	--enable-dynamic \
	--enable-versioning \
	--enable-dynacl \
	--enable-cleartext \
	--enable-crypt \
	--with-tls=openssl \
	--with-threads \
	--enable-slapd \
	--enable-modules \
	--enable-backends=mod \
	--enable-mdb=yes \
	--disable-wt \
	--enable-balancer=mod \
	%{subst_enable argon2} \
	\
%if_enabled yielding
	--with-yielding-select \
%else
	--without-yielding-select \
%endif
%if_enabled aci
	--enable-aci \
%else
	--disable-aci \
%endif
%if_enabled slapi
	--enable-slapi \
%else
	--disable-slapi \
%endif
%if_enabled slp
	--enable-slp \
%else
	--disable-slp \
%endif
%if_enabled sql
	--enable-sql=mod \
%else
	--disable-sql \
%endif
%if_enabled sasl
	--with-cyrus-sasl \
	--enable-spasswd \
%else
	--without-cyrus-sasl \
%endif
%if_enabled perl
	--enable-perl=mod \
%else
	--disable-perl \
%endif
%if_enabled overlay
	--enable-overlays=mod \
%else
	--disable-overlays \
%endif
%if_enabled debug
	--enable-debug \
%endif
	--with-systemd \
	--without-fetch \
	--with-threads \
	--with-pic \
	--with-gnu-ld

%__subst 's/^AC_CFLAGS.*/& %optflags_shared/' libraries/librewrite/Makefile

#%make depend
#export NPROCS=1
%make_build

pushd libraries/liblutil
rm -f libldif.la
MOD_LIBS="-L../liblber/.libs/ -L../libldap/.libs/ -llber -lldap" make
popd

# Build selected contrib overlays
for SLAPO_NAME in %contrib_slapo_name
do
  %make_build -C contrib/slapd-modules/${SLAPO_NAME} prefix="%_prefix" libdir="%_libdir" libexecdir="%_libexecdir" 
done
# slapo-smbk5pwd only for Samba password hashes
%make_build -C contrib/slapd-modules/smbk5pwd DEFS="-DDO_SAMBA" HEIMDAL_LIB="" prefix="%_prefix" libdir="%_libdir" libexecdir="%_libexecdir" 

%if_enabled doc
# Build Administrator Guide in html and text mode
pushd doc/guide/admin
sdf -2topics index.sdf
sdf -2txt guide.sdf
popd
%endif

%install
%makeinstall_std STRIP=""
###
## Install all slapd's file
###

# Install selected contrib overlays
for SLAPO_NAME in %contrib_slapo_name smbk5pwd
do
  %make_install -C contrib/slapd-modules/${SLAPO_NAME} STRIP="" DESTDIR="%buildroot" prefix="%_prefix" libdir="%_libdir" libexecdir="%_libexecdir" install
done

# Create the /var/lib data directory and chroot enviroment.
mkdir -p -m750 %buildroot%ldap_dir
mkdir -p -m750 %buildroot%ldap_dir/bases
mkdir -p -m770 %buildroot%ldap_dir/dblogs
#mkdir -p -m750 %buildroot%ldap_dir/replica
mkdir -p -m755 %buildroot%ldap_dir/dev
mkdir -p -m750 %buildroot%ldap_dir%_sysconfdir/ssl
mkdir -p -m750 %buildroot%ldap_dir%_sysconfdir/schema
ln -s . %buildroot%ldap_dir%_sysconfdir/%name
mkdir -p -m775 %buildroot%ldap_dir/lib
ln -s lib %buildroot%ldap_dir/lib64
mkdir -p -m755 %buildroot%ldap_dir/usr/lib/%name
mkdir -p -m755 %buildroot%ldap_dir/usr/lib/sasl2-3
ln -s lib %buildroot%ldap_dir/usr/lib64
mkdir -p -m775 %buildroot%ldap_dir/var/run
mkdir -p -m775 %buildroot%ldap_dir%ldap_dir
ln -s ../../../bases %buildroot%ldap_dir%ldap_dir/
ln -s ../../../dblogs %buildroot%ldap_dir%ldap_dir/
mksock %buildroot%ldap_dir/dev/log

# Install init scripts.
install -pD -m644 %SOURCE11 %buildroot%_sysconfdir/sysconfig/ldap
install -pD -m755 %SOURCE12 %buildroot%_initdir/slapd
mkdir -p -m750 %buildroot%_sysconfdir/chroot.d
install -pD -m750 %SOURCE15 %buildroot%_sysconfdir/chroot.d/ldap.all
install -pD -m750 %SOURCE16 %buildroot%_sysconfdir/chroot.d/ldap.conf
install -pD -m750 %SOURCE17 %buildroot%_sysconfdir/chroot.d/ldap.lib
install -pD -m644 %SOURCE14 %buildroot%_unitdir/slapd.service

# Install OLC (cn=config) directory backup/restore scripts
install -pD -m750 %SOURCE40 %buildroot%_sbindir/slapd-olc-backup
install -pD -m750 %SOURCE41 %buildroot%_sbindir/slapd-olc-restore

# log repository and logrotate config
#__mkdir_p -m750 %buildroot%_logdir/ldap
#__install -pD -m644 %SOURCE13 %buildroot%_logrotatedir/ldap

# syslog.d
mkdir -pm700 %buildroot%_sysconfdir/syslog.d
ln -s %ldap_dir/dev/log %buildroot%_sysconfdir/syslog.d/ldap

# config files
mkdir -p -m750 %buildroot%_sysconfdir/%name/ssl
install -pD -m640 %SOURCE18 %buildroot%_sysconfdir/%name/slapd.conf
install -pD -m640 %SOURCE20 %buildroot%_sysconfdir/%name/slapd-access.conf
install -pD -m640 %SOURCE21 %buildroot%_sysconfdir/%name/slapd-mdb-db01.conf
install -pD -m644 %SOURCE51 %buildroot%_sysconfdir/%name/rootdse.ldif

# We don't need the default files - let's move it.
mkdir -p %buildroot%_docdir/%name-servers-%version/default
mv %buildroot%_sysconfdir/%name/*.default \
	%buildroot%_docdir/%name-servers-%version/default/
rm -f %buildroot%_sysconfdir/%name/slapd.ldif

# Documentations for servers
mkdir -p %buildroot%_docdir/%name-servers-%version/{back-{null,perl,sql},schema,slapi,overlays}/
install -D -m644 servers/slapd/back-ldap/TODO.proxy \
	%buildroot%_docdir/%name-servers-%version/back-ldap/TODO.proxy
install -D -m644 servers/slapd/back-monitor/README \
	%buildroot%_docdir/%name-servers-%version/back-monitor/README
install -D -m644 servers/slapd/back-null/README \
	%buildroot%_docdir/%name-servers-%version/back-null/README
%if_enabled perl
install -D -m644 servers/slapd/back-perl/{README,SampleLDAP.pm} \
	%buildroot%_docdir/%name-servers-%version/back-perl/
%endif

%if_enabled sql
install -D -m644 servers/slapd/back-sql/docs/* \
	%buildroot%_docdir/%name-servers-%version/back-sql/
cp -r servers/slapd/back-sql/rdbms_depend \
	%buildroot%_docdir/%name-servers-%version/back-sql/
%endif

%if_enabled slapi
install -pD -m644 servers/slapd/slapi/TODO \
        %buildroot%_docdir/%name-servers-%version/slapi/TODO
%endif

%if_enabled overlay
install -pD -m644 servers/slapd/overlays/README \
        %buildroot%_docdir/%name-servers-%version/overlays/README
install -pD -m644 servers/slapd/overlays/slapover.txt \
        %buildroot%_docdir/%name-servers-%version/overlays/slapover.txt
install -pD -m644 contrib/slapd-modules/smbk5pwd/README \
        %buildroot%_docdir/%name-servers-%version/overlays/README.smbk5pwd
install -pD -m644 contrib/slapd-modules/allop/README \
        %buildroot%_docdir/%name-servers-%version/overlays/README.allop
%endif

install -p -m644 servers/slapd/schema/README \
	%buildroot%_docdir/%name-servers-%version/schema/README
##slapd
install -p -m644 %SOURCE3 \
	%buildroot%_docdir/%name-servers-%version/README.ALT
install -p -m644 %SOURCE4 \
	%buildroot%_docdir/%name-servers-%version/config-README.ALT

%if_enabled doc
## Install Administration Guide 
mkdir -p %buildroot%_docdir/%name-doc-%version/images
install -pD -m644 doc/guide/images/*.gif \
	%buildroot%_docdir/%name-doc-%version/images
mkdir -p %buildroot%_docdir/%name-doc-%version/admin-guide
#install -pD -m644 doc/guide/admin/*.gif \
#	%buildroot/%_docdir/%name-doc-%version/admin-guide/
install -pD -m644 doc/guide/admin/*.html \
	%buildroot%_docdir/%name-doc-%version/admin-guide/
install -p -m644 doc/guide/admin/guide.txt \
	%buildroot%_docdir/%name-doc-%version/
%endif

# Purge dependency_libs from .la files.
%__subst -p 's/^\(dependency_libs=\).*/\1'\'\'/ \
	%buildroot%_libexecdir/%name/*.la


%check
# rm failed tests
rm -f tests/scripts/test063-delta-multiprovider
%make SLAPD_DEBUG=0 test

%pre servers
# Take care to only do ownership-changing if we're adding the user.
/usr/sbin/groupadd -rf ldap
/usr/sbin/useradd  -rM -c "LDAP User" -g ldap -u 55 -s /dev/null -d %ldap_dir ldap &>/dev/null
if [ -d "$ldap_ssl_dir" -a ! -L "$ldap_ssl_dir" ]; then
	echo "Your certificates are moved to $ldap_ssl_dir.rpmsave, please CHECK!"
	mv "$ldap_ssl_dir" "$ldap_ssl_dir".rpmsave
fi	

%post servers
# remove old libs from chroot
rm -f /var/lib/ldap/%_libdir/openldap/*
rm -f /var/lib/ldap/%_libdir/sasl2-3/*
rm -f /var/lib/ldap/%_libdir/*.so*
rm -f /var/lib/ldap/%_lib/*.so*

%post_service slapd

%preun servers
%preun_service slapd

%files -n libldap%{so_ver}
%_libdir/*.so.*
%if_enabled slapi
%exclude %_libdir/libslapi*.so.*
%endif


%files -n libldap-devel
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*.pc
%_man3dir/*
%doc doc/{drafts,rfc,devel}

%if_enabled static
%files -n libldap-devel-static
%_libdir/*.a
%endif

%files common
%doc ANNOUNCEMENT CHANGES COPYRIGHT LICENSE README
%dir %_sysconfdir/%name
%config(noreplace) %_sysconfdir/%name/ldap.conf
%_man5dir/ld*

%files servers
%_sysconfdir/chroot.d/ldap.all
%_sysconfdir/chroot.d/ldap.conf
%_sysconfdir/chroot.d/ldap.lib
%_sysconfdir/syslog.d/ldap
#config(noreplace) %_sysconfdir/logrotate.d/ldap

%_sysconfdir/%name/schema
%attr(750,root,ldap) %dir %_sysconfdir/%name/ssl

%config(noreplace) %_sysconfdir/%name/rootdse.ldif
%attr(-,root,ldap)%config(noreplace) %_sysconfdir/%name/slapd-access.conf
%attr(-,root,ldap)%config(noreplace) %_sysconfdir/%name/slapd-mdb-db01.conf
%attr(-,root,ldap)%config(noreplace) %_sysconfdir/%name/slapd.conf

%_initdir/slapd
%_unitdir/slapd.service
%config(noreplace) %_sysconfdir/sysconfig/ldap

%if_enabled slapi
%_libdir/libslapi*.so.*
%endif

%_sbindir/sl*
%dir %_libexecdir/%name
%_libexecdir/%name/accesslog*
%_libexecdir/%name/auditlog*
%_libexecdir/%name/autoca*
%_libexecdir/%name/argon2*
%_libexecdir/%name/back_asyncmeta*
%_libexecdir/%name/back_dnssrv*
%_libexecdir/%name/back_ldap*
%_libexecdir/%name/back_meta*
%_libexecdir/%name/back_null*
%_libexecdir/%name/back_passwd*
%_libexecdir/%name/back_relay*
%_libexecdir/%name/back_sock*
%_libexecdir/%name/collect*
%_libexecdir/%name/constraint*
%_libexecdir/%name/dds*
%_libexecdir/%name/deref*
%_libexecdir/%name/dyngroup*
%_libexecdir/%name/dynlist*
%_libexecdir/%name/home*
%_libexecdir/%name/lloadd*
%_libexecdir/%name/memberof*
%_libexecdir/%name/nestgroup*
%_libexecdir/%name/otp*
%_libexecdir/%name/pcache*
%_libexecdir/%name/ppolicy*
%_libexecdir/%name/refint*
%_libexecdir/%name/remoteauth*
%_libexecdir/%name/retcode*
%_libexecdir/%name/rwm*
%_libexecdir/%name/seqmod*
%_libexecdir/%name/sssvlv*
%_libexecdir/%name/syncprov*
%_libexecdir/%name/translucent*
%_libexecdir/%name/unique*
%_libexecdir/%name/valsort*

%_man5dir/sl*
%_man5dir/ll*
%_man8dir/*

%doc %_docdir/%name-servers-%version
#attr(0775,root,ldap) %dir %_logdir/ldap

%attr(0750,root,ldap) %dir %ldap_dir
%attr(1770,root,ldap) %dir %ldap_dir/bases
%attr(1770,root,ldap) %ldap_dir/dblogs
%attr(0775,root,ldap) %dir %ldap_dir/dev
%ghost %attr(0666,root,root) %ldap_dir/dev/log
%attr(0755,root,ldap) %ldap_dir/etc
%attr(0750,root,ldap) %ldap_dir/lib
%ldap_dir/lib64
%ldap_dir/usr
%ldap_dir/var
%attr(0775,root,ldap) %dir %ldap_dir/var/run

##### CLIENTS
%files clients
%_bindir/*
%_man1dir/*

%if_enabled doc
##### GUIDE
%files doc
%_docdir/%name-doc-%version/*
%dir %_docdir/%name-doc-%version/
%endif

##### CONTRIB modules
%files contrib
%_libexecdir/%name/addpartial*
%_libexecdir/%name/allop*
%_libexecdir/%name/allowed*
%_libexecdir/%name/authzid*
%_libexecdir/%name/autogroup*
%_libexecdir/%name/cloak*
%_libexecdir/%name/datamorph*
%_libexecdir/%name/denyop*
%_libexecdir/%name/lastbind*
%_libexecdir/%name/noopsrch*
%_libexecdir/%name/pw-pbkdf2*
%_libexecdir/%name/pw-sha2*
%_libexecdir/%name/smbk5pwd*
%_libexecdir/%name/trace*
%_libexecdir/%name/usn*
%_libexecdir/%name/variant*
%_libexecdir/%name/vc*

###
# TODO for 2.2.x
#
#[global] correct install all docs to %_docdir
#[global] Correct build with SASL(+++) Need tests
#[FR] Translate Admin Guide
#[FR] Translate LDAP Tools and add working in LOCALE Run-Time envirement.
#[FR] Make load modules correctly by dlopen without *.la files
#[global] Copy or not in back-meta/data directory (may be need to copy this data to Docs dir).
#[NeedBugFix] Remove TEXTREL from back-{modules}
#[global] What is back-tcl ?? man is here, but back modules isn't.
#[global] Generate slapd.conf according slapd.conf in source and man pages back-*
#[global] Create new config shema
#[FR] Import, may be, backup shema from MDK
#[global] Work on SSL/TLS cert dir!(+++) Need tests. 
#[FR] Correct patch for aacls for latest version
#[FR] Create separate package with OpenLDAP test for ALT Specific chroot env
#[FR] Create chroot-scripts dynamic while build package 

%changelog
