%define soname 0.25
%def_with check

Name: openjph
Version: 0.25.3
Release: alt1
Summary: High-throughput JPEG 2000 (HTJ2K) encoder/decoder and library
License: BSD-2-Clause
Group: Graphics
Url: https://github.com/aous72/OpenJPH
VCS: https://github.com/aous72/OpenJPH.git
Source0: %name-%version.tar
Source1: jp2k_test_codestreams-%version.tar
Patch0: %name-%version-%release.patch
BuildRequires(pre): rpm-build-cmake
BuildRequires: gcc-c++
BuildRequires: pkgconfig(libtiff-4)
%if_with check
BuildRequires: ctest libgtest-devel
%endif

%description
Open-source implementation of High-throughput JPEG 2000 (HTJ2K), also known as
JPEG 2000 Part 15 (ISO/IEC 15444-15, ITU-T T.814). Provides command-line tools
for encoding/decoding (.jph/.jp2) and a reusable C++ library.

%package -n libopenjph%soname
Summary: Shared library for OpenJPH (HTJ2K)
Group: System/Libraries

%description -n libopenjph%soname
Shared library implementing High-throughput JPEG 2000 (HTJ2K).

%package -n libopenjph-devel
Summary: Development files for OpenJPH
Group: Development/C++
Requires: libopenjph%soname = %EVR

%description -n libopenjph-devel
Development files for building software that uses the OpenJPH library.


%prep
%setup -a1
%patch0 -p1
# Replace hardcoded test data path in source code
sed -i '/#else/,/#endif/ {
	s|^#define[[:space:]]\+SRC_FILE_DIR[[:space:]]\+.*|#define SRC_FILE_DIR "%_builddir/%name-%version/jp2k_test_codestreams-%version/openjph/"|
	s|^#define[[:space:]]\+REF_FILE_DIR[[:space:]]\+.*|#define REF_FILE_DIR "%_builddir/%name-%version/jp2k_test_codestreams-%version/openjph/references/"|
	}' tests/test_executables.cpp

%build
%cmake \
  -DCMAKE_BUILD_TYPE=Release \
  -DOJPH_BUILD_TESTS=ON \
  -DFETCHCONTENT_FULLY_DISCONNECTED=ON \
  -DFETCHCONTENT_SOURCE_DIR_JP2K_TEST_CODESTREAMS=%_builddir/%name-%version/jp2k_test_codestreams-%version \
%ifnarch x86_64
  -DOJPH_DISABLE_INTEL_SIMD=ON \
%endif
  -DOJPH_DISABLE_AVX512=ON \
  -DBUILD_SHARED_LIBS=ON

%cmake_build

%install
%cmake_install

%check
%ctest

%files
%doc README.md LICENSE
%_bindir/ojph_compress
%_bindir/ojph_expand

%files -n libopenjph%soname
%_libdir/libopenjph.so.%soname
%_libdir/libopenjph.so.%soname.*

%files -n libopenjph-devel
%_includedir/openjph/
%_libdir/libopenjph.so
%_libdir/pkgconfig/openjph.pc
%_libdir/cmake/openjph/

%changelog
