%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%define build_type RelWithDebInfo
%set_verify_elf_method strict

%ifarch x86_64
%def_with cuda
%def_without oneapi
%filter_from_requires /libcudart\.so\.12/d
%else
%def_without cuda
%endif

%def_with hip

%define oname oidn
%define soname 2

Name: openimagedenoise
Version: 2.3.3
Release: alt5
Summary: Intel Open Image Denoise library
Group: Development/Other
License: Apache-2.0
URL: https://www.openimagedenoise.org/

ExclusiveArch: x86_64 aarch64

# https://github.com/OpenImageDenoise/oidn/releases/download/v%version/oidn-%version.src.tar.gz
Source: %oname-%version.tar
Patch: oidn-alt-aarch64-cuda-glibc-fix.patch
Patch1: blender-sycl-add-more-ids.patch
# introduced in https://github.com/intel/llvm/pull/15798
Patch2: sycl-fix-deprecated-warning.patch
# gfx1031 is identical to gfx1030
Patch3: oidn-alt-rocm-add-gfx1031.patch
Patch4: oidn-alt-no-fortify-again.patch

BuildRequires: cmake gcc-c++
BuildRequires: python3
BuildRequires: tbb-devel
BuildRequires: ispc
BuildRequires: libopenimageio-devel chrpath
%if_with hip
BuildRequires: hip-devel hip-runtime-amd rocm-comgr-devel rocm-device-libs hsa-rocr-devel
%endif
%if_with oneapi
# FIXME  sycl code doesn't support LTO?
%define optflags_lto %nil
BuildRequires: llvm-dpcpp-devel clang-dpcpp-devel clang-dpcpp-tools intel-ocloc libze-devel libigc-devel opencl-headers
%endif
%if_with cuda
BuildRequires: nvidia-cuda-devel >= 12.8 nvidia-cuda-devel-static
%endif

%description
Intel Open Image Denoise is an open source library of high-performance,
high-quality denoising filters for images rendered with ray tracing.
Intel Open Image Denoise is part of the Intel oneAPI Rendering Toolkit
and is released under the permissive Apache 2.0 license.

%package -n lib%name%soname
Summary: Intel Open Image Denoise library
Group: System/Libraries

%description -n lib%name%soname
Intel Open Image Denoise is an open source library of high-performance,
high-quality denoising filters for images rendered with ray tracing.
Intel Open Image Denoise is part of the Intel oneAPI Rendering Toolkit
and is released under the permissive Apache 2.0 license.

%package devel
Summary: Intel Open Image Denoise library
Group: Development/C++
Requires: %name = %EVR
Requires: lib%name%soname = %EVR

%description devel
Intel Open Image Denoise is an open source library of high-performance,
high-quality denoising filters for images rendered with ray tracing.
Intel Open Image Denoise is part of the Intel oneAPI Rendering Toolkit
and is released under the permissive Apache 2.0 license.

This package contains development files for Intel Open Image Denoise.

%package hip
Summary: Intel Open Image Denoise library with HIP support
Group: System/Libraries
Requires: lib%{name}%{soname} = %EVR

%description hip
Intel Open Image Denoise library with HIP support

%package cuda
Summary: Intel Open Image Denoise library with CUDA support
Group: System/Libraries
Requires: lib%{name}%{soname} = %EVR, libcudart

%description cuda
Intel Open Image Denoise library with CUDA support

%package sycl
Summary: Intel Open Image Denoise library with oneAPI/SYCL support
Group: System/Libraries
Requires: lib%{name}%{soname} = %EVR

%description sycl
Intel Open Image Denoise library with oneAPI/SYCL support

%prep
%setup -n %oname-%version
%ifarch aarch64
# see https://github.com/OE4T/meta-tegra/pull/1445
%patch -p2
mkdir -p /tmp/bits
cat >/tmp/bits/math-vector.h <<EOF
#include <bits/libm-simd-decl-stubs.h>
#undef __ADVSIMD_VEC_MATH_SUPPORTED
#undef __SVE_VEC_MATH_SUPPORTED
EOF
%endif
%patch1 -p1
%patch2 -p2
#%%patch3 -p2
%patch4 -p2

%build
%if_with hip
export ROCM_PATH=/usr
export ALTWRAP_LLVM_VERSION=rocm
%endif
%cmake \
	-DOIDN_STATIC_LIB:BOOL=OFF \
	%if_with hip
	-DLLD_DIR=%_prefix/lib/llvm-rocm/%_lib/cmake/lld \
	-DOIDN_DEVICE_HIP:BOOL=ON \
	%endif
	%if_with cuda
	-DOIDN_DEVICE_CUDA:BOOL=ON \
	-DOIDN_DEVICE_CUDA_API=RuntimeShared \
	%endif
	%if_with oneapi
	-DOIDN_DEVICE_SYCL:BOOL=ON \
	-DCMAKE_C_COMPILER=%prefix/lib/llvm-dpcpp/bin/clang \
	-DCMAKE_CXX_COMPILER=%prefix/lib/llvm-dpcpp/bin/clang++ \
	%endif
	-DCMAKE_BUILD_TYPE=%build_type \
	-DCMAKE_STRIP:STRING=""
	%nil
%cmake_build

%install
%cmake_install

# Remove duplicated documentation
rm -rf %buildroot%_defaultdocdir/OpenImageDenoise
%if_with hip
chrpath -d %buildroot%_libdir/libOpenImageDenoise_device_hip.so.%{version}
%endif
%if_with cuda
chrpath -d %buildroot%_libdir/libOpenImageDenoise_device_cuda.so.%{version}
%endif

%files
%_bindir/%{oname}*

%files -n lib%name%soname
%doc LICENSE.txt
%doc CHANGELOG.md README.md readme.pdf
%_libdir/lib*.so.%{soname}
%_libdir/lib*.so.%{soname}.*
%if_with hip
%exclude %_libdir/libOpenImageDenoise_device_hip.so.%{version}
%endif
%if_with cuda
%exclude %_libdir/libOpenImageDenoise_device_cuda.so.%{version}
%endif
%if_with oneapi
%exclude %_libdir/libOpenImageDenoise_device_sycl.so.%{version}
%endif

%if_with hip
%files hip
%_libdir/libOpenImageDenoise_device_hip.so.%{version}
%endif

%if_with cuda
%files cuda
%_libdir/libOpenImageDenoise_device_cuda.so.%{version}
%endif

%if_with oneapi
%files sycl
%_libdir/libOpenImageDenoise_device_sycl.so.%{version}
%endif

%files devel
%_includedir/*
%_libdir/lib*.so
%_libdir/cmake/*

%changelog
