%define _unpackaged_files_terminate_build 1
%define _libexecdir %_prefix/libexec
%def_with libproxy
%def_with stoken
# openssl or gnutls
%def_without openssl
%def_with gnutls
%ifarch loongarch64
%def_without gnutls_tss2
%else
%def_with gnutls_tss2
%endif
%def_disable check

Name: openconnect
Version: 9.12
Release: alt3
Summary: Open client for Cisco AnyConnect VPN

Group: Networking/Remote access
License: LGPLv2.1+
Url: https://www.infradead.org/openconnect.html
Vcs: git://git.infradead.org/users/dwmw2/openconnect.git
Source: %name-%version.tar

Requires: lib%name = %version-%release
BuildRequires: rpm-build-python3
BuildRequires: pkgconfig(liblz4)
BuildRequires: pkgconfig(libxml-2.0)
BuildRequires: pkgconfig(zlib)
%{?_with_gnutls:BuildRequires: pkgconfig(gnutls) > 3.2.10 pkgconfig(p11-kit-1) libtrousers-devel pkgconfig(libtasn1)}
%{?_with_gnutls_tss2:BuildRequires: pkgconfig(tss2-esys) pkgconfig(tss2-mu) pkgconfig(tss2-tctildr) libgcrypt-devel swtpm swtpm-tools}
%{?_with_openssl:BuildRequires: pkgconfig(openssl) pkgconfig(p11-kit-1) pkgconfig(libp11) >= 0.4.7}
%{?_with_libproxy:BuildRequires: pkgconfig(libproxy-1.0)}
%{?_with_stoken:BuildRequires: pkgconfig(stoken)}
BuildRequires: pkgconfig(libpcsclite)
BuildRequires: pkgconfig(libpskc) >= 2.2.0
BuildRequires: pkgconfig(json-parser)
BuildRequires: vpnc-script
BuildRequires: libkrb5-devel
BuildRequires: libgpm-devel
BuildRequires: python3 groff-extra
%if_enabled check
BuildRequires: ocserv uid_wrapper socket_wrapper
%{?_with_gnutls_tss2:BuildRequires: tpm2-tools}
%endif
# root tests
# BuildRequires: ppp socat
# root netns tests
# BuildRequires: nuttcp
BuildRequires: /proc

Requires: vpnc-script
%{?_with_openssl:Requires: openssl >= 1.0.1e}

%description
This package provides a client for Cisco's "AnyConnect" VPN, which uses
HTTPS and DTLS protocols.

%package -n lib%name
Group: System/Libraries
Summary: Shared libraries for %name

%description -n lib%name
%summary

%package -n lib%name-devel
Summary: Development files for %name
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%prep
%setup -q

%build
%autoreconf
%configure \
	--enable-static=no \
	%{subst_with libproxy} \
	%{subst_with stoken} \
	%{subst_with liboath} \
%if_with gnutls
    --with-gnutls \
    --without-gnutls-version-check \
    --without-openssl \
%endif
%if_with openssl
    --with-openssl \
    --without-openssl-version-check \
    --without-gnutls \
%endif
	--disable-dsa-tests \
	--with-system-cafile=/usr/share/ca-certificates/ca-bundle.crt

%make version.c
%make_build

%check
%make check VERBOSE=1

%install
%makeinstall_std
rm -f %buildroot%_libexecdir/openconnect/tncc-wrapper.py
rm -f %buildroot%_libexecdir/openconnect/hipreport-android.sh
%find_lang %name

%files -f %name.lang
%doc TODO COPYING.LGPL
%_sbindir/%name
%_libexecdir/%name
%_datadir/bash-completion/completions/%name
%_man8dir/*

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*

%changelog
