%define ver_major 3.1
%define ver_base %ver_major.0

Name: openbabel
Version: %ver_major.1
Release: alt4.5

%define tag_ver %(echo %version|tr . -)

Summary: Chemistry software file format converter
License: GPL-2.0
Group: Sciences/Chemistry
Url: http://openbabel.sourceforge.net
Vcs: https://github.com/openbabel/openbabel.git

Packager: Michael Shigorin <mike@altlinux.org>

Source: %name-%version.tar
#Source: https://github.com/openbabel/openbabel/releases/download/openbabel-%tag_ver/openbabel-%version-source.tar.bz2
Source1: %name.watch
Patch: %name-%version-%release.patch

BuildRequires(pre): rpm-macros-cmake
BuildRequires(pre): rpm-build-python3
BuildRequires: cmake eigen3 gcc-c++ rapidjson
BuildRequires: boost-devel boost-filesystem-devel
BuildRequires: libcairo-devel libwxGTK3.2-devel
BuildRequires: zlib-devel libxml2-devel xml-utils
BuildRequires: python3-devel python3-module-setuptools swig

Summary(ru_RU.UTF-8): Конвертор биохимических форматов данных
Summary(uk_UA.UTF-8): Конвертор біохімічних форматів даних

%description
Open Babel is a project designed to pick up where Babel left off,
as a cross-platform program and library designed to interconvert
between many file formats used in molecular modeling and computational
chemistry.

%description -l ru_RU.UTF-8
Open Babel - продолжение проекта Babel как кросплатформенного
инструмента для конвертирования многочисленных форматов данных,
используемых в молекулярном моделировании и вычислительной химии.

%description -l uk_UA.UTF-8
Open Babel - продовження проекту Babel як кросплатформенного
інструменту для конвертування численних форматів даних, що
використовуються у молекулярному моделюванні та обчислювальній хімії.

%package -n lib%name
Summary: Shared libraries for programs which will use Open Babel
Group: System/Libraries

%package -n lib%name-devel
Summary: Development tools for programs which will use the lib%name library
Group: Development/C++
Requires: lib%name = %version-%release

%package -n python3-module-%name
Summary: Python 3 bindings for Open Babel
Group: Development/Python3
Requires: lib%name = %version-%release

%if_enabled static
%package -n lib%name-devel-static
Summary: Static development files for lib%name
Group: Development/C++
Requires: lib%name-devel = %version-%release

%description -n lib%name-devel-static
Static development files for lib%name
%endif

%description -n lib%name
Shared libraries for programs which will use Open Babel

%description -n lib%name-devel
The lib%name-devel package includes the header files and static libraries
necessary for developing programs using the lib%name library.

If you are going to develop programs which will use this library
you should install lib%name-devel.  You'll also need to have the
lib%name package installed.

%description -n python3-module-%name
Python bindings for Open Babel.

%prep
%setup -n %name-%version
%patch -p1
# fix python install path
sed -i 's/dist\(-packages\)/site\1/' scripts/CMakeLists.txt
%ifarch %e2k
# see also mcst#3675; there *is* -fPIC there
sed -i 's/-Wl,--fatal-warnings //' CMakeLists.txt
%endif

%build
%cmake \
    -DWITH_MAEPARSER:BOOL=OFF \
    -DWITH_COORDGEN:BOOL=OFF \
    -DBUILD_GUI:BOOL=ON \
    -DRUN_SWIG=ON \
    -DPYTHON_BINDINGS:BOOL=ON \
    -DPYTHON_EXECUTABLE=%__python3
%nil
%cmake_build

%install
%cmake_install

%files
%doc AUTHORS README* THANKS 
%doc doc/FAQ* doc/README* doc/dioxin.*
%_bindir/*
%_man1dir/*
%_datadir/%name

%files -n lib%name
%_libdir/*.so.*
%dir %_libdir/%name/
%dir %_libdir/%name/%version/
%_libdir/%name/%version/*.so

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc
%_libdir/cmake/openbabel3

%files -n python3-module-%name
%python3_sitelibdir/*

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif

%changelog
