%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict,rpath=relaxed,unresolved=relaxed
%define ver_major 14.3

Name: ogre
Version: %ver_major.4
Release: alt1
Summary: Object-Oriented Graphics Rendering Engine
# CC-BY-SA is for devel docs
License: MIT
Group: System/Libraries
Url: https://www.ogre3d.org/
ExcludeArch: %ix86
VCS: https://github.com/OGRECave/ogre
Source: %name-%version.tar

# https://github.com/ocornut/imgui
Source1: %name-%version-imgui.tar

Patch1: ogre-alt-build.patch

BuildRequires: gcc-c++ cmake
BuildRequires: zziplib-devel libfreetype-devel libgtk+2-devel libois-devel openexr-devel cppunit-devel
BuildRequires: doxygen graphviz texi2html libtbb-devel boost-devel
BuildRequires: libXaw-devel libXrandr-devel libXau-devel libXcomposite-devel libXcursor-devel libXdmcp-devel
BuildRequires: libXinerama-devel libXi-devel libXpm-devel libXv-devel libXxf86misc-devel xorg-xf86miscproto-devel
BuildRequires: libXxf86vm-devel libXext-devel libGLU-devel libfreeimage-devel tinyxml-devel
BuildRequires: libharfbuzz-devel libGLES-devel libpoco-devel
BuildRequires: libGLEW-devel
BuildRequires: libSDL2-devel
BuildRequires: libgtest-devel
BuildRequires: libpugixml-devel
BuildRequires: libfreetype-devel
BuildRequires: zlib-devel

%description
OGRE (Object-Oriented Graphics Rendering Engine) is a scene-oriented,
flexible 3D engine written in C++ designed to make it easier and more
intuitive for developers to produce applications utilising
hardware-accelerated 3D graphics. The class library abstracts all the
details of using the underlying system libraries like Direct3D and
OpenGL and provides an interface based on world objects and other
intuitive classes.

%package -n lib%name%ver_major
Summary: Object-oriented Graphics Rendering Engine (libraries)
Group: System/Libraries

%description -n lib%name%ver_major
Ogre is a complete object-oriented 3D rendering engine. It supports
different rendering subsystems but only the OpenGL system is useful
for Linux.

This package contains the Ogre library and plugins.

%package -n lib%name-devel
Summary: Object-oriented Graphics Rendering Engine (development files)
Group: Development/C
Requires: lib%name%ver_major = %EVR

%description -n lib%name-devel
Ogre is a complete object-oriented 3D rendering engine. It supports
different rendering subsystems but only the OpenGL system is useful
for Linux.

This package contains the headers needed to develop with Ogre.

%package devel-doc
Summary: Ogre development documentation
Group: Development/Documentation
BuildArch: noarch

%description devel-doc
This package contains the Ogre API documentation and the Ogre development
manual. Install this package if you want to develop programs that use Ogre.

%package samples
Summary: Ogre samples executables and media
Group: Development/Other
Requires: %name = %EVR

%description samples
This package contains the compiled (not the source) sample applications coming
with Ogre.  It also contains some media (meshes, textures,...) needed by these
samples.

%prep
%setup
%patch1 -p1

mkdir %_cmake__builddir
pushd %_cmake__builddir &>/dev/null
tar xvf %SOURCE1
popd


%ifarch %e2k
# strip UTF-8 BOM for lcc < 1.24
find -type f -print0 -name '*.cpp' -o -name '*.hpp' -name '*.h' |
	xargs -r0 sed -ri 's,^\xEF\xBB\xBF,,'
%endif

%build
%add_optflags -D_FILE_OFFSET_BITS=64
%ifarch %e2k
# -std=c++03 by default as of lcc 1.23.20
%add_optflags -std=c++11
%endif
%cmake \
	-DCMAKE_SKIP_RPATH:BOOL=OFF \
	-DCMAKE_SKIP_INSTALL_RPATH:BOOL=OFF \
	-DOGRE_LIB_DIRECTORY=%_lib \
	-DOGRE_INSTALL_SAMPLES=ON \
	-DOGRE_BUILD_TESTS=ON \
	-DCMAKE_VERBOSE_MAKEFILE:BOOL=ON \
	-DOpenGL_GL_PREFERENCE=GLVND \
	%nil

%cmake_build

%install
%cmakeinstall_std

%files
%doc AUTHORS LICENSE
%_bindir/Ogre*
%_bindir/Test_Ogre*
%_bindir/VRMLConverter
%dir %_datadir/OGRE-%ver_major
%_datadir/OGRE-%ver_major/GLX_backdrop.png
%config(noreplace) %_datadir/OGRE-%ver_major/plugins.cfg
%config(noreplace) %_datadir/OGRE-%ver_major/resources.cfg
%_datadir/OGRE-%ver_major/Media

%exclude %_datadir/OGRE-%ver_major/samples.cfg

%files -n lib%name%ver_major
%dir %_libdir/OGRE
%_libdir/libOgre*.so.%ver_major
%_libdir/OGRE/*.so*

%files  -n lib%name-devel
%_libdir/libOgre*.so
%_libdir/pkgconfig/*
%_libdir/OGRE/cmake
%_includedir/OGRE

%files devel-doc
%_defaultdocdir/OGRE

%files samples
%config(noreplace) %_datadir/OGRE-%ver_major/samples.cfg
%_bindir/SampleBrowser
%_libdir/OGRE/Samples

%changelog
