%define  snapshot  20250827
%define  addonsdir %python_sitelibdir/odoo/addons

Name:    odoo
Version: 17.0
Release: alt1.%snapshot
Epoch:   1

Summary: Odoo is a suite of web based open source business apps
License: LGPL-3.0
Group:   System/Servers
URL:     http://www.odoo.com/
# Git: https://github.com/odoo/odoo (branch: 14.0)

Source0: %name.tar
Source1: odoo.service
Source2: odoo.init
Source3: README.ALT

Patch1: %name-alt-fix-openerp-import.patch

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: rsync
BuildRequires: unzip 
BuildRequires: python3-devel 
BuildRequires: python3-module-setuptools
 
Provides:  tinyerp-server = %version-%release 
Obsoletes: tinyerp-server < %version-%release 
Provides:  openerp-server = %version-%release 
Obsoletes: openerp-server < %version-%release 
Provides:  openerp-web = %version-%release 
Obsoletes: openerp-web < %version-%release 
Provides:  openerp = %version-%release
Obsoletes: openerp < %version-%release
Provides:  openerp-httpd-fonts-access = %version-%release
Obsoletes: openerp-httpd-fonts-access < %version-%release

%add_python3_req_skip xmlrpclib odoo.addons.hw_drivers.tools RPi.GPIO vcgencmd
%py3_requires feedparser gevent mako mock ofxparse PIL psutil pydot ldap pyparsing serial usb qrcode vobject xlsxwriter xlwt num2words phonenumbers lxml_html_clean
Requires: python3-module-suds
Requires: wkhtmltopdf
Requires: lessjs >= 3.0.0
Requires: sassc

%description
Server package for OpenERP.

OpenERP is a free Enterprise Resource Planning and Customer Relationship
Management software. It is mainly developed to meet changing needs.

The main functional features are: CRM & SRM, analytic and financial
accounting, double-entry stock management, sales and purchases
management, tasks automation, help desk, marketing campaign, ... and
vertical modules for very specific businesses.

Technical features include a distributed server, flexible work-flows, an
object database, dynamic GUIs, custom reports, NET-RPC and XML-RPC
interfaces, ...

For more information, please visit: http://www.openerp.com

This server package contains the core (server) of OpenERP system and all
additions of the official distribution. You may need the GTK client to
connect to this server, or the web-client which serves to HTML browsers.
You can also find more additions (aka. modules) for this ERP system in:
http://www.openerp.com/ or  http://apps.openerp.com/

%prep
%setup -q -n %name
%patch1 -p1
cp %SOURCE3 .
rm -f addons/hw_drivers/iot_handlers/drivers/PrinterDriver_W.py \
      addons/hw_drivers/iot_handlers/interfaces/PrinterInterface_W.py

%build
NO_INSTALL_REQS=1 %python3_build

%install
%python3_install

# Install all addons
/bin/cp -a addons/* %buildroot%python3_sitelibdir/odoo/addons/

# Remove posbox and account_check_printing test
rm -rf %buildroot%python3_sitelibdir/odoo/addons/point_of_sale/tools/posbox \
       %buildroot%python3_sitelibdir/odoo/addons/account_check_printing/tests

# Install config file
mkdir -p %buildroot%_sysconfdir/odoo
cat > %buildroot%_sysconfdir/odoo/odoo.conf <<END.
[options]
admin_passwd = rbz
db_host = False
db_port = False
db_user = odoo
db_password = False
addons_path = %python3_sitelibdir/odoo/addons
# logging. Accepted values of log_level: info, debug_rpc, warn, test, critical, debug_sql, error, debug, debug_rpc_answer, notset
log_level = info
data_dir = /var/lib/odoo
END.

install -D -m 644 %SOURCE1 %buildroot%_unitdir/odoo.service
install -D -m 755 %SOURCE2 %buildroot%_initdir/odoo

install -d %buildroot%_logdir/odoo
install -d %buildroot%_spooldir/odoo
install -d %buildroot%_runtimedir/odoo
install -d %buildroot%_sharedstatedir/odoo

# Disable python2 requirement
subst 's|^#!.*env python2$|#!%__python3|' %buildroot%python3_sitelibdir/odoo/addons/mail/static/scripts/odoo-mailgate.py

%pre
getent group odoo > /dev/null || /usr/sbin/groupadd -r odoo
getent passwd _odoo > /dev/null || \
%_sbindir/useradd -M -r -g odoo -c 'Odoo Server' \
     -d %_sharedstatedir/odoo -s /sbin/nologin _odoo 2> /dev/null ||:

%post
%post_service odoo

%preun
%preun_service odoo

%files
%doc COPYRIGHT LICENSE *.md 
%doc README.ALT
%_bindir/*
%_unitdir/odoo.service
%_initdir/odoo
%python3_sitelibdir/odoo
%python3_sitelibdir/%name-*.egg-info
%_spooldir/odoo
%attr(0755,_odoo,odoo) %_logdir/odoo
%attr(0755,_odoo,odoo) %_runtimedir/odoo
%attr(0755,_odoo,odoo) %_sharedstatedir/odoo
%attr(0755,root,odoo) %dir %_sysconfdir/odoo
%attr(0660,root,odoo) %config(noreplace) %_sysconfdir/odoo/odoo.conf
#%%attr(-,openerp,openerp) %ghost %_logdir/openerp/openerp-server.log

%changelog
