%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict
# TODO: change libode package name according SharedLibsPolicy
%define soname 8

Name: ode
Version: 0.16.6
Release: alt1
Summary: The Open Dynamics Engine (ODE)
License: LGPLv2.1+
Group: Graphics
Url: https://www.ode.org/

VCS: https://bitbucket.org/odedevs/ode.git
Source: %name-%version.tar
# http://www.ode.org/ode-latest-userguide.pdf
Source1: ode-latest-userguide.pdf
# http://www.ode.org/joints.pdf
Source2: joints.pdf

BuildRequires: gcc-c++ libX11-devel libICE-devel libGL-devel libGLU-devel
BuildRequires: libSM-devel libgmp-devel

%description
ODE is an open source, high performance library for simulating rigid
body dynamics. It is fully featured, stable, mature and platform
independent with an easy to use C/C++ API. It has advanced joint types
and integrated collision detection with friction. ODE is useful for
simulating vehicles, objects in virtual reality environments and virtual
creatures. It is currently used in many computer games, 3D authoring
tools and simulation tools.

%package -n lib%name
Summary: Shared libraries of The Open Dynamics Engine (ODE)
Group: System/Libraries

%description -n lib%name
ODE is an open source, high performance library for simulating rigid
body dynamics. It is fully featured, stable, mature and platform
independent with an easy to use C/C++ API. It has advanced joint types
and integrated collision detection with friction. ODE is useful for
simulating vehicles, objects in virtual reality environments and virtual
creatures. It is currently used in many computer games, 3D authoring
tools and simulation tools.

This package contains shared libraries of ODE.

%package -n lib%name-devel
Summary: Development files of The Open Dynamics Engine (ODE)
Group: Development/C++
Requires: lib%name = %EVR

%description -n lib%name-devel
ODE is an open source, high performance library for simulating rigid
body dynamics. It is fully featured, stable, mature and platform
independent with an easy to use C/C++ API. It has advanced joint types
and integrated collision detection with friction. ODE is useful for
simulating vehicles, objects in virtual reality environments and virtual
creatures. It is currently used in many computer games, 3D authoring
tools and simulation tools.

This package contains development files of ODE.

%package -n lib%name-devel-doc
Summary: Documentation for The Open Dynamics Engine (ODE)
Group: Development/Documentation
BuildArch: noarch

%description -n lib%name-devel-doc
ODE is an open source, high performance library for simulating rigid
body dynamics. It is fully featured, stable, mature and platform
independent with an easy to use C/C++ API. It has advanced joint types
and integrated collision detection with friction. ODE is useful for
simulating vehicles, objects in virtual reality environments and virtual
creatures. It is currently used in many computer games, 3D authoring
tools and simulation tools.

This package contains development documentation for ODE.

%package demos
Summary: Demos of The Open Dynamics Engine (ODE)
Group: Graphics
Requires: lib%name = %EVR

%description demos
ODE is an open source, high performance library for simulating rigid
body dynamics. It is fully featured, stable, mature and platform
independent with an easy to use C/C++ API. It has advanced joint types
and integrated collision detection with friction. ODE is useful for
simulating vehicles, objects in virtual reality environments and virtual
creatures. It is currently used in many computer games, 3D authoring
tools and simulation tools.

This package contains demos of ODE.

%prep
%setup
# the code is a trashfire with a whitelist of 64-bit architectures
# there are a dozen ways to detect pointer size portably!
# there is a whitelist that selects a portable way using <stdint.h>
sed -i 's/defined(__aarch64__)/1/' include/ode/odeconfig.h

touch libccd/NEWS libccd/AUTHORS libccd/ChangeLog

%build
%add_optflags -D_FILE_OFFSET_BITS=64

./bootstrap
#autoreconf
%add_optflags -fno-strict-aliasing
%ifarch %e2k
# -std=c++03 by default as of lcc 1.23.12
%add_optflags -std=c++11
%endif
%configure \
	--enable-shared \
	--disable-static \
	--enable-double-precision \
	--disable-asserts \
	--disable-threading-intf \
	--enable-builtin-threading-impl \
	--enable-ou \
	--with-drawstuff=X11 \
	--with-x \
	--enable-libccd \
	--with-cylinder-cylinder=libccd \
	--with-capsule-cylinder=libccd \
	--with-convex-box=libccd \
	--with-convex-capsule=libccd \
	--with-convex-cylinder=libccd \
	%nil

%make_build -C ou/src/ou
%make_build

%install
%makeinstall_std

# demos
install -d %buildroot%_libdir/%name
cp -fR drawstuff %buildroot%_libdir/%name/

pushd %buildroot%_libdir/%name
rm -f $(find ./ -name 'Makefile.*') \
	$(find ./ -name '*.o') \
	$(find ./ -name '*.a') \
	$(find ./ -name '*.lo') \
	$(find ./ -name '*.la')
popd

# docs
install -d %buildroot%_docdir/lib%name-devel
install -p -m644 %SOURCE1 %SOURCE2 \
	%buildroot%_docdir/lib%name-devel

%files -n lib%name
%doc CHANGELOG.txt LICENSE* README.md
%_libdir/*.so.%soname
%_libdir/*.so.%soname.*

%files -n lib%name-devel
%_libdir/*.so
%_includedir/*
%_bindir/*
%_pkgconfigdir/*

%files -n lib%name-devel-doc
%_docdir/lib%name-devel/*

%files demos
%_libdir/%name/

%changelog
