%define _unpackaged_files_terminate_build 1

%ifarch %ix86
# libinterp/corefcn/eig.cc-tst segfaults
%def_disable check
%endif

Name: octave
Version: 10.3.0
Release: alt1

%define docdir %_defaultdocdir/%name-%version

Summary: GNU Octave -- a high-level language for numerical computations
License: GPLv3
Group: Sciences/Mathematics

URL: http://www.octave.org/
Packager: Andrey Cherepanov <cas@altlinux.org>

Source0: %name-%version-%release.tar
Source1: octave.filetrigger
Source2: %name.watch

Patch0: octave-alt-desktop-l10n.patch

BuildRequires: flex gcc-c++ gcc-fortran libcurl-devel libfftw3-devel libglpk-devel
BuildRequires: libhdf5-devel liblapack-devel libncurses-devel libpcre-devel
BuildRequires: libreadline-devel libstdc++-devel libtinfo-devel libX11-devel libXext-devel
BuildRequires: libSM-devel libICE-devel liblcms2-devel bzlib-devel libltdl-devel
BuildRequires: libGraphicsMagick-c++-devel libGL-devel libGLU-devel libfreetype-devel
BuildRequires: libftgl-devel zlib-devel desktop-file-utils gnuplot less
BuildRequires: texlive-base-bin texlive-generic-recommended
BuildRequires: libarpack-ng-devel libXcursor-devel
BuildRequires: qt5-base-devel
BuildRequires: qt5-tools
BuildRequires: qt5-tools-devel
BuildRequires: libqscintilla2-qt5-devel
BuildRequires: fontconfig-devel
BuildRequires: gperf
BuildRequires: icoutils librsvg-utils
BuildRequires: java-devel-default
BuildRequires: libX11-devel
BuildRequires: libXfixes-devel
BuildRequires: libXft-devel
BuildRequires: libXinerama-devel
BuildRequires: libcairo-devel
BuildRequires: libfltk-devel
BuildRequires: libgl2ps-devel
BuildRequires: libncurses-devel
BuildRequires: libpcre-devel
BuildRequires: libpixman-devel
BuildRequires: libqhull-devel
BuildRequires: libqrupdate-devel
BuildRequires: libsuitesparse-devel
BuildRequires: libsuitesparse-devel
BuildRequires: libtinfo-devel
BuildRequires: llvm-devel
BuildRequires: pkgconfig(fontconfig)
BuildRequires: pkgconfig(freetype2)
BuildRequires: pkgconfig(portaudio-2.0)
BuildRequires: pkgconfig(sndfile)
BuildRequires: pkgconfig(xft)
BuildRequires: texinfo

Provides:  qtoctave = %EVR
Obsoletes: qtoctave < %EVR
Requires: gnuplot
Requires: makeinfo

%package devel
Summary: GNU Octave -- development part
Group: Development/C
Requires: %name = %version-%release

%package doc
Summary: GNU Octave -- documentation
Group: Development/Other
BuildArch: noarch

Summary(ru_RU.UTF-8): GNU Octave -- высокоуровневый язык для численных методов

%description
GNU Octave is a high-level language, primarily intended for numerical
computations. It provides a convenient command line interface for
solving linear and nonlinear problems numerically, and for performing
other numerical experiments using a language that is mostly compatible
with Matlab. It may also be used as a batch-oriented language.

Octave has extensive tools for solving common numerical linear algebra
problems, finding the roots of nonlinear equations, integrating
ordinary functions, manipulating polynomials, and integrating ordinary
differential and differential-algebraic equations. It is easily
extensible and customizable via user-defined functions written in
Octave's own language, or using dynamically loaded modules written in
C++, C, Fortran, or other languages.

%description devel
GNU Octave is a high-level language, primarily intended for numerical
computations. It provides a convenient command line interface for
solving linear and nonlinear problems numerically, and for performing
other numerical experiments using a language that is mostly compatible
with Matlab. It may also be used as a batch-oriented language.

This package contains development libraries and header files.

%description doc
GNU Octave is a high-level language, primarily intended for numerical
computations. It provides a convenient command line interface for
solving linear and nonlinear problems numerically, and for performing
other numerical experiments using a language that is mostly compatible
with Matlab. It may also be used as a batch-oriented language.

This package contains extra documentation for GNU Octave.

%description -l ru_RU.UTF-8
GNU Octave является высокоуровневым языком, в первую очередь предназначенным
для численных методов. Он предоставляет удобный командно-строчный интерфейс
для решения линейных и нелинейных задач в численном виде, а также для иных
численных экспериментов с применением языка, в основном совместимого с Matlab.
Также может применяться для неинтерактивных расчётов.

Octave имеет широкий набор средств для решения общих численных задач
линейной алгебры, нахождения корней нелинейных уравнений, интегрирования
ординарных функций, манипулирования полиномами, а также интегрирования
ординарных дифференциальных и дифференциально-алгебраических уравнений.
Легко расширяется и подстраивается при помощи определяемых пользователем
функций, написанных на собственном языке Octave, или с применением
динамически загружаемых модулей, написанных на C++, C, Fortran или
иных языках.

%description -l ru_RU.UTF-8 devel
GNU Octave является высокоуровневым языком, в первую очередь предназначенным
для численных методов. Он предоставляет удобный командно-строчный интерфейс
для решения линейных и нелинейных задач в численном виде, а также для иных
численных экспериментов с применением языка, в основном совместимого с Matlab.
Также может применяться для неинтерактивных расчётов.

Этот пакет содержит библиотеки и заголовки для разработки.

%description -l ru_RU.UTF-8 doc
GNU Octave является высокоуровневым языком, в первую очередь предназначенным
для численных методов. Он предоставляет удобный командно-строчный интерфейс
для решения линейных и нелинейных задач в численном виде, а также для иных
численных экспериментов с применением языка, в основном совместимого с Matlab.
Также может применяться для неинтерактивных расчётов.

Этот пакет содержит дополнительную документацию для GNU Octave.

%define _libexecdir %_libdir

%prep
%setup
%patch0 -p2

%build
%add_optflags $(pkg-config hdf5-seq --cflags) $(pcre-config --cflags)
%add_optflags $(pkg-config fontconfig --cflags) -fpermissive -lm
%undefine _configure_gettext
%autoreconf
#patch -p2 < %PATCH3
%configure \
	--with-blas=openblas \
	--enable-dl \
	--enable-shared \
	--disable-static
##smp-unaware
#export NPROCS=7
%make_build

%install
%makeinstall_std

mkdir -p %buildroot%_datadir/octave/packages
mkdir -p %buildroot%_libdir/octave/packages

gzip -c ChangeLog >ChangeLog.gz

# Install the filetrigger for packages:
install -pm0755 -D %SOURCE1 %buildroot%_rpmlibdir/%name.filetrigger

# required to suppress verify-elf warnings
mkdir -p %buildroot%_rpmmacrosdir
_octave_libs=
for lib in `ls %buildroot%_libdir/%name/%version/lib*.so.?`; do
    lib=${lib##%buildroot}
    _octave_libs="$_octave_libs $lib"
done
cat > %buildroot%_rpmmacrosdir/%{name}.env <<EOF
export RPM_LD_PRELOAD_octave='$_octave_libs'
export RPM_FILES_TO_LD_PRELOAD_octave='%_libdir/%name/packages/*'
EOF

mkdir -p %buildroot%_datadir/doc/%name-doc-%version

%check
%make check

%files
%doc BUGS NEWS* README ChangeLog.gz
%_bindir/%{name}*
%_datadir/%name
%_libdir/%name/%version/*.so*
%_libdir/%name/%version/exec
%_libdir/%name/%version/oct
%exclude %_libdir/%name/%version/*.la*
%dir %_libdir/%name
%dir %_libdir/%name/%version
%dir %_libdir/%name/packages
%_infodir/octave.info*
%_infodir/liboctave.info*
%_man1dir/*
%_desktopdir/*.desktop
%_datadir/metainfo/*.metainfo.xml
%_datadir/icons/hicolor/*/apps/octave.png
%_datadir/icons/hicolor/*/apps/octave.svg
%_rpmlibdir/%name.filetrigger

%files devel
%_includedir/%name-%version
%_bindir/mkoctfile
%_bindir/mkoctfile-%version
%_rpmmacrosdir/%{name}.env
%_pkgconfigdir/*.pc

%files doc
%doc doc/interpreter/octave.html doc/liboctave/liboctave.html
%doc doc/interpreter/octave.pdf doc/liboctave/liboctave.pdf
%doc doc/refcard/refcard*.pdf

%changelog
