%define _unpackaged_files_terminate_build 1
%def_with check

Name: objectweb-asm
Version: 9.9
Release: alt1

Summary: Java bytecode manipulation and analysis framework
License: BSD
Group: Development/Java
Url: https://asm.ow2.org
Vcs: https://gitlab.ow2.org/asm/asm.git
BuildArch: noarch

Source0: %name-%version.tar
Patch0: 0001-Remove-all-external-gradle-plugins-alt-patch.patch
Patch1: 0002-Janino-3.1.7-compatibility-for-tests-alt-patch.patch
%if_with check
# Fix warnings "unknown enum constant Status.STABLE".
Patch2: 0003-Add-an-explicit-dependency-on-apiguardian-alt-patch.patch
%endif

BuildRequires(pre): rpm-macros-gradle
BuildRequires: rpm-build-java-osgi
BuildRequires: /proc
BuildRequires: rpm-build-java
BuildRequires: jpackage-default
BuildRequires: xgradle
%if_with check
BuildRequires: junit5
BuildRequires: janino
BuildRequires: apiguardian
%endif

%description
ASM is an all purpose Java bytecode manipulation and analysis
framework.  It can be used to modify existing classes or dynamically
generate classes, directly in binary form.  Provided common
transformations and analysis algorithms allow to easily assemble
custom complex transformations and code analysis tools.

%package javadoc
Group: Development/Java
Summary: API documentation for %name
BuildArch: noarch

%description javadoc
This package provides %summary.

%prep
%setup
%autopatch -p1

%build
%gradle_publish -Prelease

%install
%gradle_register_bom --remove-parent=all
%gradle_register --exclude-artifacts=asm-test --remove-parent=all
%gradle_register_javadoc --exclude-artifacts=asm-test

%gradle_install

%check
# We must explicitly specify the encoding when building in hasher
# if it is not explicitly specified by upstream in the build file.
%gradle_check -Dfile.encoding=UTF-8

%files -f .mfiles
%doc --no-dereference LICENSE.txt

%files javadoc -f .mfiles-javadoc
%doc --no-dereference LICENSE.txt

%changelog
