Summary:	Netscape Network Security Services(NSS)
Name:		nss
Version:	3.117
Release:	alt1
License:	MPL-2.0
Group:		System/Libraries
Url:		http://www.mozilla.org/projects/security/pki/nss

Source0:	nss-%version.tar
Source1:	nss.pc.in
Source2:	nss-config.in
Source4:	nss-db-%version.tar
Source5:	setup-nsssysinit.sh
Source6:	system-pkcs11.txt

### Start Patches
Patch001: 0001-Disable-test-dbtest-r-w-in-a-readonly-directory.patch
Patch002: 0002-ALT-Disable-flaky-tests.patch
Patch003: 0003-Disable-ssl_policy_pkix_ocsp-test.patch
### End Patches

BuildRequires:  gcc-c++
BuildRequires:  chrpath zlib-devel libsqlite3-devel
BuildRequires:  rpm-macros-alternatives
BuildRequires:  python3
BuildRequires:  gyp
BuildRequires:  ninja-build
BuildRequires:  libnspr-devel

%define _unpackaged_files_terminate_build 1
%define _libexecdir %_prefix/libexec
%global unsupported_bindir %_libexecdir/nss

# disable LTO to avoid ssl_gtest failure
# see https://bugzilla.mozilla.org/show_bug.cgi?id=1890188
%define optflags_lto %nil

%description
Network Security Services (NSS) is a set of libraries designed
to support cross-platform development of security-enabled server
applications. Applications built with NSS can support SSL v2
and v3, TLS, PKCS #5, PKCS #7, PKCS #11, PKCS #12, S/MIME,
X.509 v3 certificates, and other security standards.  See:
http://www.mozilla.org/projects/security/pki/nss/overview.html

%package -n lib%name
Summary:	Netscape Network Security Services(NSS)
Group:		System/Libraries

Provides:	%name = %version-%release

Provides:	%name-sysinit
Provides:	%name-system-init

Provides:	lib%name-sysinit = %version-%release
Obsoletes:	lib%name-sysinit

%description -n lib%name
Network Security Services (NSS) is a set of libraries designed
to support cross-platform development of security-enabled server
applications. Applications built with NSS can support SSL v2
and v3, TLS, PKCS #5, PKCS #7, PKCS #11, PKCS #12, S/MIME,
X.509 v3 certificates, and other security standards.  See:
http://www.mozilla.org/projects/security/pki/nss/overview.html

%package -n lib%name-devel
Summary:	NSS development kit
Group:		Development/C
Requires:	lib%name = %version-%release

Provides:	%name-devel        = %version-%release
Provides:	%name-pkcs11-devel = %version-%release

%description -n lib%name-devel
NSS development kit

%package -n lib%name-devel-static
Summary:	NSS static libraries
Group:		Development/C
Requires:	lib%name-devel = %version-%release

Provides:	%name-devel-static        = %version-%release
Provides:	%name-pkcs11-devel-static = %version-%release

%description -n lib%name-devel-static
NSS development kit (static libs)

%package -n lib%name-nssckbi-checkinstall
Summary: Check p11-kit-trust.so and libnssckbi.so compatibility
Group: Security/Networking
Requires: p11-kit-checkinstall

%description -n lib%name-nssckbi-checkinstall
During installation check that p11-kit-trust.so and libnssckbi.so are
compatible with each other.
This package intedent to be used in the install check step in the build
system only and should not be installed in the real systems.

%package -n %name-utils
Summary:	Netscape Network Security Services Utilities
Group:		Development/Other
Requires:	lib%name = %version-%release

Provides:	%name-tools

%description -n %name-utils
Netscape Network Security Services Utilities

%prep
%setup -q
cd nss
%autopatch -p1
%ifarch %e2k
sed -i 's/-Werror/-Wno-error/g' coreconf/{Werror.mk,werror.py}
%endif

%build
mkdir -p bin
export PATH="$PWD/bin:$PATH"

ln -s %_bindir/python3 bin/python

%{?_is_lp64:export USE_64=1}

cd nss
CFLAGS="%optflags" \
CXXFLAGS="%optflags" \
./build.sh \
	--gcc \
	--opt \
	--system-nspr \
	--system-sqlite \
	--enable-legacy-db \
	--enable-libpkix \
	#

%install
# Get some variables
DESTDIR="$PWD/dist/Release"
NSPR_VERSION="$(nspr-config --version)"
nss_h="nss/lib/nss/nss.h"
NSS_VMAJOR="$(sed -ne 's,^#define[[:space:]]\+NSS_VMAJOR[[:space:]]\+,,p' "$nss_h")"
NSS_VMINOR="$(sed -ne 's,^#define[[:space:]]\+NSS_VMINOR[[:space:]]\+,,p' "$nss_h")"
NSS_VPATCH="$(sed -ne 's,^#define[[:space:]]\+NSS_VPATCH[[:space:]]\+,,p' "$nss_h")"

# Install NSS libraries
cd dist

# fedora utilities
mkdir -p -- %buildroot%_bindir
for n in \
	certutil cmsutil crlutil modutil nss-policy-check pk12util signver \
	ssltap \
	;
do
	cp -L -- "$DESTDIR/bin/$n" %buildroot%_bindir/
done

# fedora unsupported utilites
mkdir -p -- %buildroot%unsupported_bindir
for n in \
	bltest ecperf fbectest shlibsign atob btoa derdump listsuites \
	ocspclnt pp selfserv signtool strsclnt symkeyutil tstclnt vfyserv \
	vfychain \
	;
do
	cp -L -- "$DESTDIR/bin/$n" %buildroot%unsupported_bindir/
done

mkdir -p -- %buildroot%_libdir
cp -aL "$DESTDIR"/lib/* %buildroot%_libdir
rm -f -- %buildroot%_libdir/*.TOC

# Install NSS headers
# Link: https://bugzilla.mozilla.org/show_bug.cgi?id=1992417#c8
# mkdir -pv %buildroot%_includedir
# cp -aL public/nss %buildroot%_includedir
install -Dt %buildroot%_includedir/nss/ -m644 public/nss/*.h

# Copy some freebl include files we also want
mkdir -p -- %buildroot/%_includedir/%name/private

for n in blapi.h alghmac.h cmac.h; do
    cp -aL private/nss/$n %buildroot/%_includedir/%name/private/$n
done

# Install NSS utils
mkdir -p -- %buildroot%_libdir/pkgconfig

sed -e "s,@libdir@,%_libdir,g" \
    -e "s,@prefix@,%_prefix,g" \
    -e "s,@exec_prefix@,%_prefix,g" \
    -e "s,@includedir@,%_includedir/nss,g" \
    -e "s,@NSPR_VERSION@,$NSPR_VERSION,g" \
    -e "s,@NSS_VERSION@,%version,g" \
    %SOURCE1 > %buildroot/%_libdir/pkgconfig/nss.pc

sed -e "s,@libdir@,%_libdir,g" \
    -e "s,@prefix@,%_prefix,g" \
    -e "s,@exec_prefix@,%_prefix,g" \
    -e "s,@includedir@,%_includedir/nss,g" \
    -e "s,@MOD_MAJOR_VERSION@,$NSS_VMAJOR,g" \
    -e "s,@MOD_MINOR_VERSION@,$NSS_VMINOR,g" \
    -e "s,@MOD_PATCH_VERSION@,$NSS_VPATCH,g" \
    %SOURCE2 > %buildroot/%_bindir/nss-config

chmod 755 %buildroot/%_bindir/nss-config

# Add real RPATH
find "%buildroot%_bindir" "%buildroot%_libdir" -type f |
while read f; do
  file "$f" | grep -qs ELF || continue
  if chrpath -l "$f" | fgrep -qs "RPATH="; then
    chrpath -d "$f"
  fi
done

# https://wiki.mozilla.org/NSS_Shared_DB
# https://wiki.mozilla.org/NSS_Shared_DB_Samples
# https://wiki.mozilla.org/NSS_Shared_DB_Howto
# https://wiki.mozilla.org/NSS_Shared_DB_And_LINUX
mkdir -p -- %buildroot/%_sysconfdir/pki/nssdb
tar -x -C %buildroot/%_sysconfdir/pki/nssdb -f %SOURCE4
find %buildroot/%_sysconfdir/pki/nssdb -name 'blank-*.db' -printf '%%h %%f\n' |
while read p n; do
	mv -f -- "$p/$n" "$p/${n##blank-}"
done

install -p -m755 %SOURCE5 %buildroot/%_bindir/setup-nsssysinit.sh
install -p -m644 %SOURCE6 %buildroot/%_sysconfdir/pki/nssdb/pkcs11.txt

# alternatives
mkdir -p -- %buildroot/%_libdir/nss
mv -- %buildroot/%_libdir/libnssckbi.so %buildroot/%_libdir/nss/libnssckbi.so

mkdir -p -- %buildroot/%_altdir
cat >%buildroot/%_altdir/libnssckbi-%name <<EOF
%_libdir/libnssckbi.so	%_libdir/nss/libnssckbi.so	10
EOF

%check
pushd nss/tests
./all.sh
popd

%files -n %name-utils
%_bindir/*
%unsupported_bindir
%exclude %_bindir/setup-nsssysinit.sh
%exclude %_bindir/%name-config

%files -n lib%name
%_altdir/libnssckbi-%name
%_libdir/*.so*
%_libdir/*.chk
%_libdir/nss
%dir %_sysconfdir/pki/nssdb
%config(noreplace) %_sysconfdir/pki/nssdb/cert8.db
%config(noreplace) %_sysconfdir/pki/nssdb/key3.db
%config(noreplace) %_sysconfdir/pki/nssdb/secmod.db
%config(noreplace) %_sysconfdir/pki/nssdb/cert9.db
%config(noreplace) %_sysconfdir/pki/nssdb/key4.db
%config(noreplace) %_sysconfdir/pki/nssdb/pkcs11.txt
%_bindir/setup-nsssysinit.sh

%files -n lib%name-devel
%_bindir/%name-config
%dir %_includedir/%name
%_includedir/%name
%_libdir/pkgconfig/*

%files -n lib%name-devel-static
%_libdir/*.a

%files -n lib%name-nssckbi-checkinstall

%changelog
