Name: nspec
Version: 16.5888
Release: alt5
Summary: Nspec Universal SPM & Spectroscopy Software - Nano Scan Technologies Ltd.
Summary(ru_RU.UTF-8): Nspec - универсальная программа для СЗМ и спектроскопии для приборов фирмы НСТ
License: BSD 4-clause, 2008-2020, Nano Scan Technologies Ltd.
Group: Sciences/Other
URL: http://www.nanoscantech.ru/en/
Packager: Alexei Mezin <alexvm@altlinux.org>
Vendor: ALT Linux Team

Source: %name-%version.tar.gz

BuildRequires(pre): rpm-macros-qt5


# Automatically added by buildreq on Fri Dec 15 2017
# optimized out: fontconfig fontconfig-devel gcc-c++ glib2-devel glibc-kernheaders-generic glibc-kernheaders-x86 libGL-devel libGLU-devel libICE-devel libSM-devel libX11-devel libXmu-devel libXt-devel libatk-devel libcairo-devel libfreetype-devel libgdk-pixbuf libgdk-pixbuf-devel libgio-devel libgtk+2-devel libgtkglext-devel libpango-devel libpangox-compat libpangox-compat-devel libqt5-concurrent libqt5-core libqt5-gui libqt5-network libqt5-opengl libqt5-script libqt5-widgets libstdc++-devel libusb-compat pkg-config python-base python-modules python3 python3-base python3-module-yieldfrom qt5-base-devel zlib-devel
## QT5 deps
##BuildRequires: bzlib-devel kf5-kimageformats libgwyddion-devel libqt5-svg libusb-compat-devel libusb-devel qt5-declarative-devel qt5-imageformats qt5-script-devel ruby ruby-stdlibs
BuildRequires: kf5-kimageformats libgwyddion-devel libqt5-svg libusb-devel libusb-compat-devel qt5-connectivity-devel
BuildRequires: qt5-imageformats qt5-location-devel qt5-multimedia-devel qt5-phonon-devel qt5-quickcontrols2-devel qt5-script-devel qt5-sensors-devel qt5-serialbus-devel qt5-x11extras-devel


## QT4 deps
##BuildRequires: gcc-c++ glibc-devel-static libgwyddion-devel libqt4-webkit-devel libusb-compat-devel libusb-devel phonon-devel ruby ruby-stdlibs


%description
Nspec is a control program for Scanning Probe Microscopes and Spectroscopy Systems
by Nano Scan Technologies Ltd.

%description -l ru_RU.UTF-8
Nspec это программа управления Сканирующими Зондовыми Микроскопами и Спектроскопическими системами
фирмы Нано Скан Технология.

%package  gwyddion-plugin
Summary: Plugin for easy data transfer from NSpec to Gwyddion
Requires: gwyddion
Group: Sciences/Other

%description gwyddion-plugin
This plugin enables transfer of the current data frame from Nspec to Gwyddion in one click.

%description -l ru_RU.UTF-8  gwyddion-plugin
Этот плагин позволяет передавать данные из Nspec в Gwyddion в одно нажатие кнопки.


%package plugin-lithography
Summary: Probe lithography support
Requires: nspec
Group: Sciences/Other

%description plugin-lithography
This plugin adds probe lithography support to Nspec software.

%description -l ru_RU,UTF-8 plugin-lithography
Плагин добавляет поддержку зондовой литографии в программу Nspec.


%prep
%setup

# Fix C++ code to comply with standards and build on e2k
sed -i "/Motors::axes_names/i const int Motors::numMaxMotors;\nconst int Motors::axes_names_count;" src/motors_gui.cpp

%ifarch %e2k
# strip UTF-8 BOM for lcc < 1.24
find -type f -name '*.cpp' -o -name '*.hpp' |
    xargs -r sed -ri 's,^\xEF\xBB\xBF,,'
%endif

%build
echo -e "%version-%release\n" >> src/data/nst_build.txt
# Build without third party hardware support (spectrometers, CCD cameras, photon counters etc.) and obsolete FTDI chip
%qmake_qt5 "CONFIG += no_external_deps no_ftdi" nst.pro
# non-SMP make
%make
# SMP build
# %make_build

cd gwy_proxy/gcc_make
make -f Makefile.linux

%install
install -D -m0644 lib/linux/nst-udev.rules %buildroot/%_udevrulesdir/99-nst.rules
install -D -m0644 lib/linux/99-shuttle_ignore_xorg.conf %buildroot/%_sysconfdir/X11/xorg.conf.d/99-shuttle_ignore_xorg.conf
install -m 755 -d %buildroot/%_bindir/
install -m 755 -d %buildroot/%_libdir/nspec
install -m 755 -d %buildroot/%_liconsdir/
install -m 755 -d %buildroot/%_iconsdir/hicolor/scalable/apps
install -m 755 -d %buildroot/%_desktopdir/
install -m 755 -d %buildroot/%_datadir/mime/packages/
install -m 644 lib/linux/ALT_RPM/nspec_48x48.png %buildroot/%_liconsdir/%name.png
install -m 644 lib/linux/ALT_RPM/%name.svg %buildroot/%_iconsdir/hicolor/scalable/apps
install -m 644 lib/linux/%name.desktop %buildroot/%_desktopdir/
install -m 644 lib/linux/ALT_RPM/%name.xml %buildroot/%_datadir/mime/packages/

## install main binary
cp bin/nspec %buildroot/%_bindir

## install litho plugin
cp bin/liblitho* %buildroot/%_libdir/nspec

# gwy proxy install
install -m 755 -d %buildroot/%_libdir/gwyddion/modules/
cp gwy_proxy/gcc_make/nst_proxy.so %buildroot/%_libdir/gwyddion/modules



%files
%_bindir/%name
%_desktopdir/%name.desktop
%_udevrulesdir/*
%_sysconfdir/X11/xorg.conf.d/99-shuttle_ignore_xorg.conf
%_liconsdir/%name.*
%_iconsdir/hicolor/scalable/apps/%name.*
%_datadir/mime/packages/%name.xml

%files gwyddion-plugin
%_libdir/gwyddion/modules/*.so

%files plugin-lithography
%_libdir/nspec/*

%changelog
