Name: node-gyp
Version: 11.0.0
Release: alt1

Summary: Node.js native addon build tool
License: MIT
Group: Development/Tools

Url: https://github.com/TooTallNate/node-gyp

Packager: Vitaly Lipatov <lav@altlinux.ru>

#Source-url: http://registry.npmjs.org/node-gyp/-/node-gyp-%version.tgz
# Source-url: https://github.com/nodejs/node-gyp/archive/v%version.tar.gz
Source: %name-%version.tar

# Note: see .gear/predownloaded-production created with rpmgs -f from etersoft-build-utils
Source2: %name-production-%version.tar

Source10: addon-rpm.gypi

BuildArch: noarch

# we do not need any module provides here
AutoProv: yes,nonodejs,noruby,notex
AutoReq: yes,nonodejs,noruby,notex

Provides: npm(node-gyp) = %version

# use RPM installed headers by default instead of downloading a source tree
# for the currently running node version
Patch1: node-gyp-addon-gypi.patch

# use the system gyp
Patch2: node-gyp-system-gyp.patch

# use system node dir (/usr)
Patch3: node-gyp-system-nodedir.patch

Patch4: node-gyp-install-stop.patch

BuildRequires(pre): rpm-macros-nodejs

#gyp is the actual build framework node-gyp uses
Requires: gyp >= 0.16.1

#this is the standard set of headers expected to build any node native module
#Requires: rpm-build-nodejs
#Requires:      npm
Requires:      node-devel >= 16.14.0
# still used in node-gyp
Requires:      rpm-build-python3

#we also need a C++ compiler to actually build stuff ;-)
# TODO: what about toolchain?
# See https://bugzilla.altlinux.org/show_bug.cgi?id=37687
#Requires: gcc-c++
Requires: make

%description
node-gyp is a cross-platform command-line tool written in Node.js for compiling
native addon modules for Node.js, which takes away the pain of dealing with the
various differences in build platforms.

You need also Install gcc-c++ package for compiling native addon modules for Node.js.

%prep
%setup -a 2
#patch1 -p1
%patch2 -p2
%patch3 -p2
%patch4 -p2

# use system gyp
%__subst "s|\(var gyp_script =\).*|\1 '/usr/bin/gyp'|g" lib/configure.js

# fix -fPIC using on ix86
%__subst 's| and target_arch!="ia32"||' addon.gypi

#nodejs_fixdep request 2.x
#nodejs_fixdep npmlog 3
#nodejs_fixdep nopt 3
#nodejs_fixdep semver 2.1
#patch33 -p0

# drop internal gyp
rm -rf gyp/
mkdir gyp/
# compat hack
ln -s %_bindir/gyp gyp/gyp_main.py

%build
#nothing to do

%install
# replace node_modules with got after npm install --production
#rm -rf node_modules
#tar xf %SOURCE2

mkdir -p %buildroot%nodejs_sitelib/node-gyp/
cp -pr addon*.gypi bin lib gyp node_modules package.json %buildroot%nodejs_sitelib/node-gyp/
#cp -p %SOURCE10 %buildroot%nodejs_sitelib/node-gyp/addon-rpm.gypi

mkdir -p %buildroot%_bindir
ln -sf ../lib/node_modules/node-gyp/bin/node-gyp.js %buildroot%_bindir/node-gyp

# we will do bundle
#nodejs_symlink_deps

%files
%_bindir/node-gyp
%nodejs_sitelib/node-gyp/
%doc README.md LICENSE

%changelog
