%define _unpackaged_files_terminate_build 1

%define major 22.19

%define nodejs_soversion 127
%define nodejs_abi %nodejs_soversion

# there are both 6 and 7 provided (https://github.com/nodejs/node/pull/35199), see napi using
%define napi 7

# TODO: really we have no configure option to build with shared libv8
# V8 presently breaks ABI at least every x.y release while never bumping SONAME,
# so we need to be more explicit until spot fixes that
%define v8_version 12.4
%def_without systemv8


# check deps/npm/package.json for it
%define npm_version 10.9.3
# separate build npm
%def_with npm
# in other case, note: we will npm-@npmver-@release package! fix release if npmver is unchanged

# check deps/corepack/package.json
%define corepackver 0.29.3
%def_without corepack

# check deps/zlib/zlib.h
%define zlib_version 1.3.0.1

# check deps/cares/include/ares_version.h
%define c_ares_version 1.34.5

# check deps/llhttp/include/llhttp.h
%define llhttp_version 9.2.1
# to use internal llhttp
%def_without systemhttpparser

# check: openssl 3.0 inside (TODO: QUIC support, FIPS support)
%define openssl_version 3.0.15
%if_feature openssl3
%def_with systemssl
%endif

%def_with systemgyp

# check deps/uv/include/uv/version.h
%define libuv_version 1.49.2
%def_with systemuv

# check deps/nghttp2/lib/includes/nghttp2/nghttp2ver.h
%define libnghttp2_version 1.64.0
%def_with systemnghttp2

# see deps/v8/src/objects/intl-objects.h for V8_MINIMUM_ICU_VERSION
# check tools/icu/current_ver.dep
%define libicu_abi 7.4
# see rpm-macros-features
%if_feature icu %libicu_abi
%def_with systemicu
%endif

# TODO: some strange build error
%ifarch armh %ix86
%global optflags_lto %nil
%endif

# minimalize memory using
%ifarch armh
%define optflags_debug -g0
%endif

# need OpenSSL + QUIC build from https://github.com/quictls/openssl/tree/OpenSSL_1_1_1t+quic
%define libngtcp2_version 1.2.0
%define libnghttp3_version 0.7.0
%def_without systemngtcp2


%def_disable check

# https://nodejs.org/api/n-api.html
# https://github.com/nodejs/abi-stable-node
%def_with nodejs_abi

Name: node
Version: %major.0
Release: alt1

Summary: Evented I/O for V8 Javascript

Group: Development/Tools
License: MIT
Url: http://nodejs.org/

Packager: Vitaly Lipatov <lav@altlinux.ru>

##Source-git: https://github.com/nodejs/node.git
# Source-url: https://nodejs.org/dist/v%version/node-v%version.tar.gz
Source: %name-%version.tar
Source7: nodejs_native.req.files

Patch1: node18-system-openssl.patch
Patch2: npm-disable-internal-node-gyp.patch
Patch3: npm-disable-update-notifier.patch

BuildRequires(pre): rpm-macros-nodejs
BuildRequires(pre): rpm-build-intro >= 2.1.14
BuildRequires(pre): rpm-macros-features

BuildRequires: python3-devel gcc-c++
BuildRequires: zlib-devel >= %zlib_version
BuildRequires: libbrotli-devel

BuildRequires: gyp >= 0.18.3
BuildRequires: python3-module-simplejson

%if_with systemv8
%define libv8_package libv8-nodejs
BuildRequires: %libv8_package-devel >= %v8_version-devel
%endif

%if_with systemssl
BuildRequires: openssl-devel >= %openssl_version openssl
# for require strict library version
Requires: openssl >= %openssl_version
%endif

%if_with systemuv
BuildRequires: libuv-devel >= %libuv_version
%endif

%if_with systemicu
BuildRequires: libicu-devel >= %libicu_abi
%endif

%if_with systemnghttp2
BuildRequires: libnghttp2-devel >= %libnghttp2_version
%endif

%if_with systemngtcp2
BuildRequires: libngtcp2-devel >= %libngtcp2_version
BuildRequires: libnghttp3-devel >= %libnghttp3_version
%endif

%if_with systemhttpparser
BuildRequires: libhttp-parser-devel >= 2.9.2-alt2
%endif

BuildRequires: libcares-devel >= %c_ares_version

BuildRequires: curl

%if_without npm
Requires: npm >= %npm_version
%endif

# this corresponds to the "engine" requirement in package.json
Provides: nodejs(engine) = %version

Provides: nodejs = %version-%release
Provides: node.js = %version-%release
Obsoletes: nodejs < %version-%release
Obsoletes: node.js < %version-%release

Provides: nodejs(abi) = %nodejs_abi
Provides: nodejs(abi%major) = %nodejs_abi

Provides: nodejs(v8-abi) = %v8_version

#Provides: nodejs(napi) = 6
#Provides: nodejs(napi) = %{napi}

Provides: bundled(llhttp) = %llhttp_version
Provides: bundled(uvwasi) = 0.0.21

# Node.js is closely tied to the version of v8 that is used with it. It makes
# sense to use the bundled version because upstream consistently breaks ABI
# even in point releases. Node.js upstream has now removed the ability to build
# against a shared system version entirely.
# See https://github.com/nodejs/node/commit/d726a177ed59c37cf5306983ed00ecd858cfbbef
Provides: bundled(v8) = %v8_version

# /usr/bin/ld.default: failed to set dynamic section sizes: memory exhausted
%ifarch %ix86
%define optflags_debug -g0
%endif

# use no more than system_memory/1400 build procs (see https://bugzilla.altlinux.org/show_bug.cgi?id=35112)
%_tune_parallel_build_by_procsize 1400

%add_findreq_skiplist %{_datadir}/node/sources/*

%description
Node.js is a server-side JavaScript environment that uses an asynchronous
event-driven model.  Node's goal is to provide an easy way to build scalable
network programs.

%package devel
Summary:        Devel package for Node.js
Group:          Development/Other
License:        MIT license
# arch depended info in .gypi
#BuildArch:      noarch
Provides:	nodejs-devel = %EVR
Requires:	%name = %EVR
Requires:       gcc-c++ zlib-devel libbrotli-devel libcares-devel
%if_with systemv8
Requires:	%libv8_package-devel >= %v8_version
%endif
%if_with systemssl
Requires:	openssl-devel >= %openssl_version
%endif
%if_with systemuv
Requires: libuv-devel >= %libuv_version
%else
Conflicts:      libuv-devel
%endif

%description devel
Node.js header and build tools


%package doc
Summary: Documentation files
Group: Development/Other
Requires: %name-devel = %version-%release

BuildArch: noarch

%description doc
Documentation files for %name.

# https://bugzilla.altlinux.org/show_bug.cgi?id=38130
%if_with npm
%package -n npm
Version:	%npm_version
Group:		Development/Tools
Summary:	A package manager for node
License:	MIT License
Requires:	node
BuildArch:	noarch
# https://bugzilla.altlinux.org/show_bug.cgi?id=38130
#%if_with nodejs_abi
#Requires:	nodejs(abi) = %nodejs_abi
#%endif

Requires: bash
Requires: /usr/bin/node

# we do not need any module provides here
AutoProv: no
AutoReq: no

%description -n npm
npm is a package manager for node. You can use it to install and publish your
node programs. It manages dependencies and does other cool stuff.
%endif

%package corepack
Version:	%corepackver
Group:		Development/Tools
Summary:	Bridge between Node projects and their package managers
License:	MIT License
Requires:	node
BuildArch:	noarch
AutoReq:	yes,nopython
#%if_with nodejs_abi
Requires:	nodejs(abi) = %nodejs_abi
#%endif

%description corepack
Corepack is a zero-runtime-dependency Node.js script that acts as a bridge
between Node.js projects and the package managers they are intended to be used
with during development. In practical terms, **Corepack will let you use
Yarn and pnpm without having to install them** - just like what currently
happens with npm, which is shipped by Node.js by default.

**Important:** At the moment, Corepack only covers Yarn and pnpm.
Given that we have little control on the npm project, we prefer to focus
on the Yarn and pnpm use cases.
As a result, Corepack doesn't have any effect at all on the way you use npm.

%prep
%setup
%patch1 -p1
%patch2 -p1
%patch3 -p1

%if_with systemv8
# hack against https://bugzilla.altlinux.org/show_bug.cgi?id=32573#c3
cp -a deps/v8/include/libplatform src
rm -rv deps/v8/
%endif

%if_with systemicu
rm -rv deps/icu-small/
%endif

%if_with systemuv
rm -rv deps/uv/
%__subst "s|deps/uv/uv.gyp ||" Makefile
%__subst "s|.*../uv/uv.gyp:libuv.*||" deps/uvwasi/uvwasi.gyp
%endif

%if_with systemnghttp2
rm -rv deps/nghttp2/
%endif

%if_with systemngtcp2
rm -rv deps/ngtcp2/
%endif

%if_with systemssl
rm -rv deps/openssl
%endif

# disable external libs
# TODO:
# deps/gtest

%if_with systemgyp
rm -rv tools/gyp
%endif

rm -rv deps/zlib deps/cares deps/brotli
# make no sense for a first build
%__subst "s|deps/zlib/zlib.gyp||" Makefile

#rm -rv deps/v8/third_party/jinja2
#rm -rv tools/inspector_protocol/jinja2


%if_with npm
# fix https://bugzilla.altlinux.org/43430
subst 's|// obj\[key\] = flatOptions.userAgent|obj[key] = flatOptions.userAgent|' deps/npm/node_modules/@npmcli/config/lib/definitions/definitions.js

# remove all node-gyp deps
rm -rv deps/npm/node_modules/node-gyp/
%else
# don't use: keep internal npm (used for doc build)
rm -rv deps/npm/
ln -s %_libexecdir/node_modules/npm deps/npm


# Workaround for https://github.com/npm/cli/issues/780
cd man
local f name sec title
rm -v man5/install.5 
for f in man5/folders.5 man7/*.7; do
  sec=${f##*.}
  name=$(basename "$f" ."$sec")
  title=$(echo "$name" | tr '[:lower:]' '[:upper:]')

  sed -Ei "s/^\.TH \"$title\"/.TH \"NPM-$title\"/" "$f"
  mv "$f" "${f%/*}/npm-$name.$sec"
done
cd - >/dev/null

%endif

# use rpm's cflags
%__subst "s|'cflags': \[\],|'cflags': ['%optflags'],|" ./configure.py
# fix cflags wrap in outputted config.json
#__subst "s|indent=2|indent=2,width=160|" ./configure.py
# TODO: move to upstream?
%ifarch mipsel
%__subst "s|'libraries': \[\],|'libraries': ['-latomic'],|" ./configure.py
%endif

# override detected dir (detection via process.execPath does not work without /proc) with corect path
%__subst "s|path.resolve(prefixDir, 'lib', 'node')|'%nodejs_sitelib'|" lib/internal/modules/cjs/loader.js

%build
# hack against
# gyp: Error importing pymod_do_mainmodule (GN-scraper): No module named GN-scraper while loading dependencies of /tmp/.private/lav/RPM/BUILD/node-12.14.1/node.gyp
export PYTHONPATH=$(pwd)/tools/v8_gypfiles

./configure \
    --prefix=%_prefix \
    --enable-lto \
    --shared-zlib \
    --shared-brotli \
%if_with systemicu
    --with-intl=system-icu \
%endif
%if_with systemhttpparser
    --shared-http-parser \
%endif
    --shared-cares \
%if_with systemssl
    --shared-openssl \
    --shared-openssl-includes=%_includedir \
%endif
    --openssl-use-def-ca-store \
    --openssl-conf=%{_sysconfdir}/openssl/openssl.cnf \
%if_without npm
    --without-npm \
%endif
%if_without corepack
   --without-corepack \
%endif
%if_with systemuv
    --shared-libuv \
%endif
%if_with systemnghttp2
    --shared-nghttp2 \
%endif
%if_with systemngtcp2
    --shared-ngtcp2 \
    --shared-nghttp3 \
%endif
%if_with systemv8
    --without-bundled-v8 \
%endif
    %nil

%make_build BUILDTYPE=Release
# skip internal doc build (uses external modules)
#make doc
#%make jslint

%check
%make_build test

%install
mkdir -p %buildroot%nodejs_sitelib/

%makeinstall_std

%if_without systemuv
#install development headers
mkdir -p %{buildroot}%{_includedir}/node/
cp -p src/*.h %{buildroot}%{_includedir}/node
cp -p deps/uv/include/*.h %{buildroot}%{_includedir}/node
#cp -p deps/uv/include/uv-private/*.h %{buildroot}%{_includedir}/node/uv-private
%endif

%if_with npm
rm -rv %buildroot%nodejs_sitelib/npm/bin/node-gyp-bin/

# remove all node-gyp deps
rm -rv %buildroot%nodejs_sitelib/npm/node_modules/@npmcli/run-script/lib/node-gyp-bin

cat <<EOF >> %buildroot%nodejs_sitelib/npm/.npmrc
globalconfig=/etc/npmrc
update-notifier=false
EOF

%endif

%if_with nodejs_abi
# ensure Requires are added to every native module that match the Provides from
# the nodejs build in the buildroot
install -Dpm0755 %{SOURCE7} %buildroot%_rpmlibdir/nodejs_native.req.files
cat << EOF > %buildroot%_rpmlibdir/nodejs_native.req
#!/bin/sh
echo 'nodejs(abi) = %nodejs_abi'
#echo 'nodejs(v8-abi) = %v8_version'
EOF
chmod 0755 %buildroot%_rpmlibdir/nodejs_native.req
%endif

rm -rv %buildroot/usr/share/doc/node/gdbinit
rm -rv %buildroot/usr/share/doc/node/lldb_commands.py


%files
%doc CHANGELOG.md LICENSE README.md
%_bindir/node
%dir %nodejs_sitelib
#_prefix/lib/node
#%_datadir/systemtap/tapset/node.stp
%_man1dir/*

%files doc
%doc README.md
#out/doc/api

%files devel
%dir %_includedir/node/
#%_datadir/%name/%name-v%version-headers.tar.gz
%if_without systemuv
%_includedir/node/uv*
%endif
%if_without systemv8
%_includedir/node/v8*
%endif
%_includedir/node/node*
%_includedir/node/js_native_api*
# deps/cares
#_includedir/node/ares*
%_includedir/node/common.gypi
%_includedir/node/config.gypi
%_includedir/node/libplatform/
%_includedir/node/cppgc/
%if_without systemssl
%_includedir/node/openssl/
%endif
# deps/http_parser
#_includedir/node/nameser.h
#_datadir/node/common.gypi
%if_with nodejs_abi
%_rpmlibdir/nodejs_native.req
%_rpmlibdir/nodejs_native.req.files
%endif
#%_datadir/node/sources

%if_with npm
%files -n npm
%_bindir/npm
%_bindir/npx
%nodejs_sitelib/npm/
%endif

%if_with corepack
%files corepack
%_bindir/corepack
%nodejs_sitelib/corepack
%endif

%changelog
