%define _unpackaged_files_terminate_build 1

Name: nlohmann-json
Version: 3.12.0
Release: alt1

Summary: JSON for Modern C++ (c++11) ("single header file")

License: MIT
Group: Development/C++
Url: https://github.com/nlohmann/json

Packager: Pavel Vainerman <pv@altlinux.ru>

# Source0-url: https://github.com/nlohmann/json/archive/refs/tags/v%version.tar.gz
Source0: %name-%version.tar
# Source1-url: https://github.com/nlohmann/json_test_data/archive/refs/tags/v3.1.0.tar.gz
Source1: json_test_data.tar

BuildRequires: cmake ctest gcc-c++

%description
There are myriads of JSON libraries out there, and each may even have its reason to exist. 
Our class had these design goals:
- intuitive syntax.
- Trivial integration.
- Serious testing

%package devel
Summary: JSON for Modern C++ (c++11) ("single header file")
Group: Development/C++
BuildArch: noarch
Provides: json-cpp
Obsoletes: json-cpp

%description devel
There are myriads of JSON libraries out there, and each may even have its reason to exist. 
Our class had these design goals:
- intuitive syntax.
- Trivial integration.
- Serious testing

This package contains the single header C++ file and CMake dependency files.

%prep
%setup -a1
%autopatch -p1
#rm -rf test/cmake_fetch_content
%ifarch %e2k
# LCC 1.26 lacks <span>, and other workarounds
sed -i 's/JSON_HAS_CPP_20/UNDEF_&/;/std_fs::path(json(1))/d;s/__INTEL_COMPILER/__EDG__/' tests/src/unit-regression2.cpp
# failed test "object with error"
sed -i '/\[json.exception.type_error.301\]/d' tests/src/unit-constructor1.cpp
%endif
sed -i -e '/add_subdirectory(cmake_fetch_content)/ d' tests/CMakeLists.txt
sed -i -e '/add_subdirectory(cmake_fetch_content2)/ d' tests/CMakeLists.txt

%build
%cmake \
%ifarch %mips riscv64
    -DJSON_FastTests:BOOL=ON \
%endif
    %nil

%cmake_build

%install
%cmake_install

%check
ln -sf ../json_test_data %_cmake__builddir/json_test_data
%cmake_build --target test

%files devel
%_includedir/nlohmann
%_datadir/cmake/nlohmann_json
# https://bugzilla.altlinux.org/7917
%_datadir/pkgconfig/nlohmann_json.pc
#_pkgconfigdir/nlohmann_json.pc

%changelog
