%global _unpackaged_files_terminate_build 1
%define ngtcpsoname 16
%define ngtcp2_crypto_gnutls 8
%ifarch %ix86
%define relax ||:
%else
%define relax %nil
%endif

Name: ngtcp2
Version: 1.17.0
Release: alt1
Summary: An implementation of the RFC9000 QUIC protocol

License: MIT
Group: System/Libraries
Url: https://github.com/ngtcp2/ngtcp2
Vcs: https://github.com/ngtcp2/ngtcp2.git
Source: %name-%version.tar

Source100: %name-%version-tests-munit.tar
Source101: %name-%version-third-party-urlparse.tar
Source102: %name-%version-third-party-urlparse-http-parser.tar
Source103: %name-%version-third-party-urlparse-munit.tar


BuildRequires: gcc-c++ CUnit-devel
# need openssl-quic branch
#BuildRequires: pkgconfig(openssl) >= 1.1.1
BuildRequires: pkgconfig(gnutls) >= 3.7.2
BuildRequires: pkgconfig(libnghttp3) >= 1.12.0
BuildRequires: libev-devel

%description
%summary.

%package -n lib%name.%ngtcpsoname
Summary: An implementation of the RFC9000 QUIC protocol
Group: System/Libraries
Requires: lib%{name}_crypto_gnutls%{ngtcp2_crypto_gnutls} = %EVR

%description -n lib%name.%ngtcpsoname
%summary.

%package -n lib%{name}_crypto_gnutls%{ngtcp2_crypto_gnutls}
Summary: %name GnuTLS crypto library
Group: System/Libraries

%description -n lib%{name}_crypto_gnutls%{ngtcp2_crypto_gnutls}
%summary.

%package -n lib%name-devel
Summary: Files needed for building applications with libngtcp2
Group: Development/C
Requires: lib%name.%ngtcpsoname = %EVR
Requires: lib%{name}_crypto_gnutls%{ngtcp2_crypto_gnutls} = %EVR

%description -n lib%name-devel
The libngtcp2-devel package includes libraries and header files needed
for building applications with libngtcp2.

%prep
%setup -a100 -a101 -a102 -a103

%build
%autoreconf
%configure --disable-static --with-gnutls
%make_build

%install
%makeinstall_std
rm -rf %buildroot%_defaultdocdir/%name

%check
%make_build check %relax
[ -f "tests/test-suite.log" ] && cat "tests/test-suite.log"


%files -n lib%name.%ngtcpsoname
%_libdir/lib%{name}.so.%{ngtcpsoname}.*
%_libdir/lib%{name}.so.%{ngtcpsoname}

%files -n lib%{name}_crypto_gnutls%{ngtcp2_crypto_gnutls}
%_libdir/lib%{name}_crypto_gnutls.so.%{ngtcp2_crypto_gnutls}*

%doc README.rst

%files -n lib%name-devel
%_includedir/%name
%_pkgconfigdir/*.pc
%_libdir/*.so

%changelog
