%define _unpackaged_files_terminate_build 1
%define php_version %php_defver

Name: nextcloud
Version: 32.0.1
Release: alt1

%define installdir %webserver_webappsdir/%name

Summary: Cloud platform
Group: Networking/WWW
License: AGPL-3.0
Url: https://nextcloud.com/

BuildArch: noarch

BuildRequires(pre): rpm-build-php
BuildRequires(pre): rpm-macros-webserver-common
BuildRequires: python3-base
Requires(pre): webserver-common

# https://docs.nextcloud.com/server/13/admin_manual/installation/source_installation.html#ubuntu-installation-label
Requires: php%php_version
Requires: php%php_version-libs
Requires: php%php_version-dom
Requires: php%php_version-gd2
Requires: php%php_version-mbstring
Requires: php%php_version-xmlreader
Requires: php%php_version-zip
# Highly recommended:
Requires: php%php_version-curl
Requires: php%php_version-fileinfo
Requires: php%php_version-openssl
# For SQL DBs
Requires: php%php_version-pdo-driver
Requires: php%php_version-pcntl
Requires: php%php_version-intl
# Recommended
Requires: php%php_version-memcached
Requires: php%php_version-gmp
Requires: php%php_version-imagick
Requires: php%php_version-exif

Source0: %name-%version.tar
Source1: %name.watch
Patch1: nextcloud-simple-check-unicode-locale.patch
Patch2: nextcloud-fix-openssl-config.patch
Patch3: nextcloud-31.0.2-alt1-apps-blacklist.patch

# Automatically added by buildreq on Mon Oct 03 2016
# optimized out: python-base python-modules python3
BuildRequires: python3-base

%filter_from_requires /^composer$/d

%description
Nextcloud gives you easy and universal access to all of your files.
It also provides a platform to easily view, sync and share your contacts
calendars, bookmarks and files across all your devices.

%package apache2
Summary: Apache 2.x web-server default configuration for %name
Group: Networking/WWW
Requires: %name = %EVR
Requires: apache2-mod_php%php_version
Requires: apache2-mod_ssl
Requires(post): cert-sh-functions

%description apache2
Apache 2.x web-server default configuration for %name.

%package nginx
Summary: nginx web-server default configuration for %name
Group: Networking/WWW
Requires: %name = %EVR nginx
Requires: php%php_version-fpm-fcgi
Requires(post): cert-sh-functions

%description nginx
nginx web-server default configuration for %name.

%prep
%setup
%autopatch -p1

%install
mkdir -p %buildroot%installdir
cp -rp %name/* %buildroot%installdir/
cp %name/.htaccess %buildroot%installdir/
cp %name/.user.ini %buildroot%installdir/

find %buildroot%installdir/ -name tests -type d | xargs rm -fr
rm -f %buildroot%installdir/l10n/l10n.pl

mkdir -p %buildroot%_sysconfdir/%name
mv %buildroot%installdir/config/ %buildroot%_sysconfdir/%name/.
ln -s %_sysconfdir/%name/config %buildroot%installdir/config

mkdir -p %buildroot%_localstatedir/%name
ln -s %_localstatedir/%name %buildroot%installdir/data

# Install apache2
install -pD -m0644 apache2/default.conf %buildroot%_sysconfdir/httpd2/conf/sites-available/%name.conf

# Install nginx
subst 's/php[0-9.]\+-fpm/php%php_version-fpm/g' nginx/default.conf
install -pD -m0644 nginx/default.conf %buildroot%_sysconfdir/nginx/sites-available.d/%name.conf

# Remove distribution
#rm -rf %buildroot%installdir/dist

%post apache2
a2ensite %name
a2enmod ssl
a2enport https
a2enmod rewrite
a2enmod env
a2enmod headers
a2enmod dir
a2enmod mime
# Generate SSL key
. cert-sh-functions
ssl_generate "nextcloud"
# Disable mod_php7 if it is enabled
/usr/sbin/apachectl2 -M | grep -q php7_module && ( a2dismod mod_php7 &>/dev/null ) ||:
%_initdir/httpd2 condreload

%postun apache2
%_initdir/httpd2 condreload

%post nginx
# Generate SSL key
. cert-sh-functions
ssl_generate "nextcloud"

%files
%dir %installdir
%installdir/3rdparty
%dir %attr(0775,root,_webserver) %installdir/apps
%attr(0775,root,_webserver) %installdir/apps/*
%installdir/core
%installdir/dist
%installdir/lib
%installdir/oc*
%installdir/resources
%installdir/themes
%installdir/updater
%dir %attr(0770,root,_webserver) %_sysconfdir/%name/config/
%_sysconfdir/%name
%installdir/config
%dir %attr(0770,root,_webserver) %_localstatedir/%name
%installdir/data
%installdir/*.php
%installdir/*.json
%installdir/*.lock
%installdir/.htaccess
%installdir/.user.ini
%doc %installdir/AUTHORS
%doc %installdir/COPYING
%installdir/index.html
%installdir/robots.txt
%installdir/LICENSES
%installdir/REUSE.toml

%files apache2
%config(noreplace) %attr(0644,root,root) %_sysconfdir/httpd2/conf/sites-available/%name.conf

%files nginx
%config(noreplace) %attr(0644,root,root) %_sysconfdir/nginx/sites-available.d/%name.conf

%changelog
