%define _name newt
# devel-static subpackage needed for propagator (see altbug #40863)
%def_enable static
%def_enable tk

Name: newt52
Version: 0.52.24
Release: alt1

Summary: A development library for text mode user interfaces

License: LGPLv2
Group: System/Libraries
Url: https://fedorahosted.org/releases/n/e/newt/

Packager: Slava Dubrovskiy <dubrsl@altlinux.ru>

# Source-url: https://releases.pagure.org/newt/newt-%version.tar.gz
Source: %name-%version.tar

Requires: lib%name = %EVR
Requires: slang
Provides: snack = %version-%release

BuildRequires: libpopt-devel libslang2-devel docbook-utils python3-devel
%if_enabled tk
BuildRequires: python3-modules-tkinter
%endif

%if_enabled static
BuildRequires: libslang2-devel-static
%global optflags_lto %optflags_lto -ffat-lto-objects
%endif

# FIXME: more correct way
%add_optflags %(pkg-config --cflags slang)

%package -n lib%name
Summary: Newt windowing toolkit development files library.
Group: System/Libraries
Provides: lib%_name = %EVR

%package -n python3-module-%name
Summary: Python files for the %name
Group: System/Libraries
Requires: lib%name = %EVR
Provides: python3-module-%_name = %version-%release

%package -n lib%_name-devel
Summary: Newt windowing toolkit development files
Group: Development/C
Requires: lib%name = %EVR, libslang2-devel
Provides: lib%name-devel = %version-%release
Obsoletes: %_name-devel

%package -n lib%_name-devel-static
Summary: Newt windowing toolkit development files
Group: Development/C
Requires: lib%name-devel = %EVR
Requires: libslang2-devel-static
Provides: lib%name-devel-static = %version-%release

%description
Newt is a programming library for color text mode, widget based user
interfaces.  Newt can be used to add stacked windows, entry widgets,
checkboxes, radio buttons, labels, plain text fields, scrollbars,
etc., to text mode user interfaces.  This package contains a
/usr/bin/dialog replacement called whiptail.
Newt is based on the slang library.

%description -n lib%name
Newt is a programming library for color text mode, widget based user
interfaces.  Newt can be used to add stacked windows, entry widgets,
checkboxes, radio buttons, labels, plain text fields, scrollbars,
etc., to text mode user interfaces.  This package contains the
shared library needed by programs built with %name.
Newt is based on the slang library.

%description -n python3-module-%name
python stuff for the %name

%description -n lib%_name-devel
The lib%name-devel package contains the header files and libraries
necessary for developing applications which use %name. Newt is
a development library for text mode user interfaces.
Newt is based on the slang library.

Install lib%name-devel if you want to develop applications which will
use %name.

%description -n lib%_name-devel-static
Static libraries for  lib%name-devel

%prep
%setup
#patch -p1

#subst s/^PYTHONVERS.*/PYTHONVERS=python%_python_version/ Makefile.in

%build
%configure --with-gpm-support %{subst_enable static}
%make_build
docbook2html -u tutorial.sgml

%install
%makeinstall_std
%if_disabled static
rm -v %buildroot%_libdir/*.*a
%endif

%find_lang --with-gnome %_name

%check
%make test

%files -n lib%name -f %_name.lang
%_libdir/*.so.*

%files
%_bindir/*
%doc CHANGES
%_man1dir/*

%files -n python3-module-%name
%python3_sitelibdir/*

%files -n lib%_name-devel
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*
%doc tutorial.html

%if_enabled static
%files -n lib%_name-devel-static
%_libdir/*.*a
%endif

%changelog
