%def_without check

Name:	 newsboat
Version: 2.41
Release: alt1

Summary: An RSS/Atom feed reader for the text console

License: MIT
Group:	 Networking/News
Url:	 https://newsboat.org
Vcs:	 https://github.com/newsboat/newsboat.git

Source0: %name-%version.tar
Source1: vendor.tar
Source2: %name.watch
Source3: Cargo.lock

Provides:  newsbeuter = %EVR
Obsoletes: newsbeuter < %EVR

BuildRequires:	/proc
BuildRequires:	asciidoctor
BuildRequires:	gcc-c++
BuildRequires:	pkgconfig(libcurl)
BuildRequires:	pkgconfig(json-c)
BuildRequires:	pkgconfig(ncursesw)
BuildRequires:	pkgconfig(sqlite3)
BuildRequires:	pkgconfig(libssl)
BuildRequires:	pkgconfig(stfl)
BuildRequires:	pkgconfig(libxml-2.0)
BuildRequires:	rust-cargo
BuildRequires:	pkgconfig(zlib)

%description
Newsboat is an RSS/Atom feed reader for the text console. It's an actively
maintained fork of Newsbeuter.

%prep
%setup -a1
mkdir -p .cargo
cat >> .cargo/config.toml <<EOF
[source.crates-io]
replace-with = "vendored-sources"

[source.vendored-sources]
directory = "vendor"

[term]
verbose = true
quiet = false

[install]
root = "%buildroot%_prefix"

[build]
rustflags = ["-Copt-level=3", "-Cdebuginfo=1"]

[profile.release]
strip = false
EOF
cp -fv %SOURCE3 .

%build
./config.sh
%make_build prefix=%_prefix

%install
%makeinstall_std prefix=%_prefix
%find_lang %name

%check
# workaround for test compilaton: remove me in the next release
%add_optflags -Wno-error=maybe-uninitialized
export CFLAGS="%optflags"
export CXXFLAGS="$CFLAGS"

make test
cargo test

%files -f %name.lang
%doc LICENSE
%_bindir/newsboat
%_bindir/podboat
%_defaultdocdir/newsboat
%_man1dir/newsboat.1*
%_man1dir/podboat.1*
%dir %_iconsdir/hicolor/scalable
%dir %_iconsdir/hicolor/scalable/apps
%_iconsdir/hicolor/scalable/apps/newsboat.svg
%_datadir/fish/vendor_completions.d/%name.fish
%_datadir/zsh/site-functions/_%name

%changelog
