%define _unpackaged_files_terminate_build 1

%define sover 22

%ifarch %ix86
%def_without check
%else
%def_with check
%endif

Name: netcdf
Version: 4.9.3
Release: alt1
Summary: Libraries to use the Unidata network Common Data Form (netCDF)
License: NetCDF
Group: System/Libraries
Url: https://www.unidata.ucar.edu/software/netcdf/

VCS: https://github.com/Unidata/netcdf-c.git
Source: %name-%version.tar

BuildRequires: flex gcc-c++ gcc-fortran zlib-devel libhdf5-devel libxml2-devel
BuildRequires: /usr/bin/tex libcurl-devel libexpat-devel doxygen graphviz
%if_with check
BuildRequires: /proc unzip
%endif

%description
NetCDF (network Common Data Form) is an interface for array-oriented
data access and a freely-distributed collection of software libraries
for C, Fortran, C++, and perl that provides an implementation of the
interface.
The netCDF library also defines a machine-independent format for
representing scientific data. Together, the interface, library, and
format support the creation, access, and sharing of scientific data. The
netCDF software was developed at the Unidata Program Center in Boulder,
Colorado.

NetCDF data is:

   o Self-Describing. A netCDF file includes information about the data
     it contains.

   o Network-transparent. A netCDF file is represented in a form that
     can be accessed by computers with different ways of storing
     integers, characters, and floating-point numbers.

   o Direct-access. A small subset of a large dataset may be accessed
     efficiently, without first reading through all the preceding data.

   o Appendable. Data can be appended to a netCDF dataset along one
     dimension without copying the dataset or redefining its structure.
     The structure of a netCDF dataset can be changed, though this
     sometimes causes the dataset to be copied.

   o Sharable. One writer and multiple readers may simultaneously
     access the same netCDF file.

%description -l ru_RU.UTF-8
NetCDF (network Common Data Form) - это ориентированный на массивы
интерфейс для доступа к данным и, одновременно, свободно
распространяемая коллекция программ и библиотек для C, Fortran, C++,
которые реализуют этот интерфейс. Программы netCDF были
разработаны Гленом Дэвисом (Glenn Davis), Руссом Рью (Russ Rew),
Стивом Еммерсоном (Steve Emmerson), Джоном Кэроном (John Caron) и
Харвей Дэвисом (Harvey Davies) в Unidata Program Center в Боулдере,
Колорадо и расширены вкладами от других пользователей netCDF.
Библиотеки netCDF определяют машиннонезависимый  формат для
представления научных данных. Интерфейс, библиотеки и сам формат
поддерживают создание, доступ и совместное использование научных
данных.

%package -n libnetcdf%sover
Summary: Libraries to use the Unidata network Common Data Form (netCDF)
Group: System/Libraries

%description -n libnetcdf%sover
NetCDF (network Common Data Form) is an interface for array-oriented
data access and a freely-distributed collection of software libraries
for C, Fortran, C++, and perl that provides an implementation of the
interface.
The netCDF library also defines a machine-independent format for
representing scientific data. Together, the interface, library, and
format support the creation, access, and sharing of scientific data. The
netCDF software was developed at the Unidata Program Center in Boulder,
Colorado.

NetCDF data is:

   o Self-Describing. A netCDF file includes information about the data
     it contains.

   o Network-transparent. A netCDF file is represented in a form that
     can be accessed by computers with different ways of storing
     integers, characters, and floating-point numbers.

   o Direct-access. A small subset of a large dataset may be accessed
     efficiently, without first reading through all the preceding data.

   o Appendable. Data can be appended to a netCDF dataset along one
     dimension without copying the dataset or redefining its structure.
     The structure of a netCDF dataset can be changed, though this
     sometimes causes the dataset to be copied.

   o Sharable. One writer and multiple readers may simultaneously
     access the same netCDF file.

%description -l ru_RU.UTF-8 -n libnetcdf%sover
NetCDF (network Common Data Form) - это ориентированный на массивы
интерфейс для доступа к данным и, одновременно, свободно
распространяемая коллекция программ и библиотек для C, Fortran, C++,
которые реализуют этот интерфейс. Программы netCDF были
разработаны Гленом Дэвисом (Glenn Davis), Руссом Рью (Russ Rew),
Стивом Еммерсоном (Steve Emmerson), Джоном Кэроном (John Caron) и
Харвей Дэвисом (Harvey Davies) в Unidata Program Center в Боулдере,
Колорадо и расширены вкладами от других пользователей netCDF.
Библиотеки netCDF определяют машиннонезависимый  формат для
представления научных данных. Интерфейс, библиотеки и сам формат
поддерживают создание, доступ и совместное использование научных
данных.

%package tools
Summary: NetCDF tools
Group: Development/Tools

%description tools
This package contains tools for work with NetCDF

%package -n libnetcdf-devel
Summary: Development tools for the NetCDF library
Summary(ru_RU.UTF-8): Средства разработки программ на основе библиотеки NetCDF
Group: Development/C
Provides: pkgconfig(netcdf) = %EVR

%description -n libnetcdf-devel
This package contains the netCDF-3 header files, shared devel libs, and
man pages.

If you want to develop applications which will use the NetCDF library,
you'll need to install the %name-devel package.

%description -l ru_RU.UTF-8 -n libnetcdf-devel
Заголовочные файлы и документация для использования библиотеки NetCDF
в приложениях.

Если вы собираетесь разрабатывать приложения, которые будут
использовать библиотеку NetCDF, вам необходимо установить пакет
%name-devel.

%package -n libnetcdf-doc
Summary: Documentation for NetCDF
Summary(ru_RU.UTF-8): Документация по NetCDF
Group: Documentation

%description -n libnetcdf-doc
Documentation for NetCDF library.

%description -l ru_RU.UTF-8 -n libnetcdf-doc
Документация по NetCDF.

%package -n hdf5-netcdf-plugins
Summary:        HDF5 filter plugins for NetCDF
Group:          System/Libraries

%description -n hdf5-netcdf-plugins
This package provides HDF5 filter plugins used by NetCDF for enhanced compression
and data processing capabilities. The plugins include:
- BZIP2 compression filter
- DEFLATE compression filter
- Fletcher32 checksum filter
- Shuffle filter
- Standard filters for NCZarr format

These plugins are required for advanced NetCDF functionality when working with
HDF5-based NetCDF files that use these compression methods.

%prep
%setup

rm -fR udunits/expat

%build
%add_optflags -fno-strict-aliasing
%autoreconf
%configure \
	--enable-shared \
	--enable-static=no \
	--enable-netcdf-4 \
	--enable-doxygen \
	--enable-internal-docs \
	--enable-v2 \
	--enable-mmap \
	--disable-dap-remote-tests \
	--enable-extra-example-test \
	--enable-filter-testing \
	--with-plugin-dir=%_libdir/hdf5/plugin \
	%nil

%make

%check
%make check

%install
%makeinstall_std
rm -f %buildroot%_libdir/hdf5/plugin/*.la

%files -n libnetcdf%sover
%doc COPYRIGHT
%doc README* RELEASE_NOTES*
%_libdir/*.so.%{sover}
%_libdir/*.so.%{sover}.*

%files -n libnetcdf-devel
%_bindir/nc-config
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*
%_man3dir/netcdf.3*

%files tools
%_bindir/*
%exclude %_bindir/nc-config
%_libdir/*.settings
%_man1dir/*

%files -n hdf5-netcdf-plugins
%dir %_libdir/hdf5/plugin
%_libdir/hdf5/plugin/lib__nch5*.so
%_libdir/hdf5/plugin/lib__ncz*.so

%files -n libnetcdf-doc
%doc docs/html examples

%changelog
