%define abiversion 40
%define _name net-snmp
%def_disable mibs
%def_with mysql
%def_with systemd
# XXX tests fail
%def_without test

%set_gcc_version      13

Name: %_name%abiversion
Version: 5.9.4
Release: alt1.3

Summary: Tools and servers for the SNMP protocol
License: BSD-like
Group: System/Servers
Url: http://net-snmp.sourceforge.net

Source0: %name-%version.tar
#git clone git://net-snmp.git.sourceforge.net/gitroot/net-snmp/net-snmp
Source1: %_name.init
Source2: %_name.conf
Source3: %_name.logrotate
Source4: snmptrapd.init
Source5: net-snmpd.sysconfig
Source6: net-snmptrapd.sysconfig
Source7: net-snmp-tmpfs.conf
Source8: snmpd.service
Source9: snmptrapd.service

Patch: %name-%version-%release.patch

# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %_var
%define persistentdir %_var/lib/%_name

%def_enable static
BuildRequires: librpm-devel >= 4.0.4 libssl-devel
# Automatically added by buildreq on Wed Oct 13 2010
BuildRequires: libnl-devel librpm-devel libsensors3-devel pdksh perl-devel python3-module-setuptools perl-Term-ReadLine-Gnu perl-libnet perl-XML-Simple perl-JSON perl-Mail-Sender
%{?_enable_static:BuildRequires: glibc-devel-static}
%{?_with_mysql:BuildRequires: libmysqlclient-devel}
%{?_with_systemd:BuildRequires: systemd-devel}
BuildRequires: perl-podlators chrpath

%package -n %_name-common
Summary: Common dirs and files for the SNMP protocol
Group: System/Servers
BuildArch: noarch
Requires: snmp-mibs-std
%if_enabled mibs
Requires: %_name-mibs = %version-%release
%endif

%package -n %_name
Summary: Virtual package for install snmpd server and clients of the SNMP protocol
Group: System/Servers
BuildArch: noarch
Requires: %_name-snmpd %_name-snmptrapd %_name-clients

%package -n %_name-snmpd
Summary: Snmpd server for the SNMP protocol
Group: System/Servers
Requires: lib%_name = %version-%release %_name-common
%filter_from_requires /^\/usr\/bin\/grep/d
%filter_from_requires /^\/usr\/bin\/ps/d
Obsoletes: cmu-snmp ucd-snmp

%package -n %_name-snmptrapd
Summary: Snmptrapd and server for the SNMP protocol
Group: System/Servers
Requires: lib%_name = %version-%release %_name-common
Obsoletes: cmu-snmp ucd-snmp

%package -n %_name-clients
Summary: Tools for use SNMP, from the Net-SNMP project
Group: Networking/Other
Requires: lib%_name = %version-%release %_name-common

%package -n %_name-utils
Summary: Network management utilities using SNMP, from the Net-SNMP project
Group: Networking/Other
BuildArch: noarch
Requires: lib%_name = %version-%release %_name-common perl-SNMP
Obsoletes: cmu-snmp-utils ucd-snmp-utils

%package -n %_name-bridge-mib
Summary: Provide Linux bridge information via SNMP
Group: Networking/Other
BuildArch: noarch
Requires: %_name-snmpd

%package -n %_name-cert
Summary: Creates, signs, installs and displays X.509 certificates used in the operation of Net-SNMP/(D)TLS
Group: Networking/Other
BuildArch: noarch
Requires: %_name-common

%package -n lib%name
Summary: The shared libraries for the Net-SNMP project
Group: System/Libraries
Provides: lib%_name = %version-%release

%package -n lib%name-agent
Summary: The shared agent libraries for the Net-SNMP project
Group: System/Libraries
Provides: lib%_name-agent = %version-%release
Provides: lib%name-snmptrapd = %version-%release
Provides: lib%_name-snmptrapd = %version-%release
Obsoletes: lib%name-snmptrapd < %version-%release
Obsoletes: lib%_name-snmptrapd < %version-%release

%package -n lib%_name-devel
Summary: The development environment for the Net-SNMP project
Group: Development/C
Requires: lib%_name = %version-%release lib%_name-agent = %version-%release %_name-common
Provides: lib%name-devel = %version-%release
Requires: libssl-devel libsensors3-devel libnl-devel

%package -n lib%_name-devel-static
Summary: static libraries for lib%_name
Group: Development/C
Requires: lib%_name-devel = %version-%release

%if_enabled mibs
%package -n %_name-mibs
Summary: MIB files from the Net-SNMP project
Group: Networking/Other
%endif

%package -n perl-SNMP
Summary: Perl SNMP Extension Module
Group: Development/Perl
Requires: lib%_name = %version-%release %_name-common

%package -n python3-module-netsnmp
Summary: Python SNMP Extension Module
Group: Development/Python3
Requires: lib%_name = %version-%release

%description
SNMP (Simple Network Management Protocol) is a protocol used for network
management (hence the name).  The Net-SNMP project includes various SNMP
tools; an extensible agent, an SNMP library, tools for requesting or
setting information from SNMP agents, tools for generating and handling
SNMP traps, a version of the netstat command which uses SNMP, and a
Tk/Perl mib browser.  This package contains the snmpd and snmptrapd
daemons, documentation, etc.

Install the %_name package if you need network management tools.
You will probably also want to install the %_name-utils package, which
contains Net-SNMP utilities.

%description -n %_name-common
SNMP (Simple Network Management Protocol) is a protocol used for network
management (hence the name).  The Net-SNMP project includes various SNMP
tools; an extensible agent, an SNMP library, tools for requesting or
setting information from SNMP agents, tools for generating and handling
SNMP traps, a version of the netstat command which uses SNMP, and a
Tk/Perl mib browser.  This package contains the snmpd and snmptrapd
daemons, documentation, etc.

%_name-common package contain common files and dirs

%description -n %_name
SNMP (Simple Network Management Protocol) is a protocol used for network
management (hence the name).  The Net-SNMP project includes various SNMP
tools; an extensible agent, an SNMP library, tools for requesting or
setting information from SNMP agents, tools for generating and handling
SNMP traps, a version of the netstat command which uses SNMP, and a
Tk/Perl mib browser.  This package contains the snmpd and snmptrapd
daemons, documentation, etc.

%_name is virtual package for quick install %_name-snmpd %_name-snmptrapd %_name-clients

%description -n %_name-snmpd
SNMP (Simple Network Management Protocol) is a protocol used for network
management (hence the name).  The Net-SNMP project includes various SNMP
tools; an extensible agent, an SNMP library, tools for requesting or
setting information from SNMP agents, tools for generating and handling
SNMP traps, a version of the netstat command which uses SNMP, and a
Tk/Perl mib browser.  This package contains the snmpd and snmptrapd
daemons, documentation, etc.

%_name-snmpd package contain snmpd server

%description -n %_name-snmptrapd
SNMP (Simple Network Management Protocol) is a protocol used for network
management (hence the name).  The Net-SNMP project includes various SNMP
tools; an extensible agent, an SNMP library, tools for requesting or
setting information from SNMP agents, tools for generating and handling
SNMP traps, a version of the netstat command which uses SNMP, and a
Tk/Perl mib browser.  This package contains the snmpd and snmptrapd
daemons, documentation, etc.

%_name-snmptrapd package contain snmptrapd server

%description -n %_name-clients
The %_name-clients package contains various tools for use with the
Net-SNMP network management project.

Install this package if you need utilities for managing your network
using the SNMP protocol.

%description -n %_name-utils
The %_name-utils package contains various utilities for use with the
Net-SNMP network management project.

Install this package if you need utilities for managing your network
using the SNMP protocol.

%description -n %_name-bridge-mib
Provide Linux bridge information via SNMP

%description -n %_name-cert
net-snmp-cert creates, signs, installs and displays X.509
certificates used in the operation of Net-SNMP/(D)TLS

%description -n lib%name
The lib%_name package contains the shared libraries required for
Net-SNMP software.

%description -n lib%name-agent
The lib%name-agent package contains the shared agent libraries required for
Net-SNMP software.

%description -n lib%_name-devel
This package contains include files required for development
applications for use with the Net-SNMP project's network management
tools. You'll also need to have the lib%_name and %_name-utils packages
installed.

%description -n lib%_name-devel-static
This package contains static libraries required for development
statically linked applications for use with the Net-SNMP project's
network management tools. You'll also need to have the lib%_name-devel
package installed.


%if_enabled mibs
%description -n %_name-mibs
The %_name package contains various MIB files for use with the
Net-SNMP network management project.
%endif

%description -n perl-SNMP
This is the Perl 'SNMP' extension module. The SNMP module provides
a full featured, tri-lingual SNMP (SNMPv3, SNMPv2c, SNMPv1) API.
The SNMP module also provides an interface to the SMI MIB parse-tree
for run-time access to parsed MIB data.

%description -n python3-module-netsnmp
This is the Python 'SNMP' extension module. The SNMP module provides
a full featured, tri-lingual SNMP (SNMPv3, SNMPv2c, SNMPv1) API.
The SNMP module also provides an interface to the SMI MIB parse-tree
for run-time access to parsed MIB data.

%prep
%setup
%patch -p1

%build
export CC=%__cc
export CXX=%__cxx

%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}
%autoreconf
#export NETSNMP_DONT_CHECK_VERSION=1
#export LIBS='-lcrypto'

MIBS="host agentx smux \
     ucd-snmp/diskio tcp-mib udp-mib mibII/mta_sendmail \
     ip-mib/ipv4InterfaceTable ip-mib/ipv6InterfaceTable \
     ip-mib/ipAddressPrefixTable/ipAddressPrefixTable \
     ip-mib/ipDefaultRouterTable/ipDefaultRouterTable \
     ip-mib/ipv6ScopeZoneIndexTable ip-mib/ipIfStatsTable \
     sctp-mib rmon-mib etherlike-mib"

%ifnarch s390 s390x ppc64le
# there are no lm_sensors on s390
MIBS="$MIBS ucd-snmp/lmsensorsMib"
%endif

%configure %{subst_enable static} \
	--with-defaults \
	--enable-shared \
	--enable-as-needed \
	--enable-blumenthal-aes \
	--enable-embedded-perl \
	--enable-ipv6 \
	--enable-local-smux \
	--enable-mfd-rewrites \
	--enable-ucd-snmp-compatibility \
	--with-sys-location="Unknown" \
	--with-sys-contact="root@localhost" \
	--with-logfile="/var/log/snmpd.log" \
	--with-mib-modules="$MIBS" \
	--with-mibdirs="%_datadir/snmp/mibs:%_datadir/mibs/net-snmp:%_datadir/mibs/iana:%_datadir/mibs/ietf:%_datadir/mibs/tubs:%_datadir/mibs/cisco:%_datadir/pibs/ietf:%_datadir/pibs/tubs:" \
	--with-persistent-directory="%persistentdir" \
	--with-temp-file-pattern=/run/net-snmp/snmp-tmp-XXXXXX \
	--without-root-access \
	--without-rpm \
	--with-openssl \
	--with-zlib \
	--with-nl \
	--with-security-modules=tsm \
	--with-transports="TLSTCP DTLSUDP" \
	--with-perl-modules="INSTALLDIRS=vendor" \
	--with-python-modules \
	--without-pcre \
	%{subst_with mysql} \
	%{subst_with systemd}

# non-SMP-safe build
make
rm -f `find ./ -name 'libnetsnmpagent*'`
%make ADD_HELPER="-L$PWD/agent/helpers/.libs -lnetsnmphelpers"


%install
# DO NOT replace with %%makeinstall_std: breaks build
# (libnetsnmp.so.30 gets built but not installed)
%make DESTDIR=%buildroot install

mkdir -p %buildroot%_initdir
mkdir -p %buildroot%_sysconfdir/sysconfig
mkdir -p %buildroot%persistentdir
mkdir -p %buildroot%_defaultdocdir/perl-SNMP-%version

install -p -m755 -D %SOURCE1 %buildroot%_initdir/snmpd
install -p -m640 -D %SOURCE2 %buildroot%_sysconfdir/snmp/snmpd.conf
install -p -m644 -D %SOURCE3 %buildroot%_sysconfdir/logrotate.d/snmpd
install -p -m755 -D %SOURCE4 %buildroot%_initdir/snmptrapd
install -p -m644 -D %SOURCE5 %buildroot%_sysconfdir/sysconfig/snmpd
install -p -m644 -D %SOURCE6 %buildroot%_sysconfdir/sysconfig/snmptrapd


# systemd stuff
install -m 755 -d %buildroot%_tmpfilesdir
install -m 644 %SOURCE7 %buildroot%_tmpfilesdir/net-snmp.conf
install -m 755 -d %buildroot%_unitdir
install -m 644 %SOURCE8 %SOURCE9 %buildroot%_unitdir/

# perl loadable objects contain $RPM_BUILD_DIR-dependent RPATH
#hrpath -d `find %buildroot%perl_vendor_autolib -type f -name '*.so'`

xz ChangeLog

#Fix net-snmp-create-v3-user
sed -i "s|ps -acx|ps acx|g" %buildroot%_bindir/net-snmp-create-v3-user
sed -i "s|/usr/share/snmp/snmpd.conf|%_sysconfdir/snmp/snmpd.conf|g" %buildroot%_bindir/net-snmp-create-v3-user


find %buildroot%_datadir/snmp/mibs/ -name "*.txt" -type f | while read file; do mv "$file" "${file%%.txt}"; done

#tar MIBS for simple update
tar -cjf net-snmp-mibs.tar.bz2 -C %buildroot%_datadir/snmp mibs/
rm -rf %buildroot%_datadir/snmp/mibs

#Fix rpath
find %buildroot%perl_vendor_autolib/SNMP -type f -name *.so -print0 | xargs -r0 chrpath -d
find %buildroot%perl_vendor_autolib/NetSNMP -type f -name *.so -print0 | xargs -r0 chrpath -d

# remove things we don't want to distribute
rm -f %buildroot%_bindir/snmpinform
ln -s snmptrap %buildroot%_bindir/snmpinform
rm -f %buildroot%_bindir/snmpcheck
rm -f %buildroot%_bindir/fixproc
rm -f %buildroot%_mandir/man1/fixproc*
rm -f %buildroot%_bindir/ipf-mod.pl
rm -f %buildroot%_libdir/*.la
rm -f %buildroot%_libdir/libsnmp*

# remove special perl files
find %buildroot -name perllocal.pod \
    -o -name .packlist \
    -o -name "*.bs" \
    -o -name Makefile.subs.pl \
    | xargs -ri rm -f {}

%check
%ifarch ppc64le
rm -vf testing/fulltests/default/T200snmpv2cwalkall_simple
%endif
chmod 755 local/passtest

echo "===== start test ====="
LD_LIBRARY_PATH=%buildroot/%_libdir %make test

%pre -n %_name-common
%_sbindir/groupadd -r -f snmp &>/dev/null
%_sbindir/useradd -r -g snmp -d /dev/null -s /dev/null \
        -c "SNMP pseudo user" -M -n snmp &>/dev/null ||:
%_sbindir/usermod -g proc snmp &>/dev/null ||:

%post -n %_name-snmpd
%post_service snmpd

%post -n %_name-snmptrapd
%post_service snmptrapd

%preun -n %_name-snmpd
%preun_service snmpd

%preun -n %_name-snmptrapd
%preun_service snmptrapd

%files -n %_name

%files -n %_name-common
%doc AGENT.txt COPYING ChangeLog* EXAMPLE.conf FAQ NEWS PORTING README* TODO
%doc local/passtest local/ipf-mod.pl
%dir %_sysconfdir/snmp
%dir %_datadir/snmp
%attr(0770,snmp,root) %persistentdir

%files -n %_name-snmpd
%_tmpfilesdir/net-snmp.conf
%_initdir/snmpd
%_unitdir/snmpd.service
%config(noreplace) %_sysconfdir/sysconfig/snmpd
%config(noreplace) %_sysconfdir/logrotate.d/snmpd
%config(noreplace) %attr(0640,snmp,root) %_sysconfdir/snmp/snmpd.conf
%_sbindir/snmpd
%_bindir/net-snmp-create-v3-user
%_bindir/encode_keychange
%_man5dir/snmpd.conf.*
%_man5dir/snmpd.examples.*
%_man5dir/snmpd.internal*
%_man5dir/snmp_config.*
%_man5dir/variables.*
%_man8dir/snmpd.*

%files -n %_name-snmptrapd
%_initdir/snmptrapd
%_unitdir/snmptrapd.service
%config(noreplace) %_sysconfdir/sysconfig/snmptrapd
%_sbindir/snmptrapd
%_man5dir/snmptrapd.conf.*
%_man8dir/snmptrapd.*

%files -n %_name-clients
%_bindir/agentxtrap
%_bindir/snmpbulkget
%_bindir/snmpbulkwalk
%_bindir/snmpdelta
%_bindir/snmpdf
%_bindir/snmpget
%_bindir/snmpgetnext
%_bindir/snmpinform
%_bindir/snmpnetstat
%_bindir/snmpset
%_bindir/snmpstatus
%_bindir/snmptable
%_bindir/snmptest
%_bindir/snmptls
%_bindir/snmptranslate
%_bindir/snmptrap
%_bindir/snmpusm
%_bindir/snmpvacm
%_bindir/snmpwalk
%_bindir/snmpping
%_bindir/snmpps

%_man1dir/agentxtrap.*
%_man1dir/encode_keychange*
%_man1dir/net-snmp-create-v3-user.*
%_man1dir/snmpbulkget.*
%_man1dir/snmpbulkwalk.*
%_man1dir/snmpcmd.*
%_man1dir/snmpdelta.*
%_man1dir/snmpdf.*
%_man1dir/snmpget.*
%_man1dir/snmpgetnext.*
%_man1dir/snmpinform.*
%_man1dir/snmpnetstat.*
%_man1dir/snmpset.*
%_man1dir/snmpstatus.*
%_man1dir/snmptable.*
%_man1dir/snmptest.*
%_man1dir/snmptranslate.*
%_man1dir/snmptrap.*
%_man1dir/snmpusm.*
%_man1dir/snmpvacm.*
%_man1dir/snmpwalk.*
%_man1dir/snmpps.*
%_man5dir/snmp.conf.*

%files -n %_name-utils
%doc local/README.mib2c
%_datadir/snmp/mib2c-data
%_datadir/snmp/mib2c.*.conf
%_datadir/snmp/mib2c.conf
%_datadir/snmp/snmpconf-data

%_bindir/checkbandwidth
%_bindir/mib2c
%_bindir/mib2c-update
%_bindir/snmpconf
%_bindir/tkmib
%_bindir/traptoemail

%_man1dir/mib2c*
%_man1dir/snmpconf.*
%_man1dir/tkmib.*
%_man1dir/traptoemail.*
%_man5dir/mib2c.*

%files -n %_name-bridge-mib
%_bindir/snmp-bridge-mib
%_man1dir/snmp-bridge-mib.*

%files -n %_name-cert
%_bindir/net-snmp-cert

%files -n lib%name
%_libdir/libnetsnmp.so.*

%files -n lib%name-agent
%_libdir/libnetsnmpagent.so.*
%_libdir/libnetsnmphelpers.so.*
%_libdir/libnetsnmpmibs.so.*
%_libdir/libnetsnmptrapd.so.*

%files -n lib%_name-devel
%doc net-snmp-mibs.tar.bz2
%_libdir/*.so
%_includedir/*
%_man3dir/*
%_pkgconfigdir/*.pc
%_bindir/net-snmp-config
%_man1dir/net-snmp-config.*

%if_enabled static
%files -n lib%_name-devel-static
%_libdir/libnetsnmp.a
%_libdir/libnetsnmpagent.a
%_libdir/libnetsnmphelpers.a
%_libdir/libnetsnmpmibs.a
%_libdir/libnetsnmptrapd.a
%endif

%if_enabled mibs
%files -n %_name-mibs
%_datadir/snmp/mibs
%endif

%files -n perl-SNMP
%doc perl/SNMP/{examples,README,BUG,TODO}
%_datadir/snmp/snmp_perl.pl
%_datadir/snmp/snmp_perl_trapd.pl
%perl_vendor_archlib/SNMP*
%perl_vendor_autolib/SNMP*
%perl_vendor_archlib/NetSNMP*
%perl_vendor_autolib/NetSNMP*
%perl_vendor_archlib/Bundle/MakefileSubs.pm

%files -n python3-module-netsnmp
%python3_sitelibdir/*
%doc python/README

%changelog
