%def_without tests

Name: neard
Version: 0.19
Release: alt1

Summary: NFC for Linux
License: GPLv2
Group: System/Kernel and hardware

# git://git.kernel.org/pub/scm/network/nfc/neard
Url: http://01.org/linux-nfc/
Source0: https://www.kernel.org/pub/linux/network/nfc/neard-%version.tar
Source1: neard.service
Source2: 99-neard.rules
Source3: neard.init
Patch: neard-0.13-fix-dbus_send_destination_config.patch
Packager: Michael Shigorin <mike@altlinux.org>

# Automatically added by buildreq on Fri Feb 27 2015
# optimized out: libcloog-isl4 pkg-config
BuildRequires: glib2-devel libdbus-devel libnl-devel autoconf-archive

# unit dirs
BuildRequires: systemd systemd-devel

%description
NFC support for Linux.

%package devel
Summary: Files needed for NFC development
Group: Development/C

%description devel
Files needed to develop applications for the NFC stack.

%if_with tests
%package test
Summary: Files needed for NFC development
Group: Development/Other
Requires: neard

%description test
Files needed to test applications for the NFC stack.
%endif

%prep
%setup
%patch -p1

%build
%autoreconf
%if_with tests
%configure --enable-tools --enable-test
%else
%configure --enable-tools
%endif
%make_build

%install
%makeinstall_std
install -pDm644 %SOURCE1 %buildroot%_unitdir/neard.service
install -pDm644 %SOURCE2 %buildroot%_udevrulesdir/99-neard.rules
install -pDm755 %SOURCE3 %buildroot%_initdir/neard

%files
%doc AUTHORS COPYING ChangeLog README
%config %_sysconfdir/dbus-1/system.d/org.neard.conf
%dir %_libexecdir/nfc/
%_libexecdir/nfc/neard
%_udevrulesdir//99-neard.rules
%_unitdir/neard.service
%_initdir/neard
%_bindir/nfctool
%_bindir/nciattach
%_man1dir/*
%_man5dir/*
%_man8dir/*

%files devel
%_includedir/near/
%_includedir/version.h
%_pkgconfigdir/*.pc

%if_with tests
%files test
%dir %_libdir/%name/
%_libdir/%name/test/
%endif

%changelog
