%def_with keyutils
# too old kernel in hasher
%def_disable check

Name: ndctl
Version: 83
Release: alt1

Summary: Manage NVDIMM subsystem devices (Non-volatile Memory)
License: LGPL-2.1 and GPL-2.0
Group: System/Base
Url: https://github.com/pmem/ndctl

Vcs: https://github.com/pmem/ndctl.git

Source: %url/archive/v%version/%name-%version.tar.gz

Requires: lib%name = %EVR
Requires: libdaxctl = %EVR
Requires: kmod

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson
BuildRequires: pkgconfig(libkmod)
BuildRequires: pkgconfig(libudev)
BuildRequires: pkgconfig(uuid)
BuildRequires: pkgconfig(json-c)
BuildRequires: pkgconfig(systemd)
BuildRequires: pkgconfig(iniparser) >= 4.1
BuildRequires: pkgconfig(libtraceevent)
BuildRequires: pkgconfig(libtracefs) >= 1.2.0
%{?_with_keyutils:BuildRequires: pkgconfig(libkeyutils)}
%{?_with_bash:BuildRequires: bash-completion >= 2.0}
BuildRequires: asciidoctor asciidoc xmlto

%description
Utility library for managing the libnvdimm (non-volatile memory device)
sub-system in the Linux kernel

%package -n lib%name
Summary: Management library for "libnvdimm" subsystem devices
License: LGPL-2.1
Group: System/Libraries
Requires: libdaxctl = %EVR

%description -n lib%name
Libraries for %name.

%package -n lib%name-devel
Summary: Development files for libndctl
License: LGPL-2.1
Group: Development/C
Requires: lib%name = %EVR

%description -n lib%name-devel
The lib%name-devel package contains libraries and header files for
developing applications that use %name.

%package -n daxctl
Summary: Manage Device-DAX instances
License: GPL-2.0
Group: System/Base
Requires: lib%name = %EVR
Requires: libdaxctl = %EVR
Requires: udev

%description -n daxctl
The daxctl utility provides enumeration and provisioning commands for
the Linux kernel Device-DAX facility. This facility enables DAX mappings
of performance / feature differentiated memory without need of a
filesystem.

%package -n libdaxctl
Summary: Management library for "Device DAX" devices
License: LGPL-2.1
Group: System/Libraries

%description -n libdaxctl
Device DAX is a facility for establishing DAX mappings of performance
feature-differentiated memory. libdaxctl provides an enumeration
control API for these devices.

%package -n libdaxctl-devel
Summary: Development files for libdaxctl
License: LGPL-2.1
Group: Development/C
Requires: libdaxctl = %EVR

%description -n libdaxctl-devel
This package contains libraries and header files for
developing applications that use libdaxctl, a library for enumerating
"Device DAX" devices.  Device DAX is a facility for establishing DAX
mappings of performance / feature-differentiated memory.

%package -n cxl
Summary: Manage CXL devices
Group: System/Base
License: GPL-2.0
Requires: libcxl = %EVR

%description -n cxl
The cxl utility provides enumeration and provisioning commands for
the Linux kernel CXL devices.

%package -n libcxl
Summary: Management library for CXL devices
License: LGPL-2.1
Group: System/Libraries

%description -n libcxl
libcxl is a library for enumerating and communicating with CXL devices.

%package -n libcxl-devel
Summary: Development files for libcxl
License: LGPL-2.1
Group: Development/C
Requires: libcxl = %EVR

%description -n libcxl-devel
This package contains libraries and header files for developing
applications that use libcxl is a library for enumerating and
communicating with CXL devices.

%prep
%setup
sed -i 's|/usr\(/bin/systemd-escape\)|\1|' daxctl/90-daxctl-device.rules

%build
%meson \
    -Dversion-tag='%version' \
    -Dbashcompletiondir=%_datadir/bash-completion/completions \
    %{subst_enable_meson_bool keyutils keyutils} \
    %{subst_enable_meson_feature check test}
%nil
%meson_build

%install
%meson_install

%check
%__meson_test

%files
%_bindir/%name
%_man1dir/%{name}*
%dir %_sysconfdir/%name
%dir %_sysconfdir/%name/keys
%_sysconfdir/%name/keys/keys.readme
%dir %_sysconfdir/%name.conf.d
%config(noreplace) %_sysconfdir/%name.conf.d/monitor.conf
%config(noreplace) %_sysconfdir/%name.conf.d/%name.conf
%config(noreplace) %_sysconfdir/modprobe.d/nvdimm-security.conf
%_unitdir/%name-monitor.service
%_datadir/bash-completion/completions/cxl
%_datadir/bash-completion/completions/daxctl
%_datadir/bash-completion/completions/%name

%files -n lib%name
%_libdir/lib%name.so.*
%doc README.md

%files -n lib%name-devel
%_includedir/%name/
%_libdir/lib%name.so
%_pkgconfigdir/lib%name.pc

%files -n daxctl
%_bindir/daxctl
%dir %_sysconfdir/daxctl.conf.d
%_udevrulesdir/90-daxctl-device.rules
%_sysconfdir/daxctl.conf.d/daxctl.example.conf
%_unitdir/daxdev-reconfigure@.service
%_man1dir/daxctl*
%dir %_datadir/daxctl
%_datadir/daxctl/daxctl.conf

%files -n libdaxctl
%_libdir/libdaxctl.so.*
%doc README.md

%files -n libdaxctl-devel
%_includedir/daxctl/
%_libdir/libdaxctl.so
%_pkgconfigdir/libdaxctl.pc

%files -n cxl
%_bindir/cxl
%_unitdir/cxl-monitor.service
%_man1dir/cxl*

%files -n libcxl
%_libdir/libcxl.so.*
%doc README.md

%files -n libcxl-devel
%_includedir/cxl/
%_libdir/libcxl.so
%_pkgconfigdir/libcxl.pc
%_man3dir/*cxl*

%changelog
