%def_disable snapshot

%define _libexecdir %_prefix/libexec
%define ver_major 49
%define beta %nil
%define api_ver 4.1
%define ext_api_ver 4
%define ext_sover 4
%define xdg_name org.gnome.Nautilus

%def_enable extensions
%def_enable packagekit
%def_enable tracker
%def_enable introspection
%def_enable selinux
%def_enable docs
%def_disable check

Name: nautilus
Version: %ver_major.2
Release: alt1%beta

Summary: Nautilus is a network user environment
License: GPL-2.0-or-later and GPL-3.0-or-later
Group: Graphical desktop/GNOME
Url: https://apps.gnome.org/Nautilus

Vcs: https://gitlab.gnome.org/GNOME/nautilus.git

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version%beta.tar
%endif

%define desktop_file_utils_ver 0.8
%define glib_ver 2.84.0
%define desktop_ver 43
%define pango_ver 1.28.3
%define gtk4_ver 4.16
%define adwaita_ver 1.6
%define libxml2_ver 2.7.8
%define gexiv2_ver 0.14.2
%define gir_ver 0.10.2
%define tracker_ver 3.8
%define autoar_ver 0.4.4
%define portal_ver 0.5
%define selinux_ver 2.0

Requires(post): libcap-utils
Requires: lib%name = %version-%release
Requires: shared-mime-info
Requires: common-licenses
Requires: gvfs >= 1.34
Requires: %_bindir/bwrap
Requires: totem-video-thumbnailer
Requires: gnome-disk-utility
%{?_enable_tracker:Requires: tinysparql localsearch}

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson desktop-file-utils >= %desktop_file_utils_ver
BuildRequires: /usr/bin/appstreamcli
BuildRequires: libgio-devel >= %glib_ver
BuildRequires: pkgconfig(gnome-desktop-4) >= %desktop_ver
BuildRequires: libpango-devel >= %pango_ver
BuildRequires: libgtk4-devel >= %gtk4_ver
BuildRequires: pkgconfig(libadwaita-1) >= %adwaita_ver
BuildRequires: libportal-gtk4-devel >= %portal_ver
BuildRequires: gsettings-desktop-schemas-devel
BuildRequires: libxml2-devel >= %libxml2_ver
BuildRequires: libgnome-autoar-devel >= %autoar_ver
BuildRequires: libseccomp-devel
BuildRequires: libcloudproviders-devel
BuildRequires: pkgconfig(icu-uc) pkgconfig(icu-i18n)
%{?_enable_extensions:BuildRequires: libgexiv2-devel >= %gexiv2_ver
BuildRequires: pkgconfig(gstreamer-tag-1.0) pkgconfig(gstreamer-pbutils-1.0)}
%{?_enable_docs:BuildRequires: docbook-utils gi-docgen}
%{?_enable_tracker:BuildRequires: pkgconfig(tracker-sparql-3.0) >= %tracker_ver localsearch}
%{?_enable_introspection:
BuildRequires(pre): rpm-build-gir
BuildRequires: gobject-introspection-devel >= %gir_ver libgtk4-gir-devel}
%{?_enable_selinux:BuildRequires: libselinux-devel >= %selinux_ver}
%{?_enable_check:
BuildRequires(pre): rpm-build-python3
BuildRequires: xvfb-run dbus-tools-gui /proc}

%description
Nautilus integrates access to files, applications, media, Internet-based
resources and the Web.  Nautilus delivers a dynamic and rich user
experience.  Nautilus is an free software project developed under the
GNU General Public License and is a core component of the GNOME desktop
project.

%package -n lib%name
Summary: Shared libraries needed to run Nautilus
Group: System/Libraries

%description -n lib%name
This package contains shared libraries needed to run Nautilus and its
components.

%package -n lib%name-devel
Summary: Libraries and include files for developing Nautilus components
Group: Development/GNOME and GTK+
Requires: lib%name = %version-%release

%description -n lib%name-devel
This package provides the necessary development libraries and include
files to allow you to develop Nautilus components.

%package -n lib%name-devel-doc
Summary: Development documentation for %name
Group: Development/Documentation
Conflicts: lib%name-devel < %version-%release
BuildArch: noarch

%description -n lib%name-devel-doc
This package contains development documentation for the %name.

%package -n lib%name-gir
Summary: GObject introspection data for the nautilus-extension library
Group: System/Libraries
Requires: lib%name = %version-%release

%description -n lib%name-gir
GObject introspection data for the nautilus-extension library

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the nautilus-extension library
Group: System/Libraries
BuildArch: noarch
Requires: lib%name-gir = %version-%release

%description -n lib%name-gir-devel
GObject introspection devel data for the nautilus-extension library

%define _gtk_docdir %_datadir/gtk-doc/html

%prep
%setup -n %name-%version%beta

%ifarch %e2k
# xdp-gnome/externalwindow-wayland.c ftbfs as of lcc 1.29.06:
#  74 static struct mutter_x11_interop *x11_interop = NULL;
# 222   struct mutter_x11_interop **x11_interop = user_data;
sed -i '/-Werror=shadow/d' meson.build
%endif

%build
%meson \
    %{subst_enable_meson_bool docs docs} \
    %{subst_enable_meson_bool extensions extensions} \
    %{subst_enable_meson_bool packagekit packagekit} \
    %{subst_enable_meson_bool selinux selinux}
%meson_build

%install
%meson_install
bzip2 -9fk NEWS
# The license
ln -sf %_licensedir/LGPL-2 COPYING
%find_lang %name

%check
%meson_test

%files -f %name.lang
%_bindir/*
%{?_enable_extensions:%dir %_libdir/%name}
%_desktopdir/*.desktop
%_datadir/dbus-1/services/%xdg_name.service
%_datadir/dbus-1/services/org.freedesktop.FileManager1.service
%_datadir/gnome-shell/search-providers/%xdg_name.search-provider.ini
%_iconsdir/hicolor/scalable/apps/%xdg_name.svg
%_iconsdir/hicolor/symbolic/apps/%xdg_name-symbolic.svg
%config %_datadir/glib-2.0/schemas/org.gnome.nautilus.gschema.xml
%_datadir/metainfo/%xdg_name.metainfo.xml
%dir %_datadir/%name
%dir %_datadir/%name/ontology
%_datadir/%name/ontology/%name.description
%_datadir/%name/ontology/%name.ontology
# docs
%doc --no-dereference COPYING
%doc NEWS.bz2 README*
%{?_enable_docs:%_man1dir/*}

%files -n lib%name
%_libdir/lib%name-extension.so.%{ext_sover}*
%{?_enable_extensions:
%dir %_libdir/%name/extensions-%ext_api_ver
%_libdir/%name/extensions-%ext_api_ver/libnautilus-image-properties.so
%_libdir/%name/extensions-%ext_api_ver/libtotem-properties-page.so}

%files -n lib%name-devel
%_includedir/%name
%_libdir/lib%name-extension.so
%_pkgconfigdir/lib%name-extension-%ext_sover.pc

%if_enabled docs
%files -n lib%name-devel-doc
%_datadir/doc/%name/
%endif

%if_enabled introspection
%files -n lib%name-gir
%_typelibdir/Nautilus-%api_ver.typelib

%files -n lib%name-gir-devel
%_girdir/Nautilus-%api_ver.gir
%endif


%changelog
